/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Category;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Syntax {
    Function{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, fun + "(", ", ", ")");
        }
    }
    ,
    Property{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(pw);
            pw.print(".");
            pw.print(fun);
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.getTypeDescription(argTypes[0]) + "." + name;
        }
    }
    ,
    Method{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(pw);
            pw.print(".");
            pw.print(fun);
            pw.print("(");
            for (int i = 1; i < args.length; ++i) {
                if (i > 1) {
                    pw.print(", ");
                }
                args[i].unparse(pw);
            }
            pw.print(")");
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return (returnType == 0 ? "" : Syntax.getTypeDescription(returnType) + " ") + Syntax.getTypeDescription(argTypes[0]) + "." + name + "(" + Syntax.getTypeDescriptionCommaList(argTypes, 1) + ")";
        }
    }
    ,
    Infix{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(pw, args, "(", " " + fun + " ", ")");
            } else {
                ExpBase.unparseList(pw, args, "", " " + fun + " ", "");
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.getTypeDescription(argTypes[0]) + " " + name + " " + Syntax.getTypeDescription(argTypes[1]);
        }
    }
    ,
    Prefix{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(pw, args, "(" + fun + " ", null, ")");
            } else {
                ExpBase.unparseList(pw, args, fun + " ", null, "");
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return name + " " + Syntax.getTypeDescription(argTypes[0]);
        }
    }
    ,
    Postfix{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(pw, args, "(", null, " " + fun + ")");
            } else {
                ExpBase.unparseList(pw, args, "", null, " " + fun);
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.getTypeDescription(argTypes[0]) + " " + name;
        }
    }
    ,
    Braces{

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "{" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + "}";
        }

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, "{", ", ", "}");
        }
    }
    ,
    Parentheses{

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "(" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + ")";
        }

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, "(", ", ", ")");
        }
    }
    ,
    Case{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (fun.equals("_CaseTest")) {
                pw.print("CASE");
                int j = 0;
                int clauseCount = (args.length - j) / 2;
                for (int i = 0; i < clauseCount; ++i) {
                    pw.print(" WHEN ");
                    args[j++].unparse(pw);
                    pw.print(" THEN ");
                    args[j++].unparse(pw);
                }
                if (j < args.length) {
                    pw.print(" ELSE ");
                    args[j++].unparse(pw);
                }
                Util.assertTrue(j == args.length);
                pw.print(" END");
            } else {
                Util.assertTrue(fun.equals("_CaseMatch"));
                pw.print("CASE ");
                int j = 0;
                args[j++].unparse(pw);
                int clauseCount = (args.length - j) / 2;
                for (int i = 0; i < clauseCount; ++i) {
                    pw.print(" WHEN ");
                    args[j++].unparse(pw);
                    pw.print(" THEN ");
                    args[j++].unparse(pw);
                }
                if (j < args.length) {
                    pw.print(" ELSE ");
                    args[j++].unparse(pw);
                }
                Util.assertTrue(j == args.length);
                pw.print(" END");
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            String s = Syntax.getTypeDescription(argTypes[0]);
            if (argTypes[0] == 5) {
                return "CASE WHEN " + s + " THEN <Expression> ... END";
            }
            return "CASE " + s + " WHEN " + s + " THEN <Expression> ... END";
        }
    }
    ,
    Internal,
    Cast{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            pw.print("CAST(");
            args[0].unparse(pw);
            pw.print(" AS ");
            args[1].unparse(pw);
            pw.print(")");
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "CAST(<Expression> AS <Type>)";
        }
    }
    ,
    QuotedProperty,
    AmpersandQuotedProperty,
    Empty{

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            assert (args.length == 0);
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "";
        }
    };


    public void unparse(String fun, Exp[] args, PrintWriter pw) {
        throw new UnsupportedOperationException();
    }

    public String getSignature(String name, int returnType, int[] argTypes) {
        return (returnType == 0 ? "" : Syntax.getTypeDescription(returnType) + " ") + name + "(" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + ")";
    }

    private static boolean needParen(Exp[] args) {
        return args.length != 1 || !(args[0] instanceof FunCall) || ((FunCall)args[0]).getSyntax() != Parentheses;
    }

    private static String getTypeDescription(int type) {
        return "<" + Category.instance.getDescription(type & 0x1F) + ">";
    }

    private static String getTypeDescriptionCommaList(int[] types, int start) {
        int initialSize = (types.length - start) * 16;
        StringBuilder sb = new StringBuilder(initialSize > 0 ? initialSize : 16);
        for (int i = start; i < types.length; ++i) {
            if (i > start) {
                sb.append(", ");
            }
            sb.append("<").append(Category.instance.getDescription(types[i] & 0x1F)).append(">");
        }
        return sb.toString();
    }
}

