/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Category;
import mondrian.olap.CellProperty;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MemoryLimitExceededException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.Property;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.ResultStyleException;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.ValidatorImpl;
import mondrian.olap.Walker;
import mondrian.olap.fun.ParameterFunDef;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
extends QueryPart {
    public Formula[] formulas;
    public QueryAxis[] axes;
    public QueryAxis slicerAxis;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final Map<String, Parameter> parametersByName = new HashMap<String, Parameter>();
    private final QueryPart[] cellProps;
    private final Cube cube;
    private final Connection connection;
    public Calc[] axisCalcs;
    public Calc slicerCalc;
    Set<FunDef> alertedNonNativeFunDefs;
    private long startTime;
    private long queryTimeout;
    private boolean isCanceled;
    private String outOfMemoryMsg;
    private boolean isExecuting;
    private Set<Member> measuresMembers;
    private boolean nativeCrossJoinVirtualCube;
    private List<RolapCube> baseCubes;
    private boolean load;
    private boolean strictValidation;
    private ResultStyle resultStyle = Util.Retrowoven ? ResultStyle.LIST : ResultStyle.ITERABLE;
    private Map<String, Object> evalCache = new HashMap<String, Object>();

    public Query(Connection connection, Formula[] formulas, QueryAxis[] axes, String cube, QueryAxis slicerAxis, QueryPart[] cellProps, boolean load, boolean strictValidation) {
        this(connection, Util.lookupCube(connection.getSchemaReader(), cube, true), formulas, axes, slicerAxis, cellProps, new Parameter[0], load, strictValidation);
    }

    public Query(Connection connection, Cube mdxCube, Formula[] formulas, QueryAxis[] axes, QueryAxis slicerAxis, QueryPart[] cellProps, Parameter[] parameters, boolean load, boolean strictValidation) {
        this.connection = connection;
        this.cube = mdxCube;
        this.formulas = formulas;
        this.axes = axes;
        this.normalizeAxes();
        this.slicerAxis = slicerAxis;
        this.cellProps = cellProps;
        this.parameters.addAll(Arrays.asList(parameters));
        this.isExecuting = false;
        this.queryTimeout = MondrianProperties.instance().QueryTimeout.get() * 1000;
        this.measuresMembers = new HashSet<Member>();
        this.nativeCrossJoinVirtualCube = true;
        this.load = load;
        this.strictValidation = strictValidation;
        this.alertedNonNativeFunDefs = new HashSet<FunDef>();
        this.resolve();
    }

    public void setQueryTimeoutMillis(long queryTimeoutMillis) {
        this.queryTimeout = queryTimeoutMillis;
    }

    public boolean hasCellProperty(String propertyName) {
        for (QueryPart cellProp : this.cellProps) {
            if (!((CellProperty)cellProp).isNameEquals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public boolean isCellPropertyEmpty() {
        return this.cellProps.length == 0;
    }

    public void addFormula(Id id, Exp exp) {
        this.addFormula(id, exp, new MemberProperty[0]);
    }

    public void addFormula(Id id, Exp exp, MemberProperty[] memberProperties) {
        Formula newFormula = new Formula(id, exp, memberProperties);
        int formulaCount = 0;
        if (this.formulas.length > 0) {
            formulaCount = this.formulas.length;
        }
        Formula[] newFormulas = new Formula[formulaCount + 1];
        System.arraycopy(this.formulas, 0, newFormulas, 0, formulaCount);
        newFormulas[formulaCount] = newFormula;
        this.formulas = newFormulas;
        this.resolve();
    }

    public Validator createValidator() {
        return new QueryValidator(this.connection.getSchema().getFunTable());
    }

    public Validator createValidator(FunTable functionTable) {
        return new QueryValidator(functionTable);
    }

    public Object clone() {
        return new Query(this.connection, this.cube, Formula.cloneArray(this.formulas), QueryAxis.cloneArray(this.axes), this.slicerAxis == null ? null : (QueryAxis)this.slicerAxis.clone(), this.cellProps, this.parameters.toArray(new Parameter[this.parameters.size()]), this.load, this.strictValidation);
    }

    public Query safeClone() {
        return (Query)this.clone();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    void setOutOfMemory(String msg) {
        this.outOfMemoryMsg = msg;
    }

    public void checkCancelOrTimeout() {
        long currTime;
        if (!this.isExecuting) {
            return;
        }
        if (this.isCanceled) {
            throw MondrianResource.instance().QueryCanceled.ex();
        }
        if (this.queryTimeout > 0L && (currTime = System.currentTimeMillis()) - this.startTime >= this.queryTimeout) {
            throw MondrianResource.instance().QueryTimeout.ex(this.queryTimeout / 1000L);
        }
        if (this.outOfMemoryMsg != null) {
            throw new MemoryLimitExceededException(this.outOfMemoryMsg);
        }
    }

    public void setQueryStartTime() {
        this.startTime = System.currentTimeMillis();
        this.isExecuting = true;
    }

    public long getQueryStartTime() {
        return this.startTime;
    }

    public void setQueryEndExecution() {
        this.isExecuting = false;
    }

    public boolean shouldAlertForNonNative(FunDef funDef) {
        return this.alertedNonNativeFunDefs.add(funDef);
    }

    private void normalizeAxes() {
        block0: for (int i = 0; i < this.axes.length; ++i) {
            AxisOrdinal correctOrdinal = AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(i);
            if (this.axes[i].getAxisOrdinal() == correctOrdinal) continue;
            for (int j = i + 1; j < this.axes.length; ++j) {
                if (this.axes[j].getAxisOrdinal() != correctOrdinal) continue;
                QueryAxis temp = this.axes[i];
                this.axes[i] = this.axes[j];
                this.axes[j] = temp;
                continue block0;
            }
        }
    }

    public void resolve() {
        Validator validator = this.createValidator();
        this.resolve(validator);
        Evaluator evaluator = RolapUtil.createEvaluator(this);
        ExpCompiler compiler = this.createCompiler(evaluator, validator, Collections.singletonList(this.resultStyle));
        this.compile(compiler);
    }

    public boolean ignoreInvalidMembers() {
        MondrianProperties props = MondrianProperties.instance();
        return !this.strictValidation && (this.load && props.IgnoreInvalidMembers.get() || !this.load && props.IgnoreInvalidMembersDuringQuery.get());
    }

    public void setResultStyle(ResultStyle resultStyle) {
        switch (resultStyle) {
            case ITERABLE: {
                this.resultStyle = Util.Retrowoven ? ResultStyle.LIST : ResultStyle.ITERABLE;
                break;
            }
            case LIST: 
            case MUTABLE_LIST: {
                this.resultStyle = resultStyle;
                break;
            }
            default: {
                throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, resultStyle);
            }
        }
    }

    public ResultStyle getResultStyle() {
        return this.resultStyle;
    }

    private void compile(ExpCompiler compiler) {
        if (this.formulas != null) {
            for (Formula formula : this.formulas) {
                formula.compile();
            }
        }
        if (this.axes != null) {
            this.axisCalcs = new Calc[this.axes.length];
            for (int i = 0; i < this.axes.length; ++i) {
                this.axisCalcs[i] = this.axes[i].compile(compiler, this.resultStyle);
            }
        }
        if (this.slicerAxis != null) {
            this.slicerCalc = this.slicerAxis.compile(compiler, this.resultStyle);
        }
    }

    public void resolve(Validator validator) {
        Dimension[] dimensions;
        if (this.formulas != null) {
            for (Formula formula : this.formulas) {
                formula.createElement(validator.getQuery());
            }
        }
        this.parameters.clear();
        this.parametersByName.clear();
        this.accept(new MdxVisitorImpl(){

            public Object visit(ParameterExpr parameterExpr) {
                Parameter parameter = parameterExpr.getParameter();
                if (!Query.this.parameters.contains(parameter)) {
                    Query.this.parameters.add(parameter);
                    Query.this.parametersByName.put(parameter.getName(), parameter);
                }
                return null;
            }

            public Object visit(UnresolvedFunCall call) {
                if (call.getFunName().equals("Parameter")) {
                    String parameterName = ParameterFunDef.getParameterName(call.getArgs());
                    if (Query.this.parametersByName.get(parameterName) != null) {
                        throw MondrianResource.instance().ParameterDefinedMoreThanOnce.ex(parameterName);
                    }
                    Type type = ParameterFunDef.getParameterType(call.getArgs());
                    ParameterImpl parameter = new ParameterImpl(parameterName, Literal.nullValue, null, type);
                    Query.this.parameters.add(parameter);
                    Query.this.parametersByName.put(parameterName, parameter);
                }
                return null;
            }
        });
        if (this.formulas != null) {
            for (Formula formula : this.formulas) {
                validator.validate(formula);
            }
        }
        if (this.axes != null) {
            HashSet<Integer> axisNames = new HashSet<Integer>();
            for (QueryAxis axis : this.axes) {
                validator.validate(axis);
                if (axisNames.add(axis.getAxisOrdinal().logicalOrdinal())) continue;
                throw MondrianResource.instance().DuplicateAxis.ex(axis.getAxisName());
            }
            int seekOrdinal = AxisOrdinal.StandardAxisOrdinal.COLUMNS.logicalOrdinal();
            for (QueryAxis axis : this.axes) {
                if (!axisNames.contains(seekOrdinal)) {
                    AxisOrdinal axisName = AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(seekOrdinal);
                    throw MondrianResource.instance().NonContiguousAxis.ex(seekOrdinal, axisName.name());
                }
                ++seekOrdinal;
            }
        }
        if (this.slicerAxis != null) {
            this.slicerAxis.validate(validator);
        }
        for (Dimension dimension : dimensions = this.getCube().getDimensions()) {
            int useCount = 0;
            for (int j = -1; j < this.axes.length; ++j) {
                QueryAxis axisExp;
                if (j < 0) {
                    if (this.slicerAxis == null) continue;
                    axisExp = this.slicerAxis;
                } else {
                    axisExp = this.axes[j];
                }
                if (!axisExp.getSet().getType().usesDimension(dimension, true)) continue;
                ++useCount;
            }
            if (useCount <= true) continue;
            throw MondrianResource.instance().DimensionInIndependentAxes.ex(dimension.getUniqueName());
        }
    }

    @Override
    public void unparse(PrintWriter pw) {
        int i;
        if (this.formulas != null) {
            for (i = 0; i < this.formulas.length; ++i) {
                if (i == 0) {
                    pw.print("with ");
                } else {
                    pw.print("  ");
                }
                this.formulas[i].unparse(pw);
                pw.println();
            }
        }
        pw.print("select ");
        if (this.axes != null) {
            for (i = 0; i < this.axes.length; ++i) {
                this.axes[i].unparse(pw);
                if (i < this.axes.length - 1) {
                    pw.println(",");
                    pw.print("  ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.cube != null) {
            pw.println("from [" + this.cube.getName() + "]");
        }
        if (this.slicerAxis != null) {
            pw.print("where ");
            this.slicerAxis.unparse(pw);
            pw.println();
        }
    }

    public String toString() {
        this.resolve();
        return Util.unparse(this);
    }

    @Override
    public Object[] getChildren() {
        ArrayList<QueryPart> list = new ArrayList<QueryPart>();
        list.addAll(Arrays.asList(this.axes));
        if (this.slicerAxis != null) {
            list.add(this.slicerAxis);
        }
        list.addAll(Arrays.asList(this.formulas));
        return list.toArray();
    }

    public QueryAxis getSlicerAxis() {
        return this.slicerAxis;
    }

    public void setSlicerAxis(QueryAxis axis) {
        this.slicerAxis = axis;
    }

    public void addLevelToAxis(AxisOrdinal axis, Level level) {
        assert (axis != null);
        this.axes[axis.logicalOrdinal()].addLevel(level);
    }

    private Hierarchy[] collectHierarchies(Exp queryPart) {
        Type exprType = queryPart.getType();
        if (exprType instanceof SetType) {
            exprType = ((SetType)exprType).getElementType();
        }
        if (exprType instanceof TupleType) {
            Type[] types = ((TupleType)exprType).elementTypes;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (Type type : types) {
                hierarchyList.add(this.getTypeHierarchy(type));
            }
            return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
        }
        return new Hierarchy[]{this.getTypeHierarchy(exprType)};
    }

    private Hierarchy getTypeHierarchy(Type type) {
        Hierarchy hierarchy = type.getHierarchy();
        if (hierarchy != null) {
            return hierarchy;
        }
        Dimension dimension = type.getDimension();
        if (dimension != null) {
            return dimension.getHierarchy();
        }
        return null;
    }

    public void setParameter(String parameterName, String value) {
        Parameter param;
        if (this.parameters.isEmpty()) {
            this.resolve();
        }
        if ((param = this.getSchemaReader(false).getParameter(parameterName)) == null) {
            throw MondrianResource.instance().UnknownParameter.ex(parameterName);
        }
        if (!param.isModifiable()) {
            throw MondrianResource.instance().ParameterIsNotModifiable.ex(parameterName, param.getScope().name());
        }
        Exp exp = Query.quickParse(TypeUtil.typeToCategory(param.getType()), value, this);
        param.setValue(exp);
    }

    private static Exp quickParse(int category, String value, Query query) {
        switch (category) {
            case 7: {
                return Literal.create(new Double(value));
            }
            case 9: {
                return Literal.createString(value);
            }
            case 6: {
                Member member = (Member)Util.lookup(query, Util.parseIdentifier(value));
                return new MemberExpr(member);
            }
        }
        throw Category.instance.badValue(category);
    }

    public void swapAxes() {
        if (this.axes.length == 2) {
            Exp e0 = this.axes[0].getSet();
            boolean nonEmpty0 = this.axes[0].isNonEmpty();
            Exp e1 = this.axes[1].getSet();
            boolean nonEmpty1 = this.axes[1].isNonEmpty();
            this.axes[1].setSet(e0);
            this.axes[1].setNonEmpty(nonEmpty0);
            this.axes[0].setSet(e1);
            this.axes[0].setNonEmpty(nonEmpty1);
        }
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    public Cube getCube() {
        return this.cube;
    }

    public SchemaReader getSchemaReader(boolean accessControlled) {
        Role role = accessControlled ? this.getConnection().getRole() : null;
        SchemaReader cubeSchemaReader = this.cube.getSchemaReader(role);
        return new QuerySchemaReader(cubeSchemaReader);
    }

    public Member lookupMemberFromCache(String memberUniqueName) {
        for (Member member : this.getDefinedMembers()) {
            if (!Util.equalName(member.getUniqueName(), memberUniqueName) && !Util.equalName(this.getUniqueNameWithoutAll(member), memberUniqueName)) continue;
            return member;
        }
        return null;
    }

    private String getUniqueNameWithoutAll(Member member) {
        Member parentMember = member.getParentMember();
        if (parentMember != null && !parentMember.isAll()) {
            return Util.makeFqName(this.getUniqueNameWithoutAll(parentMember), member.getName());
        }
        return Util.makeFqName(member.getHierarchy(), member.getName());
    }

    private NamedSet lookupNamedSet(String name) {
        for (Formula formula : this.formulas) {
            if (formula.isMember() || formula.getElement() == null || !formula.getName().equals(name)) continue;
            return (NamedSet)formula.getElement();
        }
        return null;
    }

    public Formula[] getFormulas() {
        return this.formulas;
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public void removeFormula(String uniqueName, boolean failIfUsedInQuery) {
        Formula formula = this.findFormula(uniqueName);
        if (failIfUsedInQuery && formula != null) {
            OlapElement mdxElement = formula.getElement();
            Walker walker = new Walker(this);
            while (walker.hasMoreElements()) {
                Object queryElement = walker.nextElement();
                if (!queryElement.equals(mdxElement)) continue;
                String formulaType = formula.isMember() ? MondrianResource.instance().CalculatedMember.str() : MondrianResource.instance().CalculatedSet.str();
                int i = 0;
                Object parent = walker.getAncestor(i);
                Object grandParent = walker.getAncestor(i + 1);
                while (parent != null && grandParent != null) {
                    if (grandParent instanceof Query) {
                        if (parent instanceof Axis) {
                            throw MondrianResource.instance().MdxCalculatedFormulaUsedOnAxis.ex(formulaType, uniqueName, ((QueryAxis)parent).getAxisName());
                        }
                        if (parent instanceof Formula) {
                            String parentFormulaType = ((Formula)parent).isMember() ? MondrianResource.instance().CalculatedMember.str() : MondrianResource.instance().CalculatedSet.str();
                            throw MondrianResource.instance().MdxCalculatedFormulaUsedInFormula.ex(formulaType, uniqueName, parentFormulaType, ((Formula)parent).getUniqueName());
                        }
                        throw MondrianResource.instance().MdxCalculatedFormulaUsedOnSlicer.ex(formulaType, uniqueName);
                    }
                    parent = walker.getAncestor(++i);
                    grandParent = walker.getAncestor(i + 1);
                }
                throw MondrianResource.instance().MdxCalculatedFormulaUsedInQuery.ex(formulaType, uniqueName, Util.unparse(this));
            }
        }
        ArrayList<Formula> formulaList = new ArrayList<Formula>();
        for (Formula formula1 : this.formulas) {
            if (formula1.getUniqueName().equalsIgnoreCase(uniqueName)) continue;
            formulaList.add(formula1);
        }
        this.formulas = formulaList.toArray(new Formula[0]);
    }

    public boolean canRemoveFormula(String uniqueName) {
        Formula formula = this.findFormula(uniqueName);
        if (formula == null) {
            return false;
        }
        OlapElement mdxElement = formula.getElement();
        Walker walker = new Walker(this);
        while (walker.hasMoreElements()) {
            Object queryElement = walker.nextElement();
            if (queryElement instanceof MemberExpr && ((MemberExpr)queryElement).getMember().equals(mdxElement)) {
                return false;
            }
            if (!(queryElement instanceof NamedSetExpr) || !((NamedSetExpr)queryElement).getNamedSet().equals(mdxElement)) continue;
            return false;
        }
        return true;
    }

    public Formula findFormula(String uniqueName) {
        for (Formula formula : this.formulas) {
            if (!formula.getUniqueName().equalsIgnoreCase(uniqueName)) continue;
            return formula;
        }
        return null;
    }

    public void renameFormula(String uniqueName, String newName) {
        Formula formula = this.findFormula(uniqueName);
        if (formula == null) {
            throw MondrianResource.instance().MdxFormulaNotFound.ex("formula", uniqueName, Util.unparse(this));
        }
        formula.rename(newName);
    }

    List<Member> getDefinedMembers() {
        ArrayList<Member> definedMembers = new ArrayList<Member>();
        for (Formula formula : this.formulas) {
            if (!formula.isMember() || formula.getElement() == null || !this.getConnection().getRole().canAccess(formula.getElement())) continue;
            definedMembers.add((Member)formula.getElement());
        }
        return definedMembers;
    }

    public void setAxisShowEmptyCells(int axis, boolean showEmpty) {
        if (axis >= this.axes.length) {
            throw MondrianResource.instance().MdxAxisShowSubtotalsNotSupported.ex(axis);
        }
        this.axes[axis].setNonEmpty(!showEmpty);
    }

    public Hierarchy[] getMdxHierarchiesOnAxis(AxisOrdinal axis) {
        if (axis.logicalOrdinal() >= this.axes.length) {
            throw MondrianResource.instance().MdxAxisShowSubtotalsNotSupported.ex(axis.logicalOrdinal());
        }
        QueryAxis queryAxis = axis.isFilter() ? this.slicerAxis : this.axes[axis.logicalOrdinal()];
        return this.collectHierarchies(queryAxis.getSet());
    }

    public Calc compileExpression(Exp exp, boolean scalar, ResultStyle resultStyle) {
        Evaluator evaluator = RolapEvaluator.create(this);
        Validator validator = this.createValidator();
        List<ResultStyle> resultStyleList = Collections.singletonList(resultStyle != null ? resultStyle : this.resultStyle);
        ExpCompiler compiler = this.createCompiler(evaluator, validator, resultStyleList);
        if (scalar) {
            return compiler.compileScalar(exp, false);
        }
        return compiler.compile(exp);
    }

    public ExpCompiler createCompiler() {
        Evaluator evaluator = RolapEvaluator.create(this);
        Validator validator = this.createValidator();
        return this.createCompiler(evaluator, validator, Collections.singletonList(this.resultStyle));
    }

    private ExpCompiler createCompiler(Evaluator evaluator, Validator validator, List<ResultStyle> resultStyleList) {
        ExpCompiler compiler = ExpCompiler.Factory.getExpCompiler(evaluator, validator, resultStyleList);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            compiler = RolapUtil.createDependencyTestingCompiler(compiler);
        }
        return compiler;
    }

    public void addMeasuresMembers(OlapElement olapElement) {
        Member member;
        if (olapElement instanceof Member && (member = (Member)olapElement).getDimension().getOrdinal(this.getCube()) == 0) {
            this.measuresMembers.add(member);
        }
    }

    public Set<Member> getMeasuresMembers() {
        return Collections.unmodifiableSet(this.measuresMembers);
    }

    public void setVirtualCubeNonNativeCrossJoin() {
        this.nativeCrossJoinVirtualCube = false;
    }

    public boolean nativeCrossJoinVirtualCube() {
        return this.nativeCrossJoinVirtualCube;
    }

    public void setBaseCubes(List<RolapCube> baseCubes) {
        this.baseCubes = baseCubes;
    }

    public List<RolapCube> getBaseCubes() {
        return this.baseCubes;
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        for (Formula formula : this.formulas) {
            formula.accept(visitor);
        }
        for (QueryPart queryPart : this.axes) {
            ((QueryAxis)queryPart).accept(visitor);
        }
        if (this.slicerAxis != null) {
            this.slicerAxis.accept(visitor);
        }
        return o;
    }

    public void putEvalCache(String key, Object value) {
        this.evalCache.put(key, value);
    }

    public Object getEvalCache(String key) {
        return this.evalCache.get(key);
    }

    public void clearEvalCache() {
        this.evalCache.clear();
    }

    private class QueryValidator
    extends ValidatorImpl {
        public QueryValidator(FunTable functionTable) {
            super(functionTable);
        }

        protected void defineParameter(Parameter param) {
            String name = param.getName();
            Query.this.parameters.add(param);
            Query.this.parametersByName.put(name, param);
        }

        public Query getQuery() {
            return Query.this;
        }
    }

    private static class ConnectionParameterImpl
    extends ParameterImpl {
        public ConnectionParameterImpl(String name, Literal defaultValue) {
            super(name, defaultValue, "Connection property", new StringType());
        }

        public Parameter.Scope getScope() {
            return Parameter.Scope.Connection;
        }

        public void setValue(Object value) {
            throw MondrianResource.instance().ParameterIsNotModifiable.ex(this.getName(), this.getScope().name());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuerySchemaReader
    extends DelegatingSchemaReader {
        public QuerySchemaReader(SchemaReader cubeSchemaReader) {
            super(cubeSchemaReader);
        }

        @Override
        public Member getMemberByUniqueName(List<Id.Segment> uniqueNameParts, boolean failIfNotFound, MatchType matchType) {
            String uniqueName = Util.implode(uniqueNameParts);
            Member member = Query.this.lookupMemberFromCache(uniqueName);
            if (member == null) {
                member = this.schemaReader.getMemberByUniqueName(uniqueNameParts, failIfNotFound, matchType);
            }
            if (!failIfNotFound && member == null) {
                return null;
            }
            if (this.getRole().canAccess(member)) {
                return member;
            }
            return null;
        }

        @Override
        public List<Member> getLevelMembers(Level level, boolean includeCalculated) {
            List<Member> members = super.getLevelMembers(level, false);
            if (includeCalculated) {
                members = Util.addLevelCalculatedMembers(this, level, members);
            }
            return members;
        }

        @Override
        public Member getCalculatedMember(List<Id.Segment> nameParts) {
            String uniqueName = Util.implode(nameParts);
            return Query.this.lookupMemberFromCache(uniqueName);
        }

        @Override
        public List<Member> getCalculatedMembers(Hierarchy hierarchy) {
            ArrayList<Member> result = new ArrayList<Member>();
            List<Member> calculatedMembers = super.getCalculatedMembers(hierarchy);
            result.addAll(calculatedMembers);
            for (Member member : Query.this.getDefinedMembers()) {
                if (!member.getHierarchy().equals(hierarchy)) continue;
                result.add(member);
            }
            return result;
        }

        @Override
        public List<Member> getCalculatedMembers(Level level) {
            List<Member> hierarchyMembers = this.getCalculatedMembers(level.getHierarchy());
            ArrayList<Member> result = new ArrayList<Member>();
            for (Member member : hierarchyMembers) {
                if (!member.getLevel().equals(level)) continue;
                result.add(member);
            }
            return result;
        }

        @Override
        public List<Member> getCalculatedMembers() {
            return Query.this.getDefinedMembers();
        }

        @Override
        public OlapElement getElementChild(OlapElement parent, Id.Segment s) {
            return this.getElementChild(parent, s, MatchType.EXACT);
        }

        @Override
        public OlapElement getElementChild(OlapElement parent, Id.Segment s, MatchType matchType) {
            OlapElement mdxElement = this.schemaReader.getElementChild(parent, s, matchType);
            if (mdxElement != null) {
                return mdxElement;
            }
            for (Formula formula : Query.this.formulas) {
                Id id;
                if (formula.isMember() || (id = formula.getIdentifier()).getSegments().size() != 1 || !id.getSegments().get(0).matches(s.name)) continue;
                return formula.getNamedSet();
            }
            return mdxElement;
        }

        @Override
        public OlapElement lookupCompound(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category) {
            OlapElement oe = this.lookupCompound(parent, names, failIfNotFound, category, MatchType.EXACT_SCHEMA);
            if (oe == null) {
                oe = this.lookupCompound(parent, names, failIfNotFound, category, MatchType.EXACT);
            }
            return oe;
        }

        @Override
        public OlapElement lookupCompound(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category, MatchType matchType) {
            Member member;
            Formula formula;
            switch (category) {
                case 0: 
                case 6: {
                    Member calculatedMember;
                    if (parent != Query.this.cube || (calculatedMember = this.getCalculatedMember(names)) == null) break;
                    return calculatedMember;
                }
            }
            switch (category) {
                case 0: 
                case 8: {
                    NamedSet namedSet;
                    if (parent != Query.this.cube || (namedSet = this.getNamedSet(names)) == null) break;
                    return namedSet;
                }
            }
            OlapElement olapElement = super.lookupCompound(parent, names, failIfNotFound, category, matchType);
            if (olapElement instanceof Member && (formula = (Formula)(member = (Member)olapElement).getPropertyValue(Property.FORMULA.name)) != null) {
                Formula formulaClone = (Formula)formula.clone();
                formulaClone.createElement(Query.this);
                formulaClone.accept(Query.this.createValidator());
                olapElement = formulaClone.getMdxMember();
            }
            return olapElement;
        }

        @Override
        public NamedSet getNamedSet(List<Id.Segment> nameParts) {
            if (nameParts.size() != 1) {
                return null;
            }
            return Query.this.lookupNamedSet(nameParts.get((int)0).name);
        }

        @Override
        public Parameter getParameter(String name) {
            for (Parameter parameter : Query.this.parameters) {
                if (!parameter.getName().equals(name)) continue;
                return parameter;
            }
            if (Util.lookup(RolapConnectionProperties.class, name) != null) {
                Object value = Query.this.connection.getProperty(name);
                Literal defaultValue = Literal.createString(String.valueOf(value));
                return new ConnectionParameterImpl(name, defaultValue);
            }
            return super.getParameter(name);
        }
    }
}

