/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnProvider;
import org.netbeans.modules.db.sql.visualeditor.querymodel.From;
import org.netbeans.modules.db.sql.visualeditor.querymodel.FromNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupByNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Having;
import org.netbeans.modules.db.sql.visualeditor.querymodel.HavingNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderByNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Query;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Select;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SelectNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Where;
import org.netbeans.modules.db.sql.visualeditor.querymodel.WhereNode;

public class QueryNode
implements Query {
    SelectNode _select;
    FromNode _from;
    WhereNode _where;
    GroupByNode _groupBy;
    HavingNode _having;
    OrderByNode _orderBy;

    public QueryNode() {
    }

    public QueryNode(SelectNode selectNode, FromNode fromNode, WhereNode whereNode, GroupByNode groupByNode, HavingNode havingNode, OrderByNode orderByNode) {
        this._select = selectNode;
        this._from = fromNode;
        this._where = whereNode;
        this._groupBy = groupByNode;
        this._having = havingNode;
        this._orderBy = orderByNode;
    }

    public QueryNode(SelectNode selectNode, FromNode fromNode) {
        this(selectNode, fromNode, null, null, null, null);
    }

    public String genText(SQLIdentifiers.Quoter quoter) {
        String string = this._select.genText(quoter) + " " + this._from.genText(quoter);
        if (this._where != null) {
            string = string + this._where.genText(quoter);
        }
        if (this._groupBy != null) {
            string = string + this._groupBy.genText(quoter);
        }
        if (this._having != null) {
            string = string + this._having.genText(quoter);
        }
        if (this._orderBy != null) {
            string = string + this._orderBy.genText(quoter);
        }
        return string;
    }

    public String toString() {
        return this._select.toString() + this._from.toString() + this._where.toString();
    }

    public Select getSelect() {
        return this._select;
    }

    public void setSelect(Select select) {
        this._select = (SelectNode)select;
    }

    public From getFrom() {
        return this._from;
    }

    public void setFrom(From from) {
        this._from = (FromNode)from;
    }

    public Where getWhere() {
        return this._where;
    }

    public void setWhere(Where where) {
        this._where = (WhereNode)where;
    }

    public GroupBy getGroupBy() {
        return this._groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this._groupBy = (GroupByNode)groupBy;
    }

    public OrderBy getOrderBy() {
        return this._orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this._orderBy = (OrderByNode)orderBy;
    }

    public Having getHaving() {
        return this._having;
    }

    public void setHaving(Having having) {
        this._having = (HavingNode)having;
    }

    public void removeTable(String string) {
        this._from.removeTable(string);
        this._select.removeTable(string);
        if (this._where != null) {
            this._where.removeTable(string);
            if (this._where.getExpression() == null) {
                this._where = null;
            }
        }
        if (this._groupBy != null) {
            this._groupBy.removeTable(string);
            if (this._from._tableList.size() == 0) {
                this._groupBy = null;
            }
        }
        this.removeSortSpecification(string);
    }

    public void replaceStar(ColumnProvider columnProvider) {
        if (this._select.hasAsteriskQualifier()) {
            ArrayList<ColumnNode> arrayList = new ArrayList<ColumnNode>();
            ArrayList arrayList2 = this._from.getTables();
            for (int i = 0; i < arrayList2.size(); ++i) {
                TableNode tableNode = (TableNode)arrayList2.get(i);
                String string = tableNode.getFullTableName();
                ArrayList arrayList3 = new ArrayList();
                columnProvider.getColumnNames(string, arrayList3);
                String string2 = tableNode.getCorrName();
                String string3 = tableNode.getTableName();
                String string4 = tableNode.getSchemaName();
                for (int j = 0; j < arrayList3.size(); ++j) {
                    String string5 = (String)arrayList3.get(j);
                    arrayList.add(new ColumnNode(string3, string5, string2, string4));
                }
            }
            this._select.setColumnList(arrayList);
        }
    }

    public void addColumn(String string, String string2) {
        Table table = this._from.findTable(string);
        ColumnNode columnNode = new ColumnNode(table, string2);
        this._select.addColumn(columnNode);
        if (this._groupBy != null) {
            this._groupBy.addColumn(columnNode);
        }
    }

    public void removeColumn(String string, String string2) {
        this._select.removeColumn(string, string2);
        if (this._groupBy != null) {
            this._groupBy.removeColumn(string, string2);
        }
        this.removeSortSpecification(string, string2);
    }

    public void renameTableSpec(String string, String string2) {
        this._from.renameTableSpec(string, string2);
        this._select.renameTableSpec(string, string2);
        if (this._where != null) {
            this._where.renameTableSpec(string, string2);
        }
        if (this._groupBy != null) {
            this._groupBy.renameTableSpec(string, string2);
        }
        if (this._having != null) {
            this._having.renameTableSpec(string, string2);
        }
        if (this._orderBy != null) {
            this._orderBy.renameTableSpec(string, string2);
        }
    }

    public void getReferencedColumns(Collection collection) {
        this._from.getReferencedColumns(collection);
        this._select.getReferencedColumns(collection);
        if (this._where != null) {
            this._where.getReferencedColumns(collection);
        }
        if (this._groupBy != null) {
            this._groupBy.getReferencedColumns(collection);
        }
        if (this._having != null) {
            this._having.getReferencedColumns(collection);
        }
        if (this._orderBy != null) {
            this._orderBy.getReferencedColumns(collection);
        }
    }

    private void removeSortSpecification(String string) {
        if (this._orderBy != null) {
            this._orderBy.removeSortSpecification(string);
        }
    }

    private void removeSortSpecification(String string, String string2) {
        if (this._orderBy != null) {
            this._orderBy.removeSortSpecification(string, string2);
        }
    }
}

