/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtCompletionPane;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.JDCPopupPanel;

public class ScrollCompletionPane
extends JScrollPane
implements ExtCompletionPane,
PropertyChangeListener,
SettingsChangeListener {
    private ExtEditorUI extEditorUI;
    private JComponent view;
    private JLabel topLabel;
    private Dimension minSize;
    private Dimension maxSize;
    private ViewMouseListener viewMouseL;
    private Dimension scrollBarSize;
    private Dimension minSizeDefault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollCompletionPane(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        Dimension dimension = this.getPreferredSize();
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
        this.scrollBarSize = this.getPreferredSize();
        this.scrollBarSize.width -= dimension.width;
        this.scrollBarSize.height -= dimension.height;
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        super.setVisible(false);
        this.installTitleComponent();
        CompletionView completionView = extEditorUI.getCompletion().getView();
        if (completionView instanceof JComponent) {
            this.view = (JComponent)((Object)completionView);
            this.setViewportView(this.view);
        }
        this.getViewport().setMinimumSize(new Dimension(4, 4));
        Settings.addSettingsChangeListener(this);
        this.viewMouseL = new ViewMouseListener();
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = extEditorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, jTextComponent));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
        this.putClientProperty("HelpID", ScrollCompletionPane.class.getName());
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (clazz != null) {
            this.minSize = (Dimension)SettingsUtil.getValue(clazz, "completion-pane-min-size", ExtSettingsDefaults.defaultCompletionPaneMinSize);
            this.minSizeDefault = new Dimension(this.minSize);
            this.setMinimumSize(this.minSize);
            this.maxSize = (Dimension)SettingsUtil.getValue(clazz, "completion-pane-max-size", ExtSettingsDefaults.defaultCompletionPaneMaxSize);
            this.setMaximumSize(this.maxSize);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            if (propertyChangeEvent.getNewValue() != null) {
                this.settingsChange(null);
                if (this.view != null) {
                    this.view.addMouseListener(this.viewMouseL);
                }
            } else if (this.view != null) {
                this.view.removeMouseListener(this.viewMouseL);
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.view instanceof JList) {
            JList jList = (JList)this.view;
            jList.ensureIndexIsVisible(jList.getSelectedIndex());
        }
        super.setVisible(bl);
    }

    public void refresh() {
        if (this.view instanceof JList) {
            JList jList = (JList)this.view;
            jList.ensureIndexIsVisible(jList.getSelectedIndex());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ScrollCompletionPane.this.isShowing()) {
                    ScrollCompletionPane.this.revalidate();
                }
            }
        });
    }

    public void setTitle(String string) {
        this.topLabel.setText(string);
    }

    protected void installTitleComponent() {
        this.topLabel = new JLabel();
        this.topLabel.setForeground(Color.blue);
        this.topLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.setColumnHeaderView(this.topLabel);
    }

    protected Dimension getTitleComponentPreferredSize() {
        return this.topLabel.getPreferredSize();
    }

    public void setSize(int n, int n2) {
        boolean bl;
        int n3 = n;
        int n4 = n2;
        this.minSize.width = this.minSizeDefault.width;
        this.minSize.height = this.minSizeDefault.height;
        this.setMinimumSize(this.minSize);
        Dimension dimension = this.getPreferredSize();
        dimension.width += this.scrollBarSize.width;
        dimension.width = Math.max(Math.max(dimension.width, this.minSize.width), this.getTitleComponentPreferredSize().width);
        n3 = Math.min(n3, this.maxSize.width);
        n4 = Math.min(n4, this.maxSize.height);
        boolean bl2 = bl = dimension.width - this.scrollBarSize.width > n3;
        if (dimension.width > n3) {
            dimension.width = n3;
            if (bl) {
                dimension.height += this.scrollBarSize.height;
                this.minSize.height += this.scrollBarSize.height;
                this.setMinimumSize(this.minSize);
            }
        }
        dimension.height = Math.min(Math.max(dimension.height, this.minSize.height), n4);
        super.setSize(dimension.width, dimension.height);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public JComponent getComponent() {
        return this;
    }

    class ViewMouseListener
    extends MouseAdapter {
        ViewMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Action action;
            JDCPopupPanel jDCPopupPanel;
            JTextComponent jTextComponent;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (jTextComponent = ScrollCompletionPane.this.extEditorUI.getComponent()) != null && mouseEvent.getClickCount() == 2 && (jDCPopupPanel = ExtUtilities.getJDCPopupPanel(jTextComponent)) != null && (action = jDCPopupPanel.getActionMap().get("completion-substitute-text")) != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 1001, ""));
            }
        }
    }
}

