/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.impl.ProgressSupport;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.refactoring.spi.impl.UndoManager;
import org.openide.LifecycleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RefactoringSession {
    private final LinkedList<RefactoringElementImplementation> internalList;
    private final RefactoringElementsBag bag;
    private final Collection<RefactoringElement> refactoringElements;
    private final String description;
    private ProgressSupport progressSupport;
    private UndoManager undoManager = UndoManager.getDefault();
    boolean realcommit = true;

    private RefactoringSession(String string) {
        this.internalList = new LinkedList();
        this.bag = SPIAccessor.DEFAULT.createBag(this, this.internalList);
        this.description = string;
        this.refactoringElements = new ElementsCollection();
    }

    public static RefactoringSession create(String string) {
        return new RefactoringSession(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem doRefactoring(boolean bl) {
        Iterator iterator = this.internalList.iterator();
        this.fireProgressListenerStart(0, this.internalList.size() + 1);
        if (this.realcommit) {
            this.undoManager.transactionStarted();
            this.undoManager.setUndoDescription(this.description);
        }
        try {
            try {
                while (iterator.hasNext()) {
                    this.fireProgressListenerStep();
                    RefactoringElementImplementation refactoringElementImplementation = (RefactoringElementImplementation)iterator.next();
                    if (!refactoringElementImplementation.isEnabled() || refactoringElementImplementation.getStatus() == 2 || refactoringElementImplementation.getStatus() == 3) continue;
                    refactoringElementImplementation.performChange();
                }
            }
            catch (Throwable throwable) {
                for (Transaction transaction : SPIAccessor.DEFAULT.getCommits(this.bag)) {
                    transaction.commit();
                }
                throw throwable;
            }
            for (Transaction object : SPIAccessor.DEFAULT.getCommits(this.bag)) {
                object.commit();
            }
            if (bl) {
                LifecycleManager.getDefault().saveAll();
            }
            for (RefactoringElementImplementation refactoringElementImplementation : SPIAccessor.DEFAULT.getFileChanges(this.bag)) {
                if (!refactoringElementImplementation.isEnabled()) continue;
                refactoringElementImplementation.performChange();
            }
            this.fireProgressListenerStep();
        }
        finally {
            this.fireProgressListenerStop();
            if (this.realcommit) {
                this.undoManager.addItem(this);
                this.undoManager.transactionEnded(false);
                this.realcommit = false;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem undoRefactoring(boolean bl) {
        try {
            ListIterator<RefactoringElementImplementation> listIterator = this.internalList.listIterator(this.internalList.size());
            this.fireProgressListenerStart(0, this.internalList.size() + 1);
            ArrayList<RefactoringElementImplementation> arrayList = SPIAccessor.DEFAULT.getFileChanges(this.bag);
            ArrayList<Transaction> arrayList2 = SPIAccessor.DEFAULT.getCommits(this.bag);
            Object object = arrayList.listIterator(arrayList.size());
            while (object.hasPrevious()) {
                RefactoringElementImplementation refactoringElementImplementation = object.previous();
                if (!refactoringElementImplementation.isEnabled()) continue;
                refactoringElementImplementation.undoChange();
            }
            object = arrayList2.listIterator(arrayList2.size());
            while (object.hasPrevious()) {
                ((Transaction)object.previous()).rollback();
            }
            while (listIterator.hasPrevious()) {
                this.fireProgressListenerStep();
                object = listIterator.previous();
                if (!object.isEnabled() || object.getStatus() == 2 || object.getStatus() == 3) continue;
                object.undoChange();
            }
            if (bl) {
                LifecycleManager.getDefault().saveAll();
            }
            this.fireProgressListenerStep();
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    public Collection<RefactoringElement> getRefactoringElements() {
        return this.refactoringElements;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport();
        }
        this.progressSupport.addProgressListener(progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressSupport != null) {
            this.progressSupport.removeProgressListener(progressListener);
        }
    }

    RefactoringElementsBag getElementsBag() {
        return this.bag;
    }

    private void fireProgressListenerStart(int n, int n2) {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStart(this, n, n2);
        }
    }

    private void fireProgressListenerStep() {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStep(this);
        }
    }

    private void fireProgressListenerStop() {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStop(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementsCollection
    extends AbstractCollection<RefactoringElement> {
        private ElementsCollection() {
        }

        @Override
        public Iterator<RefactoringElement> iterator() {
            return new Iterator(){
                private final Iterator<RefactoringElementImplementation> inner;
                private final Iterator<RefactoringElementImplementation> inner2;
                {
                    this.inner = RefactoringSession.this.internalList.iterator();
                    this.inner2 = SPIAccessor.DEFAULT.getFileChanges(RefactoringSession.this.bag).iterator();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public RefactoringElement next() {
                    if (this.inner.hasNext()) {
                        return new RefactoringElement(this.inner.next());
                    }
                    return new RefactoringElement(this.inner2.next());
                }

                public boolean hasNext() {
                    return this.inner.hasNext() || this.inner2.hasNext();
                }
            };
        }

        @Override
        public int size() {
            return RefactoringSession.this.internalList.size() + SPIAccessor.DEFAULT.getFileChanges(RefactoringSession.this.bag).size();
        }
    }
}

