/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.ThreadUtils;
import com.jaspersoft.ireport.designer.utils.Java2DUtils;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;

public class BandSeparatorWidget
extends SeparatorWidget
implements PropertyChangeListener {
    private final Stroke stroke = new BasicStroke(1.0f);
    private final JRBand band;

    public JRBand getBand() {
        return this.band;
    }

    public BandSeparatorWidget(ReportObjectScene scene, JRBand b) {
        super((Scene)scene, SeparatorWidget.Orientation.HORIZONTAL);
        this.band = b;
        this.setBorder(BorderFactory.createEmptyBorder((int)0, (int)3));
        this.setCursor(Cursor.getPredefinedCursor(9));
        this.setForeground(ReportObjectScene.DESIGN_LINE_COLOR);
        if (b instanceof JRDesignBand) {
            ((JRDesignBand)b).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.updateBounds();
    }

    public void updateBounds() {
        JasperDesign jd = ((ReportObjectScene)this.getScene()).getJasperDesign();
        this.setPreferredLocation(new Point(0, ModelUtils.getBandLocation(this.band, jd) + this.band.getHeight()));
        this.setPreferredBounds(new Rectangle(0, -3, jd.getPageWidth(), 7));
    }

    protected void paintWidget() {
        Graphics2D gr = this.getGraphics();
        gr.setColor(this.getForeground());
        Rectangle bounds = this.getBounds();
        Insets insets = this.getBorder().getInsets();
        gr.setStroke(Java2DUtils.getInvertedZoomedStroke(this.stroke, this.getScene().getZoomFactor()));
        if (this.getOrientation() == SeparatorWidget.Orientation.HORIZONTAL) {
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, bounds.width - insets.left - insets.right, 0.0);
            gr.draw(r);
        } else {
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 0.0, bounds.height - insets.top - insets.bottom);
            gr.draw(r);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Runnable r = null;
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("height")) {
            r = new Runnable(){

                public void run() {
                    ((ReportObjectScene)BandSeparatorWidget.this.getScene()).refreshDocument();
                }
            };
        } else if (evt.getPropertyName().equals("children")) {
            r = new Runnable(){

                public void run() {
                    ((ReportObjectScene)BandSeparatorWidget.this.getScene()).refreshElementGroup((JRElementGroup)((JRDesignBand)BandSeparatorWidget.this.band));
                }
            };
        }
        if (r != null) {
            ThreadUtils.invokeInAWTThread(r);
        }
    }
}

