/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.styles;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class AddTemplateReferenceToReportAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        JasperDesign jd = IReportManager.getInstance().getActiveReport();
        for (int i = 0; i < nodes.length; ++i) {
            JRTemplateReference reference = (JRTemplateReference)nodes[i].getLookup().lookup(JRTemplateReference.class);
            if (reference == null) continue;
            JRDesignReportTemplate reportTemplate = new JRDesignReportTemplate();
            reportTemplate.setSourceExpression((JRExpression)Misc.createExpression("java.lang.String", "\"" + Misc.string_replace("\\\\", "\\", reference.getLocation()) + "\""));
            jd.addTemplate((JRReportTemplate)reportTemplate);
            IReportManager.getInstance().notifyReportChange();
        }
    }

    protected boolean enable(Node[] nodes) {
        if (IReportManager.getInstance().getActiveReport() == null) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].getLookup().lookup(JRTemplateReference.class) != null) continue;
            return false;
        }
        return nodes.length > 0;
    }

    public String getName() {
        return I18n.getString("AddTemplateReferenceToReportAction.addTemplateReferenceToReport");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

