/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.batch;

import java.io.IOException;
import java.io.Reader;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.batch.CopyTextTokenList;
import org.netbeans.lib.lexer.batch.SkimTokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SkimLexerInputOperation<T extends TokenId>
extends LexerInputOperation<T> {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final int DEFAULT_READ_CHAR_ARRAY_SIZE = 4096;
    private static final int MIN_READ_SIZE = 512;
    private static final int DEFAULT_CLUSTER_SIZE = 4096;
    private static final int MAX_UNUSED_CLUSTER_SIZE_FRACTION = 50;
    private Reader reader;
    private char[] readCharArray;
    private CharSequence readCharSequence;
    private int readStartIndex;
    private int readEndIndex;
    private boolean eofRead;
    private SkimTokenList<T> cluster;
    private int clusterTextEndIndex;
    private int defaultClusterSize = 4096;
    private int clusterStartOffset;
    private int offsetShift;

    public SkimLexerInputOperation(TokenList<T> tokenList, Reader reader) {
        super(tokenList, 0, null);
        this.reader = reader;
        this.readCharArray = new char[4096];
    }

    public SkimLexerInputOperation(TokenList<T> tokenList, CharSequence charSequence) {
        super(tokenList, 0, null);
        this.readCharSequence = charSequence;
        this.readEndIndex = charSequence.length();
    }

    @Override
    public int read(int n) {
        if ((n += this.readStartIndex) < this.readEndIndex) {
            return this.readCharArray != null ? this.readCharArray[n] : this.readCharSequence.charAt(n);
        }
        if (!this.eofRead) {
            this.eofRead = this.readCharArray != null ? this.readNextCharArray() : true;
            return this.read(n);
        }
        return -1;
    }

    @Override
    public char readExisting(int n) {
        return this.readCharArray != null ? this.readCharArray[n] : this.readCharSequence.charAt(n);
    }

    @Override
    public void approveToken(AbstractToken<T> abstractToken) {
        int n = abstractToken.length();
        if (this.isSkipToken(abstractToken)) {
            this.preventFlyToken();
            this.skipChars(this.tokenLength());
        } else if (abstractToken.isFlyweight()) {
            assert (this.isFlyTokenAllowed());
            this.flyTokenAdded();
            this.skipChars(n);
        } else {
            int n2;
            if (this.clusterTextEndIndex != 0 && n + this.clusterTextEndIndex > this.cluster.getText().length) {
                this.finishCluster();
            }
            if (this.clusterTextEndIndex == 0) {
                int n3 = this.defaultClusterSize;
                if (n3 < n) {
                    n3 = n;
                }
                this.defaultClusterSize = n3;
                this.cluster = new SkimTokenList((CopyTextTokenList)this.tokenList(), this.clusterStartOffset, new char[n3]);
            }
            char[] cArray = this.cluster.getText();
            if (this.readCharArray != null) {
                System.arraycopy(this.readCharArray, this.readStartIndex, cArray, this.clusterTextEndIndex, n);
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    cArray[this.clusterTextEndIndex + n2] = this.readCharSequence.charAt(this.readStartIndex + n2);
                }
            }
            n2 = this.offsetShift << 16 | this.clusterTextEndIndex;
            abstractToken.setTokenList(this.cluster);
            abstractToken.setRawOffset(n2);
            this.clusterTextEndIndex += n;
            this.clearFlySequence();
        }
        this.readStartIndex += n;
        this.tokenApproved();
    }

    private void skipChars(int n) {
        if (this.clusterTextEndIndex != 0) {
            if (this.offsetShift + n > Short.MAX_VALUE) {
                this.finishCluster();
                this.clusterStartOffset += n;
            } else {
                this.offsetShift += n;
            }
        } else {
            this.clusterStartOffset += n;
        }
    }

    public void finish() {
        if (this.clusterTextEndIndex != 0) {
            this.finishCluster();
        }
    }

    private void finishCluster() {
        int n = this.cluster.getText().length;
        if (n / 50 > n - this.clusterTextEndIndex) {
            char[] cArray = new char[this.clusterTextEndIndex];
            System.arraycopy(this.cluster.getText(), 0, cArray, 0, this.clusterTextEndIndex);
            this.cluster.setText(cArray);
        }
        this.clusterStartOffset += this.clusterTextEndIndex + this.offsetShift;
        this.clusterTextEndIndex = 0;
        this.offsetShift = 0;
        this.cluster = null;
    }

    private boolean readNextCharArray() {
        int n = this.readEndIndex - this.readStartIndex;
        int n2 = this.readCharArray.length - n;
        char[] cArray = this.readCharArray;
        if (n2 < 512) {
            cArray = new char[this.readCharArray.length * 2];
        }
        System.arraycopy(this.readCharArray, this.readStartIndex, cArray, 0, n);
        this.readCharArray = cArray;
        this.readStartIndex = 0;
        this.readEndIndex = n;
        boolean bl = false;
        while (this.readEndIndex < this.readCharArray.length) {
            int n3;
            try {
                n3 = this.reader.read(this.readCharArray, this.readEndIndex, this.readCharArray.length - this.readEndIndex);
            }
            catch (IOException iOException) {
                n3 = -1;
            }
            if (n3 == -1) {
                bl = true;
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
                break;
            }
            this.readEndIndex += n3;
        }
        return bl;
    }
}

