/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.options;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.netbeans.modules.diff.options.DiffOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class DiffOptionsController
extends OptionsPanelController {
    private DiffOptionsPanel panel;

    DiffOptionsController() {
    }

    public void update() {
        this.panel.getInternalDiff().setSelected(DiffModuleConfig.getDefault().isUseInteralDiff());
        this.panel.getExternalDiff().setSelected(!DiffModuleConfig.getDefault().isUseInteralDiff());
        this.panel.getIgnoreWhitespace().setSelected(DiffModuleConfig.getDefault().isIgnoreWhitespace());
        this.panel.getExternalCommand().setText(DiffModuleConfig.getDefault().getPreferences().get("externalDiffCommand", "diff {0} {1}"));
        this.panel.setChanged(false);
    }

    public void applyChanges() {
        this.checkExternalCommand();
        DiffModuleConfig.getDefault().setUseInteralDiff(this.panel.getInternalDiff().isSelected());
        DiffModuleConfig.getDefault().setIgnoreWhitespace(this.panel.getIgnoreWhitespace().isSelected());
        DiffModuleConfig.getDefault().getPreferences().put("externalDiffCommand", this.panel.getExternalCommand().getText());
        this.panel.setChanged(false);
    }

    private void checkExternalCommand() {
        if (this.panel.getInternalDiff().isSelected()) {
            return;
        }
        String string = this.panel.getExternalCommand().getText();
        try {
            Process process = Runtime.getRuntime().exec(string);
            process.destroy();
        }
        catch (IOException iOException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DiffOptionsController.class, (String)"MSG_InvalidDiffCommand"), 2));
            return;
        }
    }

    public void cancel() {
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return this.panel.isChanged();
    }

    public JComponent getComponent(Lookup lookup) {
        if (this.panel == null) {
            this.panel = new DiffOptionsPanel();
        }
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DiffOptionsController.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

