/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.Delegate;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.ProvidedExtensionsProxy;
import org.netbeans.modules.masterfs.ResourcePath;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;

final class Cache {
    private Map res2DfoMap;
    private static Cache instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cache getDefault() {
        Class clazz = Cache.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new Cache();
                Cache.instance.res2DfoMap = Collections.synchronizedMap(new WeakHashMap());
            }
        }
        ProvidedExtensionsProxy.checkReentrancy();
        return instance;
    }

    private Cache() {
    }

    MasterFileObject get(ResourcePath resourcePath) {
        MasterFileObject masterFileObject = this.getValidOrInvalid(resourcePath);
        if (masterFileObject != null) {
            masterFileObject = masterFileObject.isValid() ? masterFileObject : null;
        }
        return masterFileObject;
    }

    MasterFileObject getValidOrInvalid(ResourcePath resourcePath) {
        Reference reference = (Reference)this.res2DfoMap.get(resourcePath.getNormalizedPath());
        MasterFileObject masterFileObject = null;
        if (reference != null) {
            masterFileObject = (MasterFileObject)((Object)reference.get());
        }
        return masterFileObject;
    }

    MasterFileObject getOrCreate(ResourcePath resourcePath) {
        MasterFileObject masterFileObject = this.get(resourcePath);
        if (masterFileObject != null) {
            return masterFileObject;
        }
        FileObject fileObject = Delegate.resolve(resourcePath);
        return fileObject == null ? null : this.getOrCreate(resourcePath, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MasterFileObject getOrCreate(ResourcePath resourcePath, FileObject fileObject) {
        MasterFileObject masterFileObject = null;
        Map map = this.res2DfoMap;
        synchronized (map) {
            boolean bl;
            masterFileObject = this.getValidOrInvalid(resourcePath);
            boolean bl2 = bl = masterFileObject == null || masterFileObject.isValid();
            if (masterFileObject != null && bl) {
                return masterFileObject;
            }
            MasterFileObject masterFileObject2 = new MasterFileObject(resourcePath, fileObject);
            if (masterFileObject2.isValid()) {
                masterFileObject = masterFileObject2;
                this.put(masterFileObject);
            } else {
                masterFileObject = null;
            }
        }
        return masterFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration getAll() {
        ArrayList<MasterFileObject> arrayList = new ArrayList<MasterFileObject>();
        Object[] objectArray = this.res2DfoMap;
        synchronized (this.res2DfoMap) {
            Iterator iterator = this.res2DfoMap.entrySet().iterator();
            while (iterator.hasNext()) {
                MasterFileObject masterFileObject;
                Map.Entry entry = iterator.next();
                Reference reference = (Reference)entry.getValue();
                if (reference == null || (masterFileObject = (MasterFileObject)((Object)reference.get())) == null || !masterFileObject.getDelegate().isValid()) continue;
                arrayList.add(masterFileObject);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectArray = new Object[arrayList.size()];
            arrayList.toArray(objectArray);
            return Enumerations.array((Object[])objectArray);
        }
    }

    void clear() {
        this.res2DfoMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterFileObject put(MasterFileObject masterFileObject) {
        MasterFileObject masterFileObject2 = masterFileObject;
        Map map = this.res2DfoMap;
        synchronized (map) {
            MasterFileObject masterFileObject3 = this.get(masterFileObject.getResource());
            if (masterFileObject3 == null || !masterFileObject3.isValid()) {
                this.res2DfoMap.remove(masterFileObject.getResource().getNormalizedPath());
                this.res2DfoMap.put(masterFileObject.getResource().getNormalizedPath(), Cache.createReference(masterFileObject));
            } else {
                masterFileObject2 = masterFileObject3;
            }
        }
        return masterFileObject2;
    }

    private static Reference createReference(MasterFileObject masterFileObject) {
        return new SoftReference<MasterFileObject>(masterFileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replace(String string, MasterFileObject masterFileObject) {
        Map map = this.res2DfoMap;
        synchronized (map) {
            MasterFileObject masterFileObject2 = this.getValidOrInvalid(new ResourcePath(string));
            if (masterFileObject2 != null) {
                this.res2DfoMap.remove(string);
            }
            this.put(masterFileObject);
        }
    }
}

