/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bracesmatching;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.bracesmatching.SpiAccessor;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterMatcher {
    private static final Logger LOG = Logger.getLogger(MasterMatcher.class.getName());
    public static final String PROP_SEARCH_DIRECTION = "nbeditor-bracesMatching-searchDirection";
    public static final String D_BACKWARD = "backward-preferred";
    public static final String D_FORWARD = "forward-preferred";
    public static final String PROP_CARET_BIAS = "nbeditor-bracesMatching-caretBias";
    public static final String B_BACKWARD = "backward";
    public static final String B_FORWARD = "forward";
    public static final String PROP_MAX_BACKWARD_LOOKAHEAD = "nbeditor-bracesMatching-maxBackwardLookahead";
    public static final String PROP_MAX_FORWARD_LOOKAHEAD = "nbeditor-bracesMatching-maxForwardLookahead";
    private static final int DEFAULT_MAX_LOOKAHEAD = 1;
    private static final int MAX_MAX_LOOKAHEAD = 256;
    public static final String PROP_SHOW_SEARCH_PARAMETERS = "debug-showSearchParameters-dont-ever-use-it-or-you-will-die";
    private static final AttributeSet CARET_BIAS_HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, Color.BLACK});
    private static final AttributeSet MAX_LOOKAHEAD_HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, Color.BLUE});
    private static final RequestProcessor PR = new RequestProcessor("EditorBracesMatching", 5, true);
    static final Map<Thread, Result> THREAD_RESULTS = Collections.synchronizedMap(new HashMap());
    private final String LOCK = new String("MasterMatcher.LOCK");
    private final JTextComponent component;
    private RequestProcessor.Task task = null;
    private Result lastResult = null;

    public static synchronized MasterMatcher get(JTextComponent jTextComponent) {
        MasterMatcher masterMatcher = (MasterMatcher)jTextComponent.getClientProperty(MasterMatcher.class);
        if (masterMatcher == null) {
            masterMatcher = new MasterMatcher(jTextComponent);
            jTextComponent.putClientProperty(MasterMatcher.class, masterMatcher);
        }
        return masterMatcher;
    }

    public static boolean isTaskCanceled() {
        Result result = THREAD_RESULTS.get(Thread.currentThread());
        assert (result != null) : "MatcherContext.isTaskCanceled() should only be called from the matcher task's thread";
        return result.isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlight(Document document, int n, OffsetsBag offsetsBag, AttributeSet attributeSet, AttributeSet attributeSet2) {
        assert (document != null) : "The document parameter must not be null";
        assert (offsetsBag != null) : "The highlights parameter must not be null";
        assert (attributeSet != null) : "The matchedColoring parameter must not be null";
        assert (attributeSet2 != null) : "The mismatchedColoring parameter must not be null";
        assert (n >= 0) : "The caretOffset parameter must be >= 0";
        String string = this.LOCK;
        synchronized (string) {
            Object object = this.getAllowedDirection();
            Object object2 = this.getCaretBias();
            int n2 = this.getMaxLookahead(true);
            int n3 = this.getMaxLookahead(false);
            if (this.task != null) {
                if (this.lastResult.getCaretOffset() == n && this.lastResult.getAllowedDirection() == object && this.lastResult.getCaretBias() == object2 && this.lastResult.getMaxBwdLookahead() == n2 && this.lastResult.getMaxFwdLookahead() == n2) {
                    this.lastResult.addHighlightingJob(offsetsBag, attributeSet, attributeSet2);
                } else {
                    this.lastResult.cancel();
                    this.task = null;
                }
            }
            if (this.task == null) {
                this.lastResult = new Result(document, n, object, object2, n2, n3);
                this.lastResult.addHighlightingJob(offsetsBag, attributeSet, attributeSet2);
                this.task = PR.post((Runnable)this.lastResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(Document document, int n, Caret caret, boolean bl) {
        assert (document != null) : "The document parameter must not be null";
        assert (caret != null) : "The caret parameter must not be null";
        assert (n >= 0) : "The caretOffset parameter must be >= 0";
        RequestProcessor.Task task = null;
        String string = this.LOCK;
        synchronized (string) {
            Object object = this.getAllowedDirection();
            Object object2 = this.getCaretBias();
            int n2 = this.getMaxLookahead(true);
            int n3 = this.getMaxLookahead(false);
            boolean bl2 = DocumentUtilities.isReadLocked((Document)document);
            if (this.task != null) {
                if (!bl2 && this.lastResult.getCaretOffset() == n && this.lastResult.getAllowedDirection() == object && this.lastResult.getCaretBias() == object2 && this.lastResult.getMaxBwdLookahead() == n2 && this.lastResult.getMaxFwdLookahead() == n2) {
                    this.lastResult.addNavigationJob(caret, bl);
                    task = this.task;
                } else {
                    this.lastResult.cancel();
                    this.task = null;
                }
            }
            if (this.task == null) {
                this.lastResult = new Result(document, n, object, object2, n2, n3);
                this.lastResult.addNavigationJob(caret, bl);
                if (bl2) {
                    this.lastResult.run();
                } else {
                    task = this.task = PR.post((Runnable)this.lastResult);
                }
            }
        }
        if (task != null) {
            task.waitFinished();
        }
    }

    private MasterMatcher(JTextComponent jTextComponent) {
        this.component = jTextComponent;
    }

    private Object getAllowedDirection() {
        Object object = this.component.getClientProperty(PROP_SEARCH_DIRECTION);
        return object != null ? object : D_BACKWARD;
    }

    private Object getCaretBias() {
        Object object = this.component.getClientProperty(PROP_CARET_BIAS);
        return object != null ? object : B_BACKWARD;
    }

    private int getMaxLookahead(boolean bl) {
        String string = bl ? PROP_MAX_BACKWARD_LOOKAHEAD : PROP_MAX_FORWARD_LOOKAHEAD;
        int n = 1;
        Object object = this.component.getClientProperty(string);
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object != null) {
            try {
                n = Integer.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, "Can't parse the value of " + string + ": '" + object + "'", numberFormatException);
            }
        }
        if (n >= 0 && n <= 256) {
            return n;
        }
        LOG.warning("Invalid value of " + string + ": " + n);
        return 256;
    }

    private static void highlightAreas(int[] nArray, int[] nArray2, OffsetsBag offsetsBag, AttributeSet attributeSet, AttributeSet attributeSet2) {
        offsetsBag.clear();
        if (nArray2 != null && nArray2.length >= 2) {
            MasterMatcher.placeHighlights(nArray, true, offsetsBag, attributeSet);
            MasterMatcher.placeHighlights(nArray2, false, offsetsBag, attributeSet);
        } else if (nArray != null && nArray.length >= 2) {
            MasterMatcher.placeHighlights(nArray, true, offsetsBag, attributeSet2);
        }
    }

    private static void placeHighlights(int[] nArray, boolean bl, OffsetsBag offsetsBag, AttributeSet attributeSet) {
        int n = bl && nArray.length > 2 ? 1 : 0;
        for (int i = n; i < nArray.length / 2; ++i) {
            offsetsBag.addHighlight(nArray[i * 2], nArray[i * 2 + 1], attributeSet);
        }
    }

    private static void navigateAreas(int[] nArray, int[] nArray2, Object object, Caret caret, boolean bl) {
        if (nArray2 != null && nArray2.length >= 2) {
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < nArray2.length / 2; ++i) {
                if (nArray2[i * 2] <= nArray[0] && (n == -1 || nArray2[i * 2] > nArray2[n * 2])) {
                    n = i;
                }
                if (nArray2[i * 2] < nArray[1] || n2 != -1 && nArray2[i * 2] >= nArray2[n2 * 2]) continue;
                n2 = i;
            }
            if (n != -1) {
                if (bl) {
                    caret.setDot(nArray[0]);
                    caret.moveDot(nArray2[2 * n + 1]);
                } else if (B_BACKWARD.equalsIgnoreCase(object.toString())) {
                    caret.setDot(nArray2[2 * n + 1]);
                } else {
                    caret.setDot(nArray2[2 * n]);
                }
            } else if (n2 != -1) {
                if (bl) {
                    caret.setDot(nArray[1]);
                    caret.moveDot(nArray2[2 * n2]);
                } else if (B_BACKWARD.equalsIgnoreCase(object.toString())) {
                    caret.setDot(nArray2[2 * n2 + 1]);
                } else {
                    caret.setDot(nArray2[2 * n2]);
                }
            }
        }
    }

    private static Collection<? extends BracesMatcherFactory> findFactories(Document document, int n, boolean bl) {
        Object object;
        MimePath mimePath = null;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        if (tokenHierarchy != null) {
            object = tokenHierarchy.embeddedTokenSequences(n, bl);
            if (!object.isEmpty()) {
                String string = ((TokenSequence)object.get(object.size() - 1)).languagePath().mimePath();
                mimePath = MimePath.parse((String)string);
            }
        } else {
            object = (String)document.getProperty("mimeType");
            mimePath = object != null ? MimePath.parse((String)object) : MimePath.EMPTY;
        }
        object = mimePath == null ? Collections.emptyList() : MimeLookup.getLookup((MimePath)mimePath).lookupAll(BracesMatcherFactory.class);
        return object;
    }

    private final class Result
    implements Runnable {
        private final Document document;
        private final int caretOffset;
        private final Object allowedDirection;
        private final Object caretBias;
        private final int maxBwdLookahead;
        private final int maxFwdLookahead;
        private boolean inDocumentRender = false;
        private volatile boolean canceled = false;
        private final List<Object[]> highlightingJobs = new ArrayList<Object[]>();
        private final List<Object[]> navigationJobs = new ArrayList<Object[]>();

        public Result(Document document, int n, Object object, Object object2, int n2, int n3) {
            this.document = document;
            this.caretOffset = n;
            this.allowedDirection = object;
            this.caretBias = object2;
            this.maxBwdLookahead = n2;
            this.maxFwdLookahead = n3;
        }

        public void addHighlightingJob(OffsetsBag offsetsBag, AttributeSet attributeSet, AttributeSet attributeSet2) {
            this.highlightingJobs.add(new Object[]{offsetsBag, attributeSet, attributeSet2});
        }

        public void addNavigationJob(Caret caret, boolean bl) {
            this.navigationJobs.add(new Object[]{caret, bl});
        }

        public int getCaretOffset() {
            return this.caretOffset;
        }

        public Object getAllowedDirection() {
            return this.allowedDirection;
        }

        public Object getCaretBias() {
            return this.caretBias;
        }

        public int getMaxBwdLookahead() {
            return this.maxBwdLookahead;
        }

        public int getMaxFwdLookahead() {
            return this.maxFwdLookahead;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.canceled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            if (!this.inDocumentRender) {
                this.inDocumentRender = true;
                THREAD_RESULTS.put(Thread.currentThread(), this);
                try {
                    this.document.render(this);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Error error) {
                }
                finally {
                    THREAD_RESULTS.remove(Thread.currentThread());
                }
                return;
            }
            if (this.canceled) {
                return;
            }
            if (this.caretOffset > this.document.getLength()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Invalid offset, braces matching request ignored. Offset = " + this.caretOffset + ", doc.getLength() = " + this.document.getLength());
                }
                return;
            }
            int[] nArray = null;
            int[] nArray2 = null;
            try {
                object = new BracesMatcher[1];
                if (MasterMatcher.D_BACKWARD.equalsIgnoreCase(this.allowedDirection.toString())) {
                    nArray = this.findOrigin(true, (BracesMatcher[])object);
                    if (nArray == null) {
                        nArray = this.findOrigin(false, (BracesMatcher[])object);
                    }
                } else if (MasterMatcher.D_FORWARD.equalsIgnoreCase(this.allowedDirection.toString()) && (nArray = this.findOrigin(false, (BracesMatcher[])object)) == null) {
                    nArray = this.findOrigin(true, (BracesMatcher[])object);
                }
                if (nArray != null && !this.canceled) {
                    nArray2 = object[0].findMatches();
                }
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.WARNING, null, badLocationException);
            }
            catch (Exception exception) {
                for (Object[] objectArray = exception; objectArray != null; objectArray = objectArray.getCause()) {
                    if (!(objectArray instanceof InterruptedException)) continue;
                    return;
                }
                LOG.log(Level.WARNING, null, exception);
            }
            object = MasterMatcher.this.LOCK;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                MasterMatcher.this.task = null;
            }
            for (Object[] objectArray : this.highlightingJobs) {
                MasterMatcher.highlightAreas(nArray, nArray2, (OffsetsBag)objectArray[0], (AttributeSet)objectArray[1], (AttributeSet)objectArray[2]);
                if (!Boolean.valueOf((String)MasterMatcher.this.component.getClientProperty(MasterMatcher.PROP_SHOW_SEARCH_PARAMETERS)).booleanValue()) continue;
                this.showSearchParameters((OffsetsBag)objectArray[0]);
            }
            for (Object[] objectArray : this.navigationJobs) {
                MasterMatcher.navigateAreas(nArray, nArray2, this.caretBias, (Caret)objectArray[0], (Boolean)objectArray[1]);
            }
        }

        private int[] findOrigin(boolean bl, BracesMatcher[] bracesMatcherArray) throws InterruptedException {
            int n;
            Element element = DocumentUtilities.getParagraphElement((Document)this.document, (int)this.caretOffset);
            int n2 = this.caretOffset;
            int n3 = 0;
            if (bl) {
                n = this.maxBwdLookahead;
                if (MasterMatcher.B_FORWARD.equalsIgnoreCase(this.caretBias.toString())) {
                    if (n2 < element.getEndOffset() - 1) {
                        ++n2;
                        ++n;
                    }
                } else if (n == 0) {
                    n = 1;
                }
                if ((n3 = n2 - element.getStartOffset()) > n) {
                    n3 = n;
                }
            } else {
                n = this.maxFwdLookahead;
                if (MasterMatcher.B_BACKWARD.equalsIgnoreCase(this.caretBias.toString())) {
                    if (n2 > element.getStartOffset()) {
                        --n2;
                        ++n;
                    }
                } else if (n == 0) {
                    n = 1;
                }
                if ((n3 = element.getEndOffset() - 1 - n2) > n) {
                    n3 = n;
                }
            }
            Collection<Object> collection = Collections.emptyList();
            if (n3 > 0) {
                collection = MasterMatcher.findFactories(this.document, n2, bl);
            }
            if (!collection.isEmpty()) {
                MatcherContext matcherContext = SpiAccessor.get().createCaretContext(this.document, n2, bl, n3);
                for (BracesMatcherFactory bracesMatcherFactory : collection) {
                    bracesMatcherArray[0] = bracesMatcherFactory.createMatcher(matcherContext);
                    if (bracesMatcherArray[0] == null) continue;
                    break;
                }
                Object object = null;
                try {
                    object = bracesMatcherArray[0].findOrigin();
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, null, badLocationException);
                }
                if (object != null) {
                    if (((Object)object).length == 0) {
                        object = null;
                    } else if (((Object)object).length % 2 != 0) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Invalid BracesMatcher implementation, findOrigin() should return nothing or offset pairs. Offending BracesMatcher: " + bracesMatcherArray);
                        }
                        object = null;
                    } else if (object[0] < 0 || object[1] > this.document.getLength() || object[0] > object[1]) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Invalid origin offsets [" + (int)object[0] + ", " + (int)object[1] + "]. " + "Offending BracesMatcher: " + bracesMatcherArray);
                        }
                        object = null;
                    } else if (bl) {
                        if (object[1] < this.caretOffset - n3 || object[0] > this.caretOffset) {
                            if (LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("Origin offsets out of range, origin = [" + (int)object[0] + ", " + (int)object[1] + "], " + "caretOffset = " + this.caretOffset + ", lookahead = " + n3 + ", searching backwards. " + "Offending BracesMatcher: " + bracesMatcherArray);
                            }
                            object = null;
                        }
                    } else if (object[1] < this.caretOffset || object[0] > this.caretOffset + n3) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Origin offsets out of range, origin = [" + (int)object[0] + ", " + (int)object[1] + "], " + "caretOffset = " + this.caretOffset + ", lookahead = " + n3 + ", searching forward. " + "Offending BracesMatcher: " + bracesMatcherArray);
                        }
                        object = null;
                    }
                }
                if (object != null) {
                    LOG.fine("[" + (int)object[0] + ", " + (int)object[1] + "] for caret = " + this.caretOffset + ", lookahead = " + (bl ? "-" : "") + n3);
                } else {
                    LOG.fine("[null] for caret = " + this.caretOffset + ", lookahead = " + (bl ? "-" : "") + n3);
                }
                return object;
            }
            return null;
        }

        private void showSearchParameters(OffsetsBag offsetsBag) {
            Element element = DocumentUtilities.getParagraphElement((Document)this.document, (int)this.caretOffset);
            if (MasterMatcher.B_BACKWARD.equalsIgnoreCase(this.caretBias.toString())) {
                if (this.caretOffset > element.getStartOffset()) {
                    offsetsBag.addHighlight(this.caretOffset - 1, this.caretOffset, CARET_BIAS_HIGHLIGHT);
                }
            } else if (this.caretOffset < element.getEndOffset() - 1) {
                offsetsBag.addHighlight(this.caretOffset, this.caretOffset + 1, CARET_BIAS_HIGHLIGHT);
            }
            int n = Math.min(this.maxBwdLookahead, this.caretOffset - element.getStartOffset());
            int n2 = Math.min(this.maxFwdLookahead, element.getEndOffset() - 1 - this.caretOffset);
            offsetsBag.addHighlight(this.caretOffset - n, this.caretOffset, MAX_LOOKAHEAD_HIGHLIGHT);
            offsetsBag.addHighlight(this.caretOffset, this.caretOffset + n2, MAX_LOOKAHEAD_HIGHLIGHT);
        }
    }
}

