/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParseException;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.DatabaseContext;
import org.netbeans.modules.languages.features.DatabaseItem;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.DatabaseUsage;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class GoToDeclarationAction
extends BaseAction {
    public GoToDeclarationAction() {
        super(NbBundle.getBundle(GoToDeclarationAction.class).getString("LBL_GoToDeclaration"));
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        JTextComponent jTextComponent2 = this.getTextComponent(null);
        if (jTextComponent2 == null) {
            return;
        }
        ASTNode aSTNode = this.getASTNode(jTextComponent2);
        if (aSTNode == null) {
            return;
        }
        NbEditorDocument nbEditorDocument = (NbEditorDocument)jTextComponent2.getDocument();
        int n = jTextComponent2.getCaretPosition();
        ASTPath aSTPath = aSTNode.findPath(n);
        DatabaseContext databaseContext = DatabaseManager.getRoot((ASTNode)aSTPath.getRoot());
        if (databaseContext == null) {
            return;
        }
        DatabaseItem databaseItem = databaseContext.getDatabaseItem(aSTPath.getLeaf().getOffset());
        if (databaseItem == null) {
            return;
        }
        if (databaseItem instanceof DatabaseUsage) {
            databaseItem = ((DatabaseUsage)databaseItem).getDefinition();
        }
        int n2 = databaseItem.getOffset();
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)nbEditorDocument);
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        Line.Set set = lineCookie.getLineSet();
        Line line = set.getCurrent(NbDocument.findLineNumber((StyledDocument)nbEditorDocument, (int)n2));
        int n3 = NbDocument.findLineColumn((StyledDocument)nbEditorDocument, (int)n2);
        line.show(2, n3);
    }

    public boolean isEnabled() {
        JTextComponent jTextComponent = this.getTextComponent(null);
        if (jTextComponent == null) {
            return false;
        }
        ASTNode aSTNode = this.getASTNode(jTextComponent);
        if (aSTNode == null) {
            return false;
        }
        int n = jTextComponent.getCaretPosition();
        ASTPath aSTPath = aSTNode.findPath(n);
        DatabaseContext databaseContext = DatabaseManager.getRoot((ASTNode)aSTPath.getRoot());
        if (databaseContext == null) {
            return false;
        }
        DatabaseItem databaseItem = databaseContext.getDatabaseItem(aSTPath.getLeaf().getOffset());
        return databaseItem != null;
    }

    private ASTNode getASTNode(JTextComponent jTextComponent) {
        try {
            return ParserManagerImpl.get((Document)((NbEditorDocument)jTextComponent.getDocument())).getAST();
        }
        catch (ParseException parseException) {
            ErrorManager.getDefault().notify((Throwable)parseException);
            return null;
        }
    }
}

