/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTPath {
    ASTPath() {
    }

    public abstract ASTItem getLeaf();

    public abstract int size();

    public abstract ASTItem getRoot();

    public abstract ListIterator<ASTItem> listIterator();

    public abstract ListIterator<ASTItem> listIterator(int var1);

    public abstract ASTItem get(int var1);

    public abstract ASTPath subPath(int var1);

    public static ASTPath create(List<ASTItem> list) {
        if (list.isEmpty()) {
            return null;
        }
        return new Token2Path(list);
    }

    public static ASTPath create(ASTItem aSTItem) {
        if (aSTItem == null) {
            throw new NullPointerException();
        }
        return new TokenPath(aSTItem);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Token2Path
    extends ASTPath {
        private List<ASTItem> path;

        Token2Path(List<ASTItem> list) {
            this.path = list;
            if (list.size() < 1) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public ASTItem getLeaf() {
            return this.path.get(this.path.size() - 1);
        }

        @Override
        public int size() {
            return this.path.size();
        }

        @Override
        public ASTItem getRoot() {
            return this.path.get(0);
        }

        @Override
        public ListIterator<ASTItem> listIterator() {
            return this.path.listIterator();
        }

        @Override
        public ListIterator<ASTItem> listIterator(int n) {
            return this.path.listIterator(n);
        }

        @Override
        public ASTItem get(int n) {
            return this.path.get(n);
        }

        @Override
        public ASTPath subPath(int n) {
            return new Token2Path(this.path.subList(0, n + 1));
        }

        public String toString() {
            ASTItem aSTItem;
            StringBuilder stringBuilder = new StringBuilder("ASTPath ");
            Iterator<ASTItem> iterator = this.path.iterator();
            if (iterator.hasNext()) {
                aSTItem = iterator.next();
                if (aSTItem instanceof ASTNode) {
                    stringBuilder.append(((ASTNode)aSTItem).getNT());
                } else {
                    stringBuilder.append(aSTItem);
                }
            }
            while (iterator.hasNext()) {
                aSTItem = iterator.next();
                if (aSTItem instanceof ASTNode) {
                    stringBuilder.append(", ").append(((ASTNode)aSTItem).getNT());
                    continue;
                }
                stringBuilder.append(", ").append(aSTItem);
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenPath
    extends ASTPath {
        private ASTItem o;

        TokenPath(ASTItem aSTItem) {
            this.o = aSTItem;
        }

        @Override
        public ASTItem getLeaf() {
            return this.o;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ASTItem getRoot() {
            return this.o;
        }

        @Override
        public ListIterator<ASTItem> listIterator() {
            return Collections.singletonList(this.o).listIterator();
        }

        @Override
        public ListIterator<ASTItem> listIterator(int n) {
            return Collections.singletonList(this.o).listIterator(n);
        }

        @Override
        public ASTItem get(int n) {
            if (n == 0) {
                return this.o;
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        @Override
        public ASTPath subPath(int n) {
            if (n == 0) {
                return this;
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public String toString() {
            return "ASTPath " + this.o;
        }
    }
}

