/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.HelpAction;
import org.netbeans.modules.javahelp.JavaHelp;
import org.openide.modules.ModuleInstall;

public class Installer
extends ModuleInstall {
    public static final Logger log = Logger.getLogger("org.netbeans.modules.javahelp");
    public static final Logger UI = Logger.getLogger("org.netbeans.ui.javahelp");
    private static JavaHelp help = null;

    public void restored() {
        log.fine("restored module");
        HelpAction.WindowActivatedDetector.install();
        Installer.getDefaultHelp();
    }

    public void uninstalled() {
        log.fine("uninstalled module");
        if (help != null) {
            help.deactivate();
        }
        HelpAction.WindowActivatedDetector.uninstall();
        Installer.cleanDefaults(UIManager.getDefaults());
        Installer.cleanDefaults(UIManager.getLookAndFeelDefaults());
    }

    private static void cleanDefaults(UIDefaults uIDefaults) {
        HashSet hashSet = new HashSet(10);
        Iterator iterator = uIDefaults.entrySet().iterator();
        ClassLoader classLoader = Installer.class.getClassLoader();
        while (iterator.hasNext()) {
            Class clazz;
            Map.Entry entry;
            try {
                entry = iterator.next();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return;
            }
            Object object = entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Class) {
                clazz = (Class)v;
                if (clazz.getClassLoader() != classLoader) continue;
                hashSet.add(object);
                continue;
            }
            if (!(object instanceof Class) || (clazz = (Class)object).getClassLoader() != classLoader) continue;
            hashSet.add(object);
        }
        if (!hashSet.isEmpty()) {
            log.fine("Cleaning up old UIDefaults keys (JRE bug #4675772): " + hashSet);
            for (Object object : hashSet) {
                uIDefaults.put(object, (Object)null);
            }
        }
    }

    public static synchronized Help getDefaultHelp() {
        if (help == null) {
            help = new JavaHelp();
        }
        return help;
    }
}

