/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.LinkedList;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AsynchChildren<T>
extends Children.Keys<Object>
implements ChildFactory.Observer,
Runnable {
    private final ChildFactory<T> factory;
    private final RequestProcessor.Task task;
    private final RequestProcessor PROC = new RequestProcessor("Asynch children creator " + this, 5, true);
    volatile boolean initialized = false;
    volatile boolean cancelled = false;

    AsynchChildren(ChildFactory<T> childFactory) {
        childFactory.setObserver(this);
        this.factory = childFactory;
        this.task = this.PROC.create((Runnable)this, true);
    }

    @Override
    protected void addNotify() {
        if (!this.initialized && this.task.isFinished() || this.cancelled) {
            this.cancelled = false;
            Node node = this.factory.getWaitNode();
            if (node != null) {
                this.setKeys(new Object[]{node});
            }
            this.task.schedule(0);
        }
    }

    @Override
    protected void removeNotify() {
        this.cancelled = true;
        this.task.cancel();
        this.initialized = false;
        this.setKeys(Collections.emptyList());
    }

    @Override
    public void refresh(boolean bl) {
        if (bl &= !EventQueue.isDispatchThread()) {
            boolean bl2;
            LinkedList linkedList = new LinkedList();
            while (!(bl2 = this.factory.createKeys(linkedList))) {
            }
            this.setKeys(linkedList);
        } else {
            this.task.schedule(0);
        }
    }

    @Override
    public Node[] getNodes(boolean bl) {
        if (bl) {
            this.task.waitFinished();
        }
        return super.getNodes();
    }

    @Override
    protected Node[] createNodes(Object object) {
        if (ChildFactory.isWaitNode(object)) {
            return new Node[]{(Node)object};
        }
        return this.factory.createNodesForKey(object);
    }

    @Override
    public void run() {
        boolean bl;
        if (Thread.interrupted()) {
            this.setKeys(Collections.emptyList());
            return;
        }
        LinkedList linkedList = new LinkedList();
        do {
            bl = this.factory.createKeys(linkedList);
            if (this.cancelled || Thread.interrupted()) {
                this.setKeys(Collections.emptyList());
                return;
            }
            this.setKeys(new LinkedList(linkedList));
        } while (!bl && !Thread.interrupted());
        this.initialized = bl;
    }
}

