/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.xml;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import java.io.StringWriter;

public class Marshaller {
    private String currentIndentation = "";
    public static final String[] special_chars = new String[]{"&", "&amp;", "\"", "&quot;", "'", "&apos;", "<", "&lt;", ">", "&gt;"};
    private String encoding = "UTF-8";

    public static void marshal(Object obj, StringWriter out) {
        Marshaller marshaller = new Marshaller();
        if (obj instanceof Request) {
            out.write(marshaller.marshal((Request)obj));
        } else if (obj instanceof OperationResult) {
            out.write(marshaller.marshal((OperationResult)obj));
        }
    }

    public static String xmlEscape(String text) {
        if (text == null) {
            return "";
        }
        int i = 0;
        String tmp = "";
        for (i = 0; i < special_chars.length; i += 2) {
            text = Marshaller.string_replace(special_chars[i + 1], special_chars[i], text);
        }
        return text;
    }

    public static String string_replace(String s1, String s2, String s3) {
        String string = "";
        string = "";
        if (s2 == null || s3 == null || s2.length() == 0) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = string + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        string = string + s3.substring(pos_i);
        return string;
    }

    public String marshal(Request request) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>\n");
        xml.append("<request operationName=\"" + request.getOperationName() + "\"");
        if (request.getLocale() != null) {
            xml.append(" locale=\"" + request.getLocale() + "\"");
        }
        xml.append(">\n");
        this.currentIndentation = "\t";
        for (int i = 0; i < request.getArguments().size(); ++i) {
            Argument a = (Argument)request.getArguments().get(i);
            String value = a.getValue() == null ? "/>" : "><![CDATA[" + a.getValue() + "]]></argument>";
            xml.append(this.currentIndentation + "<argument name=\"" + Marshaller.xmlEscape(a.getName()) + "\"" + value + "\n");
        }
        xml.append(this.writeResourceDescriptor(request.getResourceDescriptor()));
        xml.append("</request>\n");
        return xml.toString();
    }

    public String writeResourceDescriptor(ResourceDescriptor rd) {
        Object rdchild;
        int i;
        if (rd == null) {
            return "";
        }
        StringBuffer xml = new StringBuffer();
        xml.append(this.currentIndentation + "<resourceDescriptor");
        xml.append(" name=\"" + Marshaller.xmlEscape(rd.getName()) + "\"");
        xml.append(" wsType=\"" + Marshaller.xmlEscape(rd.getWsType()) + "\"");
        xml.append(" uriString=\"" + Marshaller.xmlEscape(rd.getUriString()) + "\"");
        xml.append(" isNew=\"" + rd.getIsNew() + "\"");
        xml.append(">\n");
        this.currentIndentation = this.currentIndentation + "\t";
        xml.append(this.currentIndentation + "<label><![CDATA[" + rd.getLabel() + "]]></label>\n");
        if (rd.getDescription() != null && rd.getDescription().length() > 0) {
            xml.append(this.currentIndentation + "<description><![CDATA[" + rd.getDescription() + "]]></description>\n");
        }
        if (rd.getProperties() != null) {
            for (i = 0; i < rd.getProperties().size(); ++i) {
                ResourceProperty rp = (ResourceProperty)rd.getProperties().get(i);
                String s = this.writeResourceProperty(rp);
                xml.append(s);
            }
        }
        if (rd.getChildren() != null) {
            for (i = 0; i < rd.getChildren().size(); ++i) {
                rdchild = (ResourceDescriptor)rd.getChildren().get(i);
                xml.append(this.writeResourceDescriptor((ResourceDescriptor)rdchild));
            }
        }
        if (rd.getParameters() != null) {
            for (i = 0; i < rd.getParameters().size(); ++i) {
                rdchild = (ListItem)rd.getParameters().get(i);
                xml.append(this.writeResourceParameter((ListItem)rdchild));
            }
        }
        this.currentIndentation = this.currentIndentation.substring(0, this.currentIndentation.length() - 1);
        xml.append(this.currentIndentation + "</resourceDescriptor>\n");
        return xml.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private String writeResourceProperty(ResourceProperty rp) {
        StringBuffer xml = new StringBuffer();
        xml.append(this.currentIndentation + "<resourceProperty name=\"" + Marshaller.xmlEscape(rp.getName()) + "\">\n");
        this.currentIndentation = this.currentIndentation + "\t";
        if (rp.getValue() != null) {
            xml.append(this.currentIndentation + "<value><![CDATA[" + rp.getValue() + "]]></value>\n");
        }
        for (int i = 0; i < rp.getProperties().size(); ++i) {
            ResourceProperty rpChild = (ResourceProperty)rp.getProperties().get(i);
            xml.append(this.writeResourceProperty(rpChild));
        }
        this.currentIndentation = this.currentIndentation.substring(0, this.currentIndentation.length() - 1);
        xml.append(this.currentIndentation + "</resourceProperty>\n");
        return xml.toString();
    }

    private String writeResourceParameter(ListItem rp) {
        StringBuffer xml = new StringBuffer();
        xml.append(this.currentIndentation + "<parameter name=\"" + Marshaller.xmlEscape(rp.getLabel()) + "\"");
        if (rp.isIsListItem()) {
            xml.append(" isListItem=\"true\"");
        }
        xml.append("><![CDATA[");
        if (rp.getValue() != null) {
            xml.append(rp.getValue());
        }
        xml.append("]]></parameter>\n");
        return xml.toString();
    }

    public String marshal(OperationResult response) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>\n");
        xml.append("<operationResult version=\"" + response.getVersion() + "\">\n");
        this.currentIndentation = "\t";
        xml.append(this.currentIndentation + "<returnCode><![CDATA[" + response.getReturnCode() + "]]></returnCode>\n");
        if (response.getMessage() != null && response.getMessage().length() > 0) {
            xml.append(this.currentIndentation + "<returnMessage><![CDATA[" + response.getMessage() + "]]></returnMessage>\n");
        }
        if (response.getResourceDescriptors() != null) {
            for (int i = 0; i < response.getResourceDescriptors().size(); ++i) {
                ResourceDescriptor rd = (ResourceDescriptor)response.getResourceDescriptors().get(i);
                xml.append(this.writeResourceDescriptor(rd));
            }
        }
        this.currentIndentation = this.currentIndentation.substring(0, this.currentIndentation.length() - 1);
        xml.append("</operationResult>\n");
        return xml.toString();
    }
}

