/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.SimpleChartTheme;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;

public class XmlChartTheme
extends SimpleChartTheme {
    private static final String MAPPING_FILE = "net/sf/jasperreports/chartthemes/simple/chart.theme.mapping.xml";
    private String file = null;

    public XmlChartTheme() {
    }

    public XmlChartTheme(String file) {
        this.file = file;
    }

    public void setFile(String file) {
        this.file = file;
        this.chartThemeSettings = null;
    }

    public ChartThemeSettings getChartThemeSettings() {
        if (this.chartThemeSettings == null) {
            this.chartThemeSettings = XmlChartTheme.loadSettings(this.file);
        }
        return this.chartThemeSettings;
    }

    public static ChartThemeSettings loadSettings(String file) {
        InputStream is = null;
        try {
            is = JRLoader.getLocationInputStream((String)file);
            ChartThemeSettings chartThemeSettings = XmlChartTheme.loadSettings(is);
            return chartThemeSettings;
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static ChartThemeSettings loadSettings(InputStream is) {
        ChartThemeSettings settings = null;
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(new InputSource(JRLoader.getLocationInputStream((String)MAPPING_FILE)));
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            settings = (ChartThemeSettings)unmarshaller.unmarshal(new InputSource(is));
        }
        catch (MappingException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (MarshalException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return settings;
    }

    public static void saveSettings(ChartThemeSettings settings, Writer writer) {
        try {
            Marshaller marshaller = new Marshaller(writer);
            Mapping mapping = new Mapping();
            mapping.loadMapping(new InputSource(JRLoader.getLocationInputStream((String)MAPPING_FILE)));
            marshaller.setMapping(mapping);
            marshaller.marshal((Object)settings);
        }
        catch (IOException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (MappingException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (MarshalException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public static void saveSettings(ChartThemeSettings settings, File file) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            XmlChartTheme.saveSettings(settings, writer);
        }
        catch (IOException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveSettings(ChartThemeSettings settings) {
        StringWriter writer = new StringWriter();
        try {
            XmlChartTheme.saveSettings(settings, writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return writer.toString();
    }
}

