/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.modules.editor.guards.GuardedSectionsImpl;
import org.netbeans.modules.editor.guards.PositionBounds;
import org.openide.text.NbDocument;

public abstract class GuardedSectionImpl {
    String name;
    boolean valid = false;
    final GuardedSectionsImpl guards;
    GuardedSection guard;

    public String getName() {
        return this.name;
    }

    GuardedSectionImpl(String string, GuardedSectionsImpl guardedSectionsImpl) {
        this.name = string;
        this.guards = guardedSectionsImpl;
    }

    public final void attach(GuardedSection guardedSection) {
        this.guard = guardedSection;
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) throws PropertyVetoException {
        if (!this.name.equals(string)) {
            Map<String, GuardedSectionImpl> map = this.guards.sections;
            synchronized (map) {
                if (this.valid) {
                    if (this.guards.sections.get(string) != null) {
                        throw new PropertyVetoException("", new PropertyChangeEvent(this, "name", this.name, string));
                    }
                    this.guards.sections.remove(this.name);
                    this.name = string;
                    this.guards.sections.put(string, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSection() {
        Map<String, GuardedSectionImpl> map = this.guards.sections;
        synchronized (map) {
            if (this.valid) {
                try {
                    this.guards.sections.remove(this.name);
                    this.unmarkGuarded(this.guards.getDocument());
                    this.deleteText();
                    this.valid = false;
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalStateException(badLocationException);
                }
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSection() {
        Map<String, GuardedSectionImpl> map = this.guards.sections;
        synchronized (map) {
            if (this.valid) {
                this.guards.sections.remove(this.name);
                this.unmarkGuarded(this.guards.getDocument());
                this.valid = false;
            }
        }
    }

    protected boolean setText(PositionBounds positionBounds, String string, boolean bl) {
        if (!this.valid) {
            return false;
        }
        if (bl && (string.length() == 0 || string.length() == 1 && string.equals("\n"))) {
            string = " ";
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            positionBounds.setText(string);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    void markGuarded(StyledDocument styledDocument, PositionBounds positionBounds, boolean bl) {
        int n = positionBounds.getBegin().getOffset();
        int n2 = positionBounds.getEnd().getOffset();
        if (bl) {
            NbDocument.markGuarded((StyledDocument)styledDocument, (int)n, (int)(n2 - n + 1));
        } else {
            NbDocument.unmarkGuarded((StyledDocument)styledDocument, (int)n, (int)(n2 - n + 1));
        }
    }

    abstract void markGuarded(StyledDocument var1);

    abstract void unmarkGuarded(StyledDocument var1);

    final void deleteText() throws BadLocationException {
        if (this.valid) {
            final StyledDocument styledDocument = this.guards.getDocument();
            final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

                public void run() {
                    try {
                        int n = GuardedSectionImpl.this.getStartPosition().getOffset();
                        if (n > 0 && "\n".equals(styledDocument.getText(n - 1, 1))) {
                            --n;
                        }
                        styledDocument.remove(n, GuardedSectionImpl.this.getEndPosition().getOffset() - n + 1);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationExceptionArray[0] = badLocationException;
                    }
                }
            });
            if (badLocationExceptionArray[0] != null) {
                throw badLocationExceptionArray[0];
            }
        }
    }

    public abstract Position getCaretPosition();

    public abstract String getText();

    public abstract boolean contains(Position var1, boolean var2);

    public abstract Position getEndPosition();

    public abstract Position getStartPosition();

    public abstract void resolvePositions() throws BadLocationException;
}

