/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Toolkit;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatWriter;

public class ExtFormatter
extends Formatter
implements FormatLayer {
    private List formatLayerList = new ArrayList();
    private static final Object NULL_VALUE = new Object();
    private HashMap settingsMap = new HashMap();
    private HashMap customSettingsNamesMap = new HashMap();
    private Acceptor indentHotCharsAcceptor;
    private boolean reindentWithTextBefore;

    public ExtFormatter(Class clazz) {
        super(clazz);
        this.initFormatLayers();
    }

    protected void initFormatLayers() {
    }

    public String getName() {
        return this.getKitClass().getName().substring(this.getKitClass().getName().lastIndexOf(46) + 1);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        super.settingsChange(settingsChangeEvent);
        String string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        Class clazz = this.getKitClass();
        for (Map.Entry entry : this.settingsMap.entrySet()) {
            if (string != null && !entry.getKey().equals(entry.getKey()) || this.customSettingsNamesMap.containsKey(entry.getKey())) continue;
            entry.setValue(Settings.getValue(clazz, (String)entry.getKey()));
        }
        this.indentHotCharsAcceptor = SettingsUtil.getAcceptor(clazz, "indent-hot-chars-acceptor", AcceptorFactory.FALSE);
        this.reindentWithTextBefore = SettingsUtil.getBoolean(clazz, "reindent-with-text-before", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSettingValue(String string) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Object object = this.settingsMap.get(string);
            if (object == null && !this.customSettingsNamesMap.containsKey(string)) {
                object = Settings.getValue(this.getKitClass(), string);
                if (object == null) {
                    object = NULL_VALUE;
                }
                this.settingsMap.put(string, object);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return object != NULL_VALUE ? object : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettingValue(String string, Object object) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            this.customSettingsNamesMap.put(string, string);
            this.settingsMap.put(string, object);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public synchronized void addFormatLayer(FormatLayer formatLayer) {
        this.formatLayerList.add(formatLayer);
    }

    public synchronized boolean replaceFormatLayer(String string, FormatLayer formatLayer) {
        int n = this.formatLayerList.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(((FormatLayer)this.formatLayerList.get(i)).getName())) continue;
            this.formatLayerList.set(i, formatLayer);
            return true;
        }
        return false;
    }

    public synchronized void removeFormatLayer(String string) {
        Iterator iterator = this.formatLayerIterator();
        while (iterator.hasNext()) {
            if (!string.equals(((FormatLayer)iterator.next()).getName())) continue;
            iterator.remove();
            return;
        }
    }

    public Iterator formatLayerIterator() {
        return this.formatLayerList.iterator();
    }

    public boolean isSimple() {
        return false;
    }

    public synchronized void format(FormatWriter formatWriter) {
        boolean bl = false;
        int n = 0;
        do {
            formatWriter.setChainModified(false);
            formatWriter.setRestartFormat(false);
            Iterator iterator = this.formatLayerIterator();
            while (iterator.hasNext()) {
                ((FormatLayer)iterator.next()).format(formatWriter);
                if (!formatWriter.isRestartFormat()) continue;
            }
            if (!iterator.hasNext() && !formatWriter.isRestartFormat()) {
                bl = true;
            }
            if (n <= 1000) continue;
            new Exception("Indentation infinite loop detected").printStackTrace();
            break;
        } while (!bl);
    }

    public Writer reformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException, IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        Writer writer = this.createWriter(baseDocument, n, charArrayWriter);
        FormatWriter formatWriter = writer instanceof FormatWriter ? (FormatWriter)writer : null;
        boolean bl2 = true;
        if (formatWriter != null) {
            formatWriter.setIndentOnly(bl);
            if (bl2) {
                formatWriter.setReformatting(true);
            }
        }
        writer.write(baseDocument.getChars(n, n2 - n));
        writer.close();
        if (!bl2 || formatWriter == null) {
            String string = new String(charArrayWriter.toCharArray());
            baseDocument.remove(n, n2 - n);
            baseDocument.insertString(n, string, null);
        }
        return writer;
    }

    public int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        try {
            Position position = baseDocument.createPosition(n2);
            this.reformat(baseDocument, n, n2, false);
            return position.getOffset() - n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        if (this.indentHotCharsAcceptor == null) {
            this.settingsChange(null);
        }
        if (this.indentHotCharsAcceptor.accept(string.charAt(0))) {
            if (!this.reindentWithTextBefore && this.hasTextBefore(jTextComponent, string)) {
                return null;
            }
            int n = jTextComponent.getCaret().getDot();
            return new int[]{Math.max(n - 1, 0), n};
        }
        return null;
    }

    protected boolean hasTextBefore(JTextComponent jTextComponent, String string) {
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        try {
            int n2 = Utilities.getRowFirstNonWhite(baseDocument, n);
            return n != n2 + string.length();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        return new FormatWriter(this, document, n, writer, false);
    }

    public int indentLine(Document document, int n) {
        if (document instanceof BaseDocument) {
            try {
                BaseDocument baseDocument = (BaseDocument)document;
                int n2 = Utilities.getRowStart(baseDocument, n);
                int n3 = Utilities.getRowStart(baseDocument, n, 1);
                if (n3 < 0) {
                    n3 = baseDocument.getLength();
                }
                this.reformat(baseDocument, n2, n3, false);
                return Utilities.getRowEnd(baseDocument, n2);
            }
            catch (GuardedException guardedException) {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
            catch (IOException iOException) {
                Utilities.annotateLoggable(iOException);
            }
            return n;
        }
        return super.indentLine(document, n);
    }

    protected int getEOLOffset(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getRowEnd(baseDocument, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indentNewLine(Document document, int n) {
        if (document instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)document;
            boolean bl = false;
            baseDocument.atomicLock();
            try {
                baseDocument.insertString(n, "\n", null);
                bl = true;
                int n2 = Utilities.getRowEnd(baseDocument, ++n);
                Writer writer = this.reformat(baseDocument, n, n2, true);
                n2 = Utilities.getRowFirstNonWhite(baseDocument, n);
                if (n2 < 0) {
                    n2 = this.getEOLOffset(baseDocument, n);
                }
                n = n2;
                if (!(writer instanceof FormatWriter)) return n;
                n += ((FormatWriter)writer).getIndentShift();
                return n;
            }
            catch (GuardedException guardedException) {
                if (bl) return n;
                Toolkit.getDefaultToolkit().beep();
                return n;
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
                return n;
            }
            catch (IOException iOException) {
                Utilities.annotateLoggable(iOException);
                return n;
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
        try {
            document.insertString(n, "\n", null);
            ++n;
            return n;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n;
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return true;
    }

    public static class Simple
    extends ExtFormatter {
        public Simple(Class clazz) {
            super(clazz);
        }

        public boolean isSimple() {
            return true;
        }

        protected int getEOLOffset(BaseDocument baseDocument, int n) throws BadLocationException {
            return n;
        }
    }
}

