/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DeleteDatasetUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignDataset dataset = null;
    private JasperDesign jasperDesign = null;
    private int index = -1;

    public DeleteDatasetUndoableEdit(JRDesignDataset dataset, JasperDesign jasperDesign, int index) {
        this.dataset = dataset;
        this.index = index;
        if (index < 0) {
            index = jasperDesign.getDatasetsList().size();
        }
        this.jasperDesign = jasperDesign;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.jasperDesign.getDatasetsList().add(this.index, this.getDataset());
        this.jasperDesign.getEventSupport().firePropertyChange("datasets", null, null);
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.jasperDesign.removeDataset((JRDataset)this.getDataset());
    }

    public String getPresentationName() {
        return "Delete Dataset " + this.getDataset().getName();
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }
}

