/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignSubreportParameter;

public class JRSubreportParameterDialog
extends JDialog {
    JRDesignSubreportParameter tmpParameter = null;
    private String oldName = null;
    private Map currentParameters = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ExpressionEditorArea jRTextExpressionAreaDefaultExpression;
    private JSeparator jSeparator1;
    private JTextField jTextFieldName;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_PARAM_NAME = 1;
    public static final int COMPONENT_PARAM_EXPRESSION = 2;

    public JRSubreportParameterDialog(Dialog parent, Map currentParameters) {
        super(parent);
        this.initAll(currentParameters);
    }

    public JRSubreportParameterDialog(Frame parent, Map currentParameters) {
        super(parent);
        this.initAll(currentParameters);
    }

    public void initAll(Map currentParameters) {
        this.setModal(true);
        this.initComponents();
        this.currentParameters = currentParameters;
        this.jRTextExpressionAreaDefaultExpression.setText("");
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRSubreportParameterDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionAreaDefaultExpression = new ExpressionEditorArea();
        this.jSeparator1 = new JSeparator();
        ResourceBundle bundle = ResourceBundle.getBundle("com/jaspersoft/ireport/locale/Bundle");
        this.setTitle(bundle.getString("JRSubreportParameterDialog.Title.AddModParam"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRSubreportParameterDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText(bundle.getString("Global.Button.Ok"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRSubreportParameterDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText(bundle.getString("Global.Button.Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRSubreportParameterDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setPreferredSize(new Dimension(350, 250));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("JRSubreportParameterDialog.Label.SubreportParamName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel3.setText(bundle.getString("JRSubreportParameterDialog.Label.ValueExpression"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(300, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.setBounds(0, 0, 320, 220);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String newName = this.jTextFieldName.getText().trim();
        if (newName.length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRSubreportParameterDialog.Message.Warning"), I18n.getString("JRSubreportParameterDialog.Message.Error"), 2);
            return;
        }
        if (this.oldName != null && !this.oldName.equals(newName) && this.currentParameters != null && this.currentParameters.containsKey(newName)) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRSubreportParameterDialog.Message.Warning2"), I18n.getString("JRSubreportParameterDialog.Message.Error2"), 2);
            return;
        }
        this.tmpParameter = new JRDesignSubreportParameter();
        this.tmpParameter.setName(this.jTextFieldName.getText().trim());
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText(this.jRTextExpressionAreaDefaultExpression.getText());
        exp.setValueClassName("java.lang.Object");
        this.tmpParameter.setExpression((JRExpression)exp);
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRDesignSubreportParameter getParameter() {
        return this.tmpParameter;
    }

    public void setParameter(JRDesignSubreportParameter tmpParameter) {
        this.jTextFieldName.setText(tmpParameter.getName());
        this.oldName = tmpParameter.getName();
        String text = "";
        if (tmpParameter.getExpression() != null && tmpParameter.getExpression().getText() != null) {
            text = tmpParameter.getExpression().getText();
        }
        this.jRTextExpressionAreaDefaultExpression.setText(text);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setFocusedExpression(int expID) {
        try {
            switch (expID) {
                case 2: {
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaDefaultExpression);
                    break;
                }
                case 1: {
                    Misc.selectTextAndFocusArea(this.jTextFieldName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExpressionContext(ExpressionContext context) {
        this.jRTextExpressionAreaDefaultExpression.setExpressionContext(context);
    }
}

