/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.charts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.properties.ExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.design.JRDesignDataRange;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public final class ThermometerMediumDataRangeHighExpressionProperty
extends ExpressionProperty {
    private final JRDesignThermometerPlot plot;

    public ThermometerMediumDataRangeHighExpressionProperty(JRDesignThermometerPlot plot, JRDesignDataset dataset) {
        super((Object)plot, dataset);
        this.plot = plot;
    }

    public String getName() {
        return I18n.getString("MEDIUM_RANGE_") + "highExpression";
    }

    public String getDisplayName() {
        return I18n.getString("Medium_Data_Range_High_Expression");
    }

    public String getShortDescription() {
        return I18n.getString("Medium_Data_Range_High_Expression.");
    }

    public String getDefaultExpressionClassName() {
        return Number.class.getName();
    }

    public JRDesignExpression getExpression() {
        JRDataRange dataRange = this.plot.getMediumRange();
        return dataRange == null ? null : (JRDesignExpression)dataRange.getHighExpression();
    }

    public void setExpression(JRDesignExpression expression) {
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JRDataRange oldValue = this.plot.getMediumRange();
        JRDesignDataRange newValue = new JRDesignDataRange(null);
        if (oldValue != null) {
            try {
                newValue = (JRDesignDataRange)oldValue.clone();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (val == null || val.equals(I18n.getString(""))) {
            newValue.setHighExpression(null);
        } else {
            String s = val != null ? val + I18n.getString("") : I18n.getString("");
            JRDesignExpression newExp = new JRDesignExpression();
            newExp.setText(s);
            newExp.setValueClassName(this.getDefaultExpressionClassName());
            newValue.setHighExpression((JRExpression)newExp);
        }
        try {
            this.plot.setMediumRange((JRDataRange)newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.plot, "MediumRange", JRDataRange.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

