/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.editors.ExpressionPropertyCustomEditor;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class ExpressionPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
    private boolean editable = true;
    private boolean customEd = true;
    private PropertyEnv env;

    public boolean isEditable() {
        return false;
    }

    public void setAsText(String s) {
        if ("null".equals(s) && this.getValue() == null) {
            return;
        }
        this.setValue(s);
    }

    public String getJavaInitializationString() {
        String s = (String)this.getValue();
        return "\"" + ExpressionPropertyEditor.toAscii(s) + "\"";
    }

    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    public Component getCustomEditor() {
        Object val = this.getValue();
        String s = "";
        if (val != null) {
            s = val instanceof String ? (String)val : val.toString();
        }
        return new ExpressionPropertyCustomEditor(s, this.isEditable(), false, null, this, this.env);
    }

    private static String toAscii(String str) {
        StringBuffer buf = new StringBuffer(str.length() * 6);
        char[] chars = str.toCharArray();
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        buf.append(c);
                        continue block9;
                    }
                    buf.append("\\u");
                    String hex = Integer.toHexString(c);
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buf.append('0');
                    }
                    buf.append(hex);
                }
            }
        }
        return buf.toString();
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.editable = prop.canWrite();
            this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        }
        this.env = env;
    }
}

