/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.StringCustomEditor;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.List;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class ComboBoxPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private List tagValues = null;
    private boolean editable = true;
    private String instructions = null;
    private boolean oneline = false;
    private boolean customEd = true;
    private PropertyEnv env;

    public ComboBoxPropertyEditor(boolean editable, List tagValues) {
        this.tagValues = tagValues;
        this.editable = editable;
    }

    public void setValue(Object value) {
        Tag t = Tag.findTagByValue(value, this.tagValues);
        super.setValue(t != null ? t : value);
    }

    public Object getValue() {
        Object value = super.getValue();
        if (value instanceof Tag) {
            return ((Tag)value).getValue();
        }
        return value;
    }

    public String getAsText() {
        Object key = this.getValue();
        Tag t = Tag.findTagByValue(key, this.tagValues);
        if (t == null) {
            return "" + key;
        }
        return t.toString();
    }

    public void setAsText(String s) {
        Tag t = Tag.findTagByName(s, this.tagValues);
        this.setValue(t != null ? t.getValue() : s);
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.instructions = (String)prop.getValue("instructions");
            this.oneline = Boolean.TRUE.equals(prop.getValue("oneline"));
            this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        }
    }

    public String[] getTags() {
        String[] s = new String[this.tagValues.size()];
        for (int i = 0; i < this.tagValues.size(); ++i) {
            s[i] = "" + this.tagValues.get(i);
        }
        return s;
    }

    public void setTagValues(List newValues) {
        this.tagValues = newValues;
        this.firePropertyChange();
    }

    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    public Component getCustomEditor() {
        Object val = this.getValue();
        String s = "";
        if (val != null) {
            s = val instanceof String ? (String)val : val.toString();
        }
        return new StringCustomEditor(s, this.editable, this.oneline, this.instructions, this, this.env);
    }
}

