/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.errorhandler.IRExpressionCollector;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JasperDesign;

public class HasExpressionVisitor
implements JRVisitor {
    private JasperDesign jasperDesign = null;
    private JRExpression expression = null;
    private IRExpressionCollector collector = null;

    public HasExpressionVisitor(JasperDesign jasperDesign, JRExpression expression) {
        this.jasperDesign = jasperDesign;
        this.expression = expression;
        this.collector = new IRExpressionCollector(jasperDesign);
    }

    public boolean hasExpression(JRVisitable visitable) {
        visitable.visit((JRVisitor)this);
        return this.collector.getExpressions().contains(this.getExpression());
    }

    public void visitBreak(JRBreak breakElement) {
        this.collector.collect(breakElement);
    }

    public void visitChart(JRChart chart) {
        this.collector.collect(chart);
    }

    public void visitCrosstab(JRCrosstab crosstab) {
        this.collector.collect(crosstab);
    }

    public void visitElementGroup(JRElementGroup elementGroup) {
    }

    public void visitEllipse(JREllipse ellipse) {
        this.collector.collect(ellipse);
    }

    public void visitFrame(JRFrame frame) {
        this.collector.collect(frame);
    }

    public void visitImage(JRImage image) {
        this.collector.collect(image);
    }

    public void visitLine(JRLine line) {
        this.collector.collect(line);
    }

    public void visitRectangle(JRRectangle rectangle) {
        this.collector.collect(rectangle);
    }

    public void visitStaticText(JRStaticText staticText) {
        this.collector.collect(staticText);
    }

    public void visitSubreport(JRSubreport subreport) {
        this.collector.collect(subreport);
    }

    public void visitTextField(JRTextField textField) {
        this.collector.collect(textField);
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public void setExpression(JRExpression expression) {
        this.expression = expression;
    }

    public void visitComponentElement(JRComponentElement componentElement) {
        this.collector.collect(componentElement);
    }

    public void visitGenericElement(JRGenericElement genericElement) {
        this.collector.collect(genericElement);
    }
}

