/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.IReportOptionsPanelController;
import com.jaspersoft.ireport.designer.options.OptionsPanel;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.util.JRProperties;
import org.jdesktop.layout.GroupLayout;

public class PdfExportParametersPanel
extends JPanel
implements OptionsPanel {
    IReportOptionsPanelController controller = null;
    private JCheckBox jCheckBoxAllawDegradedPrinting;
    private JCheckBox jCheckBoxAllowAssembly;
    private JCheckBox jCheckBoxAllowCopy;
    private JCheckBox jCheckBoxAllowFillIn;
    private JCheckBox jCheckBoxAllowModifyAnnotations;
    private JCheckBox jCheckBoxAllowModifyContents;
    private JCheckBox jCheckBoxAllowPrinting;
    private JCheckBox jCheckBoxAllowScreenReaders;
    private JCheckBox jCheckBoxCompressed;
    private JCheckBox jCheckBoxCreatingBatchModeBookmarks;
    private JCheckBox jCheckBoxForceLinebreakPolicy;
    private JCheckBox jCheckBoxForceSVGShapes;
    private JCheckBox jCheckBoxIsTagged;
    private JComboBox jComboBoxEncryption;
    private JComboBox jComboBoxPDFVersion;
    private JLabel jLabelEncryption;
    private JLabel jLabelMetadataAuthor;
    private JLabel jLabelMetadataCreator;
    private JLabel jLabelMetadataKeywords;
    private JLabel jLabelMetadataSubject;
    private JLabel jLabelMetadataTitle;
    private JLabel jLabelOwnerPassword;
    private JLabel jLabelPDFJavascript;
    private JLabel jLabelPDFVersion;
    private JLabel jLabelTagLanguage;
    private JLabel jLabelTitle;
    private JLabel jLabelUserPassword;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextAreaPDFJavascript;
    private JTextField jTextFieldMetadataAuthor;
    private JTextField jTextFieldMetadataCreator;
    private JTextField jTextFieldMetadataKeywords;
    private JTextField jTextFieldMetadataSubject;
    private JTextField jTextFieldMetadataTitle;
    private JTextField jTextFieldOwnerPassword;
    private JTextField jTextFieldTagLanguage;
    private JTextField jTextFieldUserPassword;

    public PdfExportParametersPanel(IReportOptionsPanelController ctlr) {
        this.controller = ctlr;
        this.initComponents();
        this.applyI18n();
        DocumentListener textfieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PdfExportParametersPanel.this.controller.changed();
            }

            public void insertUpdate(DocumentEvent evt) {
                PdfExportParametersPanel.this.controller.changed();
            }

            public void removeUpdate(DocumentEvent evt) {
                PdfExportParametersPanel.this.controller.changed();
            }
        };
        this.jTextFieldMetadataAuthor.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldMetadataCreator.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldMetadataKeywords.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldMetadataSubject.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldMetadataTitle.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldOwnerPassword.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldUserPassword.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldTagLanguage.getDocument().addDocumentListener(textfieldListener);
        this.jTextAreaPDFJavascript.getDocument().addDocumentListener(textfieldListener);
        this.jComboBoxEncryption.addItem(I18n.getString("export.pdf.encryption.None"));
        this.jComboBoxEncryption.addItem(I18n.getString("export.pdf.encryption.Standard"));
        this.jComboBoxEncryption.addItem(I18n.getString("export.pdf.encryption.128bitKey"));
        this.jComboBoxPDFVersion.addItem(new Tag(null, I18n.getString("Global.Button.Default")));
        this.jComboBoxPDFVersion.addItem(new Tag("" + JRPdfExporterParameter.PDF_VERSION_1_2, "1.2"));
        this.jComboBoxPDFVersion.addItem(new Tag("" + JRPdfExporterParameter.PDF_VERSION_1_3, "1.3"));
        this.jComboBoxPDFVersion.addItem(new Tag("" + JRPdfExporterParameter.PDF_VERSION_1_4, "1.4"));
        this.jComboBoxPDFVersion.addItem(new Tag("" + JRPdfExporterParameter.PDF_VERSION_1_5, "1.5"));
        this.jComboBoxPDFVersion.addItem(new Tag("" + JRPdfExporterParameter.PDF_VERSION_1_6, "1.6"));
    }

    public void notifyChange() {
        if (this.controller != null) {
            this.controller.changed();
        }
    }

    public void load() {
        Preferences pref = IReportManager.getPreferences();
        Misc.setComboboxSelectedTagValue(this.jComboBoxPDFVersion, pref.get("net.sf.jasperreports.export.pdf.version", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.version")));
        this.jCheckBoxCreatingBatchModeBookmarks.setSelected(pref.getBoolean("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks")));
        this.jCheckBoxCompressed.setSelected(pref.getBoolean("net.sf.jasperreports.export.pdf.compressed", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.compressed")));
        this.jCheckBoxForceLinebreakPolicy.setSelected(pref.getBoolean("net.sf.jasperreports.export.pdf.force.linebreak.policy", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.force.linebreak.policy")));
        this.jCheckBoxForceSVGShapes.setSelected(pref.getBoolean("net.sf.jasperreports.export.pdf.force.svg.shapes", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.force.svg.shapes")));
        this.jCheckBoxIsTagged.setSelected(pref.getBoolean("net.sf.jasperreports.export.pdf.tagged", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.tagged")));
        this.jComboBoxEncryption.setSelectedIndex(0);
        if (pref.getBoolean("net.sf.jasperreports.export.pdf.encrypted", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.encrypted"))) {
            this.jComboBoxEncryption.setSelectedIndex(1);
        }
        if (pref.getBoolean("net.sf.jasperreports.export.pdf.128.bit.key", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.128.bit.key"))) {
            this.jComboBoxEncryption.setSelectedIndex(2);
        }
        this.jTextFieldMetadataAuthor.setText(pref.get("export.pdf.METADATA_AUTHOR", ""));
        this.jTextFieldMetadataCreator.setText(pref.get("export.pdf.METADATA_CREATOR", ""));
        this.jTextFieldMetadataKeywords.setText(pref.get("export.pdf.METADATA_KEYWORDS", ""));
        this.jTextFieldMetadataSubject.setText(pref.get("export.pdf.METADATA_SUBJECT", ""));
        this.jTextFieldMetadataTitle.setText(pref.get("export.pdf.METADATA_TITLE", ""));
        this.jTextFieldOwnerPassword.setText(pref.get("export.pdf.OWNER_PASSWORD", ""));
        this.jTextFieldUserPassword.setText(pref.get("export.pdf.USER_PASSWORD", ""));
        this.jTextFieldTagLanguage.setText(pref.get("export.pdf.TAG_LANGUAGE", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.tag.language")));
        this.jTextAreaPDFJavascript.setText(pref.get("export.pdf.PDF_JAVASCRIPT", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.javascript")));
        int documentPermissions = pref.getInt("export.pdf.PERMISSIONS", 0);
        this.jCheckBoxAllawDegradedPrinting.setSelected((documentPermissions & 4) > 0);
        this.jCheckBoxAllowAssembly.setSelected((documentPermissions & 0x400) > 0);
        this.jCheckBoxAllowCopy.setSelected((documentPermissions & 0x10) > 0);
        this.jCheckBoxAllowFillIn.setSelected((documentPermissions & 0x100) > 0);
        this.jCheckBoxAllowModifyAnnotations.setSelected((documentPermissions & 0x20) > 0);
        this.jCheckBoxAllowModifyContents.setSelected((documentPermissions & 8) > 0);
        this.jCheckBoxAllowPrinting.setSelected((documentPermissions & 0x804) == 2052);
        this.jCheckBoxAllowScreenReaders.setSelected((documentPermissions & 0x200) > 0);
    }

    public void store() {
        Preferences pref = IReportManager.getPreferences();
        Tag t = (Tag)this.jComboBoxPDFVersion.getSelectedItem();
        if (t.getValue() == null) {
            pref.remove("net.sf.jasperreports.export.pdf.version");
        } else {
            pref.put("net.sf.jasperreports.export.pdf.version", "" + t.getValue());
        }
        pref.putBoolean("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", this.jCheckBoxCreatingBatchModeBookmarks.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.pdf.compressed", this.jCheckBoxCompressed.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.pdf.force.linebreak.policy", this.jCheckBoxForceLinebreakPolicy.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.pdf.force.svg.shapes", this.jCheckBoxForceSVGShapes.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.pdf.tagged", this.jCheckBoxIsTagged.isSelected());
        int index = this.jComboBoxEncryption.getSelectedIndex();
        pref.putBoolean("net.sf.jasperreports.export.pdf.encrypted", index != 0);
        pref.putBoolean("net.sf.jasperreports.export.pdf.128.bit.key", index == 2);
        pref.put("export.pdf.METADATA_AUTHOR", this.jTextFieldMetadataAuthor.getText());
        pref.put("export.pdf.METADATA_CREATOR", this.jTextFieldMetadataCreator.getText());
        pref.put("export.pdf.METADATA_KEYWORDS", this.jTextFieldMetadataKeywords.getText());
        pref.put("export.pdf.METADATA_SUBJECT", this.jTextFieldMetadataSubject.getText());
        pref.put("export.pdf.METADATA_TITLE", this.jTextFieldMetadataTitle.getText());
        pref.put("export.pdf.OWNER_PASSWORD", this.jTextFieldOwnerPassword.getText());
        pref.put("export.pdf.USER_PASSWORD", this.jTextFieldUserPassword.getText());
        pref.put("export.pdf.TAG_LANGUAGE", this.jTextFieldTagLanguage.getText());
        pref.put("export.pdf.PDF_JAVASCRIPT", this.jTextAreaPDFJavascript.getText());
        int documentPermissions = 0;
        if (this.jCheckBoxAllawDegradedPrinting.isSelected()) {
            documentPermissions |= 4;
        }
        if (this.jCheckBoxAllowAssembly.isSelected()) {
            documentPermissions |= 0x400;
        }
        if (this.jCheckBoxAllowCopy.isSelected()) {
            documentPermissions |= 0x10;
        }
        if (this.jCheckBoxAllowFillIn.isSelected()) {
            documentPermissions |= 0x100;
        }
        if (this.jCheckBoxAllowModifyAnnotations.isSelected()) {
            documentPermissions |= 0x20;
        }
        if (this.jCheckBoxAllowModifyContents.isSelected()) {
            documentPermissions |= 8;
        }
        if (this.jCheckBoxAllowPrinting.isSelected()) {
            documentPermissions |= 0x804;
        }
        if (this.jCheckBoxAllowScreenReaders.isSelected()) {
            documentPermissions |= 0x200;
        }
        pref.putInt("export.pdf.PERMISSIONS", documentPermissions);
    }

    public boolean valid() {
        return true;
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabelPDFVersion = new JLabel();
        this.jComboBoxPDFVersion = new JComboBox();
        this.jCheckBoxCreatingBatchModeBookmarks = new JCheckBox();
        this.jCheckBoxCompressed = new JCheckBox();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabelEncryption = new JLabel();
        this.jLabelOwnerPassword = new JLabel();
        this.jTextFieldOwnerPassword = new JTextField();
        this.jLabelUserPassword = new JLabel();
        this.jComboBoxEncryption = new JComboBox();
        this.jTextFieldUserPassword = new JTextField();
        this.jPanel2 = new JPanel();
        this.jCheckBoxAllowPrinting = new JCheckBox();
        this.jCheckBoxAllowModifyContents = new JCheckBox();
        this.jCheckBoxAllowCopy = new JCheckBox();
        this.jCheckBoxAllowModifyAnnotations = new JCheckBox();
        this.jCheckBoxAllowFillIn = new JCheckBox();
        this.jCheckBoxAllowScreenReaders = new JCheckBox();
        this.jCheckBoxAllowAssembly = new JCheckBox();
        this.jCheckBoxAllawDegradedPrinting = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabelMetadataTitle = new JLabel();
        this.jTextFieldMetadataTitle = new JTextField();
        this.jLabelMetadataAuthor = new JLabel();
        this.jTextFieldMetadataAuthor = new JTextField();
        this.jLabelMetadataSubject = new JLabel();
        this.jTextFieldMetadataSubject = new JTextField();
        this.jLabelMetadataKeywords = new JLabel();
        this.jTextFieldMetadataKeywords = new JTextField();
        this.jLabelMetadataCreator = new JLabel();
        this.jTextFieldMetadataCreator = new JTextField();
        this.jPanel4 = new JPanel();
        this.jCheckBoxForceLinebreakPolicy = new JCheckBox();
        this.jCheckBoxForceSVGShapes = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaPDFJavascript = new JTextArea();
        this.jLabelPDFJavascript = new JLabel();
        this.jCheckBoxIsTagged = new JCheckBox();
        this.jLabelTagLanguage = new JLabel();
        this.jTextFieldTagLanguage = new JTextField();
        this.jLabelTitle.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitle.setText("PDF Export parameters");
        this.jLabelPDFVersion.setText("PDF Version");
        this.jComboBoxPDFVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jComboBoxPDFVersionActionPerformed(evt);
            }
        });
        this.jCheckBoxCreatingBatchModeBookmarks.setText("Creating batch mode bookmarks");
        this.jCheckBoxCreatingBatchModeBookmarks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxCreatingBatchModeBookmarksActionPerformed(evt);
            }
        });
        this.jCheckBoxCompressed.setText("Compressed");
        this.jCheckBoxCompressed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxCompressedActionPerformed(evt);
            }
        });
        this.jLabelEncryption.setText("Encryption");
        this.jLabelOwnerPassword.setText("Owner password");
        this.jLabelUserPassword.setText("User password");
        this.jComboBoxEncryption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jComboBoxEncryptionActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Document permissions"));
        this.jCheckBoxAllowPrinting.setText("Allow printing");
        this.jCheckBoxAllowPrinting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxAllowPrintingActionPerformed(evt);
            }
        });
        this.jCheckBoxAllowModifyContents.setText("Allow Modify Contents");
        this.jCheckBoxAllowModifyContents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxAllowModifyContentsActionPerformed(evt);
            }
        });
        this.jCheckBoxAllowCopy.setText("Allow Copy");
        this.jCheckBoxAllowCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxAllowCopyActionPerformed(evt);
            }
        });
        this.jCheckBoxAllowModifyAnnotations.setText("Allow Modify Annotations");
        this.jCheckBoxAllowModifyAnnotations.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxAllowModifyAnnotationsActionPerformed(evt);
            }
        });
        this.jCheckBoxAllowFillIn.setText("Allow Fill In");
        this.jCheckBoxAllowFillIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxAllowFillInActionPerformed(evt);
            }
        });
        this.jCheckBoxAllowScreenReaders.setText("Allow Screen Readers");
        this.jCheckBoxAllowScreenReaders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxAllowScreenReadersActionPerformed(evt);
            }
        });
        this.jCheckBoxAllowAssembly.setText("Allow Assembly");
        this.jCheckBoxAllowAssembly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxAllowAssemblyActionPerformed(evt);
            }
        });
        this.jCheckBoxAllawDegradedPrinting.setText("Allow Degraded Printing");
        this.jCheckBoxAllawDegradedPrinting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxAllawDegradedPrintingActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jCheckBoxAllowModifyAnnotations).add((Component)this.jCheckBoxAllowPrinting).add((Component)this.jCheckBoxAllowAssembly)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jCheckBoxAllowModifyContents).add((Component)this.jCheckBoxAllowFillIn)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jCheckBoxAllowScreenReaders).add((Component)this.jCheckBoxAllowCopy))).add((Component)this.jCheckBoxAllawDegradedPrinting))));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jCheckBoxAllowPrinting).add((Component)this.jCheckBoxAllowCopy).add((Component)this.jCheckBoxAllowModifyContents)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jCheckBoxAllowModifyAnnotations).add((Component)this.jCheckBoxAllowFillIn).add((Component)this.jCheckBoxAllowScreenReaders)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jCheckBoxAllowAssembly).add((Component)this.jCheckBoxAllawDegradedPrinting))));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jPanel2, -2, -1, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabelEncryption).addPreferredGap(0).add((Component)this.jComboBoxEncryption, -2, -1, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabelOwnerPassword).add((Component)this.jLabelUserPassword)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldUserPassword, -2, 143, -2).add((Component)this.jTextFieldOwnerPassword, -2, 143, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabelEncryption).add((Component)this.jComboBoxEncryption, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabelUserPassword).add((Component)this.jTextFieldUserPassword, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabelOwnerPassword).add((Component)this.jTextFieldOwnerPassword, -2, -1, -2)).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).add(160, 160, 160)));
        this.jTabbedPane1.addTab("Security", this.jPanel1);
        this.jLabelMetadataTitle.setText("Title");
        this.jLabelMetadataAuthor.setText("Author");
        this.jLabelMetadataSubject.setText("Subject");
        this.jLabelMetadataKeywords.setText("Keywords");
        this.jLabelMetadataCreator.setText("Creator");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabelMetadataKeywords).add((Component)this.jLabelMetadataCreator).add((Component)this.jLabelMetadataTitle).add((Component)this.jLabelMetadataAuthor).add((Component)this.jLabelMetadataSubject)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jTextFieldMetadataAuthor, -1, 374, Short.MAX_VALUE).add((Component)this.jTextFieldMetadataTitle, -1, 374, Short.MAX_VALUE).add(2, (Component)this.jTextFieldMetadataSubject, -1, 374, Short.MAX_VALUE).add((Component)this.jTextFieldMetadataCreator, -1, 374, Short.MAX_VALUE).add((Component)this.jTextFieldMetadataKeywords, -1, 374, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabelMetadataTitle).add((Component)this.jTextFieldMetadataTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabelMetadataAuthor).add((Component)this.jTextFieldMetadataAuthor, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabelMetadataSubject).add((Component)this.jTextFieldMetadataSubject, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabelMetadataKeywords).add((Component)this.jTextFieldMetadataKeywords, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabelMetadataCreator).add((Component)this.jTextFieldMetadataCreator, -2, -1, -2)).addContainerGap(213, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Metadata", this.jPanel3);
        this.jCheckBoxForceLinebreakPolicy.setText("Force linebreak policy");
        this.jCheckBoxForceLinebreakPolicy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxForceLinebreakPolicyActionPerformed(evt);
            }
        });
        this.jCheckBoxForceSVGShapes.setText("Force SVG shapes");
        this.jCheckBoxForceSVGShapes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxForceSVGShapesActionPerformed(evt);
            }
        });
        this.jTextAreaPDFJavascript.setColumns(20);
        this.jTextAreaPDFJavascript.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaPDFJavascript);
        this.jLabelPDFJavascript.setText("PDF Javascript");
        this.jCheckBoxIsTagged.setText("Is tagged");
        this.jCheckBoxIsTagged.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PdfExportParametersPanel.this.jCheckBoxIsTaggedActionPerformed(evt);
            }
        });
        this.jLabelTagLanguage.setText("Tag language");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 425, Short.MAX_VALUE).add((Component)this.jCheckBoxForceLinebreakPolicy).add((Component)this.jCheckBoxForceSVGShapes).add((Component)this.jCheckBoxIsTagged).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabelTagLanguage).add(8, 8, 8).add((Component)this.jTextFieldTagLanguage, -2, 114, -2)).add((Component)this.jLabelPDFJavascript)).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxForceLinebreakPolicy).addPreferredGap(0).add((Component)this.jCheckBoxForceSVGShapes).addPreferredGap(0).add((Component)this.jCheckBoxIsTagged).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabelTagLanguage).add((Component)this.jTextFieldTagLanguage, -2, -1, -2)).addPreferredGap(1).add((Component)this.jLabelPDFJavascript).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 208, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Other options", this.jPanel4);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelPDFVersion).add(18, 18, 18).add((Component)this.jComboBoxPDFVersion, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBoxCreatingBatchModeBookmarks).add(18, 18, 18).add((Component)this.jCheckBoxCompressed))).addContainerGap(168, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1, -1, 440, Short.MAX_VALUE).addContainerGap()).add((Component)this.jTabbedPane1));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPDFVersion).add((Component)this.jComboBoxPDFVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBoxCreatingBatchModeBookmarks).add((Component)this.jCheckBoxCompressed)).add(5, 5, 5).add((Component)this.jTabbedPane1)));
    }

    private void jCheckBoxCreatingBatchModeBookmarksActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxForceLinebreakPolicyActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxForceSVGShapesActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxIsTaggedActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jComboBoxPDFVersionActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxCompressedActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jComboBoxEncryptionActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxAllowPrintingActionPerformed(ActionEvent evt) {
        this.notifyChange();
        if (this.jCheckBoxAllowPrinting.isSelected()) {
            this.jCheckBoxAllawDegradedPrinting.setSelected(true);
        }
    }

    private void jCheckBoxAllowModifyContentsActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxAllowCopyActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxAllowModifyAnnotationsActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxAllowFillInActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxAllowScreenReadersActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxAllowAssemblyActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxAllawDegradedPrintingActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void applyI18n() {
        this.jLabelTitle.setText(I18n.getString("PdfExportParametersPanel.jLabelTitle.text"));
        this.jLabelPDFVersion.setText(I18n.getString("PdfExportParametersPanel.jLabelPDFVersion.text"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(I18n.getString("PdfExportParametersPanel.jPanel2.border.title")));
        this.jCheckBoxCreatingBatchModeBookmarks.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxCreatingBatchModeBookmarks.text"));
        this.jCheckBoxCompressed.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxCompressed.text"));
        this.jCheckBoxAllowPrinting.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxAllowPrinting.text"));
        this.jCheckBoxAllowModifyContents.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxAllowModifyContents.text"));
        this.jCheckBoxAllowCopy.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxAllowCopy.text"));
        this.jCheckBoxAllowModifyAnnotations.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxAllowModifyAnnotations.text"));
        this.jCheckBoxAllowFillIn.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxAllowFillIn.text"));
        this.jCheckBoxAllowScreenReaders.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxAllowScreenReaders.text"));
        this.jCheckBoxAllowAssembly.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxAllowAssembly.text"));
        this.jCheckBoxAllawDegradedPrinting.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxAllawDegradedPrinting.text"));
        this.jLabelMetadataTitle.setText(I18n.getString("PdfExportParametersPanel.jLabelMetadataTitle.text"));
        this.jLabelMetadataAuthor.setText(I18n.getString("PdfExportParametersPanel.jLabelMetadataAuthor.text"));
        this.jLabelMetadataSubject.setText(I18n.getString("PdfExportParametersPanel.jLabelMetadataSubject.text"));
        this.jLabelMetadataKeywords.setText(I18n.getString("PdfExportParametersPanel.jLabelMetadataKeywords.text"));
        this.jLabelMetadataCreator.setText(I18n.getString("PdfExportParametersPanel.jLabelMetadataCreator.text"));
        this.jCheckBoxForceLinebreakPolicy.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxForceLinebreakPolicy.text"));
        this.jCheckBoxForceSVGShapes.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxForceSVGShapes.text"));
        this.jLabelPDFJavascript.setText(I18n.getString("PdfExportParametersPanel.jLabelPDFJavascript.text"));
        this.jCheckBoxIsTagged.setText(I18n.getString("PdfExportParametersPanel.jCheckBoxIsTagged.text"));
        this.jLabelTagLanguage.setText(I18n.getString("PdfExportParametersPanel.jLabelTagLanguage.text"));
        this.jLabelEncryption.setText(I18n.getString("PdfExportParametersPanel.jLabelEncryption.text"));
        this.jLabelOwnerPassword.setText(I18n.getString("PdfExportParametersPanel.jLabelOwnerPassword.text"));
        this.jLabelUserPassword.setText(I18n.getString("PdfExportParametersPanel.jLabelUserPassword.text"));
    }
}

