/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx.nodes.properties;

import com.jaspersoft.ireport.designer.sheet.editors.JRPenPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.chartthemes.simple.ColorProvider;
import net.sf.jasperreports.chartthemes.simple.PaintProvider;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.util.JRPenUtil;

public abstract class AbstractPenProperty
extends AbstractProperty
implements JRPenContainer {
    private JRPenPropertyEditor editor = null;

    public AbstractPenProperty(Object object) {
        super(JRPen.class, object);
        this.setValue("canEditAsText", Boolean.FALSE);
    }

    public Object getPropertyValue() {
        return this.getPen();
    }

    public Object getOwnPropertyValue() {
        return this.getOwnPen();
    }

    public Object getDefaultValue() {
        return this.getDefaultPen();
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new JRPenPropertyEditor();
        }
        return this.editor;
    }

    public void validate(Object value) {
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setPropertyValue(this.getDefaultPen());
    }

    public void setPropertyValue(Object value) {
        this.setPen((JRPen)value);
    }

    public JRPen getPen() {
        JRBasePen pen = new JRBasePen((JRPenContainer)this);
        if (this.getPaintProvider() != null && this.getStroke() != null) {
            BasicStroke basicStroke;
            ColorProvider colorProvider;
            ColorProvider colorProvider2 = colorProvider = this.getPaintProvider() instanceof ColorProvider ? (ColorProvider)this.getPaintProvider() : null;
            if (colorProvider != null) {
                pen.setLineColor(colorProvider.getColor());
            }
            BasicStroke basicStroke2 = basicStroke = this.getStroke() instanceof BasicStroke ? (BasicStroke)this.getStroke() : null;
            if (basicStroke != null) {
                this.setToPen(basicStroke, (JRPen)pen);
            }
        }
        return pen;
    }

    public JRPen getOwnPen() {
        return this.getPen();
    }

    public JRPen getDefaultPen() {
        return null;
    }

    public void setPen(JRPen pen) {
        if (pen == null) {
            this.setPaintProvider(null);
            this.setStroke(null);
        } else {
            this.setPaintProvider((PaintProvider)new ColorProvider(pen.getLineColor()));
            this.setStroke(JRPenUtil.getStroke((JRPen)pen, (int)2));
        }
    }

    public void setToPen(BasicStroke stroke, JRPen pen) {
        if (stroke != null && pen != null) {
            float lineWidth = stroke.getLineWidth();
            float[] dashArray = stroke.getDashArray();
            pen.setLineWidth(lineWidth);
            int lineCap = stroke.getEndCap();
            switch (lineCap) {
                case 2: {
                    if (dashArray != null && dashArray.length == 2 && dashArray[0] == 0.0f && dashArray[1] == 2.0f * lineWidth) {
                        pen.setLineStyle((byte)2);
                        break;
                    }
                    if (dashArray != null && dashArray.length == 2 && dashArray[0] == 4.0f * lineWidth && dashArray[1] == 4.0f * lineWidth) {
                        pen.setLineStyle((byte)1);
                        break;
                    }
                    pen.setLineStyle((byte)0);
                    break;
                }
                case 0: {
                    if (dashArray != null && dashArray.length == 2 && dashArray[0] == lineWidth && dashArray[1] == lineWidth) {
                        pen.setLineStyle((byte)2);
                        break;
                    }
                    if (dashArray != null && dashArray.length == 2 && dashArray[0] == 5.0f * lineWidth && dashArray[1] == 3.0f * lineWidth) {
                        pen.setLineStyle((byte)1);
                        break;
                    }
                    pen.setLineStyle((byte)0);
                }
            }
        }
    }

    public Float getDefaultLineWidth() {
        return new Float(0.0f);
    }

    public Color getDefaultLineColor() {
        return null;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return null;
    }

    public JRStyle getStyle() {
        return null;
    }

    public String getStyleNameReference() {
        return null;
    }

    public abstract PaintProvider getPaintProvider();

    public abstract void setPaintProvider(PaintProvider var1);

    public abstract Stroke getStroke();

    public abstract void setStroke(Stroke var1);
}

