/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.errorhandler;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.openide.nodes.Node;

public class NodeCellRenderer
extends DefaultTableCellRenderer {
    ImageIcon expressionIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/variables-16.png"));

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setIcon(null);
        if (value instanceof Node) {
            Node node = (Node)value;
            String text = node.getDisplayName();
            if (node instanceof ElementNode) {
                JRElementGroup parent;
                text = "";
                JRDesignElement element = ((ElementNode)node).getElement();
                if (element instanceof JRBreak) {
                    text = text + "Break";
                }
                if (element instanceof JRChart) {
                    text = text + "Chart";
                }
                if (element instanceof JRCrosstab) {
                    text = text + "Crosstab";
                }
                if (element instanceof JRElementGroup) {
                    text = text + "Element Group";
                }
                if (element instanceof JREllipse) {
                    text = text + "Ellipse";
                }
                if (element instanceof JRFrame) {
                    text = text + "Frame";
                }
                if (element instanceof JRImage) {
                    text = text + "Image";
                }
                if (element instanceof JRLine) {
                    text = text + "Line";
                }
                if (element instanceof JRRectangle) {
                    text = text + "Rectangle";
                }
                if (element instanceof JRStaticText) {
                    text = text + "Static Text";
                }
                if (element instanceof JRSubreport) {
                    text = text + "Subreport";
                }
                if (element instanceof JRTextField) {
                    text = text + "Text Field";
                }
                if ((parent = ModelUtils.getTopElementGroup(element)) != null && parent instanceof JRDesignBand) {
                    text = text + " in band " + ModelUtils.nameOf(((JRDesignBand)parent).getOrigin());
                } else if (parent != null && parent instanceof JRDesignCellContents) {
                    text = text + " in cell " + ModelUtils.nameOf(((JRDesignCellContents)parent).getOrigin());
                }
                text = text + " " + node.getDisplayName();
            }
            label.setText(text);
            label.setIcon(new ImageIcon(node.getIcon(1)));
        } else if (value instanceof JRDesignExpression) {
            JRDesignExpression exp = (JRDesignExpression)value;
            label.setText(exp.getText());
            label.setIcon(this.expressionIcon);
        }
        return label;
    }
}

