/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders;

import com.jaspersoft.ireport.designer.FieldsProviderEditor;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.connection.JRXMLADataSourceConnection;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.MDXFieldsProvider;
import com.jaspersoft.ireport.designer.data.fieldsproviders.XmlaFieldNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignField;
import rex.metadata.ExecuteResult;
import rex.metadata.ServerMetadata;
import rex.metadata.resultelements.Axis;
import rex.metadata.resultelements.HierarchyInfo;
import rex.metadata.resultelements.Tuple;
import rex.xmla.RexXMLAExecuteProperties;
import rex.xmla.XMLAExecuteProperties;

public class CincomMDXFieldsProvider
extends MDXFieldsProvider {
    private final String axis0 = "Axis0";
    private final String axis1 = "Axis1";
    private final String slicer = "SlicerAxis";
    private final char leftPar = (char)91;
    private final char rightPar = (char)93;
    public static ArrayList dimensionsList = new ArrayList();
    private boolean foundMeasure;

    public boolean supportsGetFieldsOperation() {
        return true;
    }

    public boolean supportsAutomaticQueryExecution() {
        return true;
    }

    public boolean hasEditorComponent() {
        return false;
    }

    public FieldsProviderEditor getEditorComponent(ReportQueryDialog reportQueryDialog) {
        return null;
    }

    public JRField[] getFields(IReportConnection con, JRDataset reportDataset, Map parameters) throws JRException, UnsupportedOperationException {
        if (con instanceof JRXMLADataSourceConnection) {
            try {
                String query = reportDataset.getQuery().getText();
                ArrayList v_fields = this.getFields(query, (JRXMLADataSourceConnection)con);
                JRField[] final_fields = new JRField[v_fields.size()];
                for (int i = 0; i < v_fields.size(); ++i) {
                    XmlaFieldNode f = (XmlaFieldNode)((Object)v_fields.get(i));
                    JRDesignField field = new JRDesignField();
                    field.setName(f.getName());
                    field.setValueClassName(f.getValueClassName());
                    field.setDescription(f.getDescription());
                    final_fields[i] = field;
                }
                return final_fields;
            }
            catch (Exception ex) {
                throw new JRException((Throwable)ex);
            }
        }
        throw new JRException("The active connection is not of type XMLA. Activate an XMLA connection first.");
    }

    public ArrayList getFields(String query, JRXMLADataSourceConnection con) throws Exception {
        this.foundMeasure = false;
        ArrayList<XmlaFieldNode> fields = new ArrayList<XmlaFieldNode>();
        ServerMetadata smd = new ServerMetadata(con.getUrl(), null);
        if (!smd.isValidUrl()) {
            return null;
        }
        RexXMLAExecuteProperties rexProperties = new RexXMLAExecuteProperties();
        rexProperties.setDataSourceInfo(con.getDatasource());
        rexProperties.setCatalog(con.getCatalog());
        dimensionsList.clear();
        ExecuteResult eResult = new ExecuteResult(smd.execute(query, (XMLAExecuteProperties)rexProperties), null);
        if (!this.addMDXAxisColumns(fields, eResult, "Axis0")) {
            return null;
        }
        if (!this.addMDXAxisColumns(fields, eResult, "Axis1")) {
            return null;
        }
        if (!this.addMDXAxisColumns(fields, eResult, "SlicerAxis")) {
            return null;
        }
        if (!this.foundMeasure) {
            XmlaFieldNode fld2 = new XmlaFieldNode("DefaultMeasure", 2);
            fld2.setDescription("DefaultMeasure");
            fields.add(fld2);
        }
        eResult = null;
        rexProperties = null;
        smd = null;
        return fields;
    }

    private boolean addMDXAxisColumns(ArrayList fields, ExecuteResult eResult, String axisName) {
        HashSet<String> fSet = new HashSet<String>();
        int axisNo = -1;
        if (eResult == null || fields == null || axisName == null) {
            return false;
        }
        if (axisName.compareTo("Axis0") != 0 && axisName.compareTo("Axis1") != 0 && axisName.compareTo("SlicerAxis") != 0) {
            return false;
        }
        Axis axis = eResult.getAxis(axisName);
        if (axis == null) {
            return false;
        }
        axisNo = axisName.compareTo("Axis0") == 0 ? 0 : 1;
        Tuple tuple = null;
        String longName = "";
        String shortName = "";
        int hierarchyCount = axis.getHierarchyInfoCount();
        for (int hierIndex = 0; hierIndex < hierarchyCount; ++hierIndex) {
            HierarchyInfo hierInfo = axis.getHierarchyInfoAt(hierIndex);
            if (hierInfo == null) {
                return false;
            }
            int tupleCount = axis.getTupleCount();
            for (int tupleIndex = 0; tupleIndex < tupleCount; ++tupleIndex) {
                tuple = axis.getTupleAt(tupleIndex);
                int tupleMemberCount = tuple.getMemberCount();
                for (int tupleMemberIndex = 0; tupleMemberIndex < tupleMemberCount; ++tupleMemberIndex) {
                    XmlaFieldNode fld;
                    if (tuple.getMemberAt(tupleMemberIndex).isMeasure()) {
                        this.foundMeasure = true;
                        longName = tuple.getMemberAt(tupleMemberIndex).getUniqueName();
                        shortName = longName.substring(longName.lastIndexOf(91) + 1, longName.lastIndexOf(93));
                        if (fSet.contains(shortName)) continue;
                        fld = new XmlaFieldNode(shortName, axisNo);
                        fld.setDescription(longName);
                        fSet.add(shortName);
                        fields.add(fld);
                        continue;
                    }
                    longName = tuple.getMemberAt(tupleMemberIndex).getLname();
                    shortName = longName.substring(longName.lastIndexOf(91) + 1, longName.lastIndexOf(93));
                    if (fSet.contains(shortName)) continue;
                    fld = new XmlaFieldNode(shortName, axisNo);
                    fld.setDescription(longName);
                    fSet.add(shortName);
                    fields.add(fld);
                    if (dimensionsList.contains((Object)fld)) continue;
                    dimensionsList.add(fld);
                }
            }
        }
        return true;
    }

    public static ArrayList getDimensions() {
        return dimensionsList;
    }
}

