/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPopupMenu;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ReportElementPopupMenuProvider
implements PopupMenuProvider {
    public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
        Action[] actions;
        JRDesignElement element = this.getElement(widget);
        if (element == null) {
            return null;
        }
        if (!((AbstractReportObjectScene)widget.getScene()).getSelectedObjects().contains(element)) {
            return null;
        }
        Node node = null;
        try {
            node = IReportManager.getInstance().findNodeOf(element, IReportManager.getInstance().getActiveVisualView().getExplorerManager().getRootContext());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (node != null && (actions = node.getActions(true)) != null && actions.length > 0) {
            ActionMap actionsMap = new ActionMap();
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i] == null || actions[i].getValue("ActionCommandKey") == null) continue;
                actionsMap.put(actions[i].getValue("ActionCommandKey"), actions[i]);
            }
            ArrayList<Lookup> allLookups = new ArrayList<Lookup>();
            allLookups.add(node.getLookup());
            allLookups.add(Utilities.actionsGlobalContext());
            allLookups.add(Lookups.singleton((Object)actionsMap));
            ProxyLookup lookup = new ProxyLookup(allLookups.toArray(new Lookup[allLookups.size()]));
            return Utilities.actionsToPopup((Action[])actions, (Lookup)lookup);
        }
        return null;
    }

    private JRDesignElement getElement(Widget widget) {
        if (widget == null) {
            return null;
        }
        if (widget instanceof JRDesignElementWidget) {
            JRDesignElement element = ((JRDesignElementWidget)widget).getElement();
            return element;
        }
        if (widget instanceof SelectionWidget) {
            return this.getElement(((SelectionWidget)widget).getRealWidget());
        }
        return null;
    }
}

