/*
 * Decompiled with CFR 0.152.
 */
package mondrian.recorder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.recorder.AbstractRecorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRecorder
extends AbstractRecorder {
    private final List<Entry> errorList = new ArrayList<Entry>();
    private final List<Entry> warnList = new ArrayList<Entry>();
    private final List<Entry> infoList = new ArrayList<Entry>();

    @Override
    public void clear() {
        super.clear();
        this.errorList.clear();
        this.warnList.clear();
        this.infoList.clear();
    }

    public Iterator<Entry> getErrorEntries() {
        return this.errorList.iterator();
    }

    public Iterator<Entry> getWarnEntries() {
        return this.warnList.iterator();
    }

    public Iterator<Entry> getInfoEntries() {
        return this.infoList.iterator();
    }

    @Override
    protected void recordMessage(String msg, Object info, AbstractRecorder.MsgType msgType) {
        String context = this.getContext();
        Entry e = new Entry(context, msg, msgType, info);
        switch (msgType) {
            case INFO: {
                this.infoList.add(e);
                break;
            }
            case WARN: {
                this.warnList.add(e);
                break;
            }
            case ERROR: {
                this.errorList.add(e);
                break;
            }
            default: {
                e = new Entry(context, "Unknown message type enum \"" + (Object)((Object)msgType) + "\" for message: " + msg, AbstractRecorder.MsgType.WARN, info);
                this.warnList.add(e);
            }
        }
    }

    public void logInfoMessage(Logger logger) {
        if (this.hasInformation()) {
            ListRecorder.logMessage(this.getInfoEntries(), logger);
        }
    }

    public void logWarningMessage(Logger logger) {
        if (this.hasWarnings()) {
            ListRecorder.logMessage(this.getWarnEntries(), logger);
        }
    }

    public void logErrorMessage(Logger logger) {
        if (this.hasErrors()) {
            ListRecorder.logMessage(this.getErrorEntries(), logger);
        }
    }

    static void logMessage(Iterator<Entry> it, Logger logger) {
        while (it.hasNext()) {
            Entry e = it.next();
            ListRecorder.logMessage(e, logger);
        }
    }

    static void logMessage(Entry e, Logger logger) {
        ListRecorder.logMessage(e.getContext(), e.getMessage(), e.getMsgType(), logger);
    }

    public static class Entry {
        private final String context;
        private final String msg;
        private final AbstractRecorder.MsgType msgType;
        private final Object info;

        private Entry(String context, String msg, AbstractRecorder.MsgType msgType, Object info) {
            this.context = context;
            this.msg = msg;
            this.msgType = msgType;
            this.info = info;
        }

        public String getContext() {
            return this.context;
        }

        public String getMessage() {
            return this.msg;
        }

        public AbstractRecorder.MsgType getMsgType() {
            return this.msgType;
        }

        public Object getInfo() {
            return this.info;
        }
    }
}

