/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class CountFunDef
extends AbstractAggregateFunDef {
    static final String[] ReservedWords = new String[]{"INCLUDEEMPTY", "EXCLUDEEMPTY"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Count", "Count(<Set>[, EXCLUDEEMPTY | INCLUDEEMPTY])", "Returns the number of tuples in a set, empty cells included unless the optional EXCLUDEEMPTY flag is used.", new String[]{"fnx", "fnxy"}, CountFunDef.class, ReservedWords);

    public CountFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final Calc calc = compiler.compile(call.getArg(0), ExpCompiler.ITERABLE_ANY_RESULT_STYLE_ARRAY);
        final boolean includeEmpty = call.getArgCount() < 2 || ((Literal)call.getArg(1)).getValue().equals("INCLUDEEMPTY");
        return new AbstractIntegerCalc(call, new Calc[]{calc}){

            public int evaluateInteger(Evaluator evaluator) {
                if (calc instanceof IterCalc) {
                    IterCalc iterCalc = (IterCalc)calc;
                    Iterable iterable = CountFunDef.this.evaluateCurrentIterable(iterCalc, evaluator);
                    return FunUtil.count(evaluator, iterable, includeEmpty);
                }
                ListCalc listCalc = (ListCalc)calc;
                List memberList = CountFunDef.this.evaluateCurrentList(listCalc, evaluator);
                return FunUtil.count(evaluator, memberList, includeEmpty);
            }

            public boolean dependsOn(Dimension dimension) {
                if (super.dependsOn(dimension)) {
                    return true;
                }
                if (includeEmpty) {
                    return false;
                }
                return !calc.getType().usesDimension(dimension, true);
            }
        };
    }
}

