/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegistryImpl
implements TopComponent.Registry {
    private TopComponent activatedTopComponent;
    private WeakReference<TopComponent> previousActivated;
    private final Set<TopComponent> openSet = new WeakSet(30);
    private Node[] currentNodes;
    private Node[] activatedNodes;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final boolean DEBUG = Debug.isLoggable(RegistryImpl.class);

    public synchronized Set<TopComponent> getOpened() {
        return Collections.unmodifiableSet(this.openSet);
    }

    public TopComponent getActivated() {
        return this.activatedTopComponent;
    }

    public Node[] getCurrentNodes() {
        return this.currentNodes;
    }

    public Node[] getActivatedNodes() {
        return this.activatedNodes == null ? new Node[]{} : this.activatedNodes;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    void topComponentActivated(TopComponent topComponent) {
        if (this.activatedTopComponent == topComponent && this.activatedNodes != null) {
            return;
        }
        final TopComponent topComponent2 = this.activatedTopComponent;
        if (topComponent2 != null && topComponent2.getActivatedNodes() != null) {
            this.previousActivated = new WeakReference<TopComponent>(topComponent2);
        }
        this.activatedTopComponent = topComponent;
        Window window = topComponent == null ? null : SwingUtilities.windowForComponent((Component)topComponent);
        RegistryImpl.cancelMenu(window);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryImpl.this.doFirePropertyChange("activated", topComponent2, RegistryImpl.this.activatedTopComponent);
            }
        });
        this.selectedNodesChanged(this.activatedTopComponent, this.activatedTopComponent == null ? null : this.activatedTopComponent.getActivatedNodes());
    }

    synchronized void topComponentOpened(TopComponent topComponent) {
        if (this.openSet.contains(topComponent)) {
            return;
        }
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>(this.openSet);
        this.openSet.add(topComponent);
        this.doFirePropertyChange("tcOpened", null, topComponent);
        this.doFirePropertyChange("opened", hashSet, new HashSet<TopComponent>(this.openSet));
    }

    synchronized void topComponentClosed(TopComponent topComponent) {
        Object[] objectArray;
        if (!this.openSet.contains(topComponent)) {
            return;
        }
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>(this.openSet);
        this.openSet.remove(topComponent);
        this.doFirePropertyChange("tcClosed", null, topComponent);
        this.doFirePropertyChange("opened", hashSet, new HashSet<TopComponent>(this.openSet));
        if (this.activatedNodes != null && (objectArray = topComponent.getActivatedNodes()) != null && Arrays.equals(objectArray, this.activatedNodes)) {
            this.activatedNodes = null;
            this.doFirePropertyChange("activatedNodes", objectArray, null);
        }
    }

    public void selectedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        Object[] objectArray = this.currentNodes;
        if (topComponent != this.activatedTopComponent && this.activatedNodes != null && !this.isProperPrevious(topComponent, nodeArray)) {
            return;
        }
        if (Arrays.equals(objectArray, nodeArray) && this.activatedNodes != null) {
            return;
        }
        this.currentNodes = nodeArray == null ? null : (Node[])nodeArray.clone();
        this.tryFireChanges((Node[])objectArray, this.currentNodes);
    }

    private boolean isProperPrevious(TopComponent topComponent, Node[] nodeArray) {
        if (this.previousActivated == null || nodeArray == null) {
            return false;
        }
        TopComponent topComponent2 = (TopComponent)this.previousActivated.get();
        if (topComponent2 == null || !topComponent2.equals(topComponent)) {
            return false;
        }
        return this.activatedTopComponent != null && this.activatedTopComponent.getActivatedNodes() == null;
    }

    public static void cancelMenu(Window window) {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i = 0; i < menuElementArray.length; ++i) {
            Window window2 = SwingUtilities.windowForComponent(menuElementArray[i].getComponent());
            if (window2 == null || window2 != window && window2.getOwner() != window) continue;
            return;
        }
        menuSelectionManager.clearSelectedPath();
    }

    private void tryFireChanges(Node[] nodeArray, Node[] nodeArray2) {
        this.doFirePropertyChange("currentNodes", nodeArray, nodeArray2);
        if (nodeArray2 == null && this.activatedNodes == null) {
            nodeArray2 = new Node[]{};
        }
        if (nodeArray2 != null) {
            nodeArray = this.activatedNodes;
            this.activatedNodes = nodeArray2;
            this.support.firePropertyChange("activatedNodes", nodeArray, this.activatedNodes);
        }
    }

    private void doFirePropertyChange(final String string, final Object list, final Object list2) {
        if (DEBUG) {
            RegistryImpl.debugLog("");
            RegistryImpl.debugLog("Scheduling event firing: propName=" + string);
            RegistryImpl.debugLog("\toldValue=" + (list instanceof Object[] ? Arrays.asList((Object[])list) : list));
            RegistryImpl.debugLog("\tnewValue=" + (list2 instanceof Object[] ? Arrays.asList((Object[])list2) : list2));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.support.firePropertyChange(string, list, list2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RegistryImpl.this.support.firePropertyChange(string, list, list2);
                }
            });
        }
    }

    void clear() {
        this.activatedTopComponent = null;
        this.openSet.clear();
        this.currentNodes = null;
        this.activatedNodes = null;
    }

    private static void debugLog(String string) {
        Debug.log(RegistryImpl.class, string);
    }
}

