/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.menu;

import com.jaspersoft.ireport.designer.standalone.IReportStandaloneManager;
import com.jaspersoft.ireport.designer.standalone.wizards.CustomTemplateWizard;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public final class NewReportAction
extends CallableSystemAction {
    static final String TEMPLATES_DIR = "Templates/Report/";
    private JMenu menu = null;

    public void performAction(String targetName, String templateName) {
        CustomTemplateWizard wizardDescriptor = new CustomTemplateWizard();
        File targetFolder = Misc.findStartingDirectory();
        DataFolder df = DataFolder.findFolder((FileObject)FileUtil.toFileObject((File)targetFolder));
        wizardDescriptor.setTargetFolder(df);
        wizardDescriptor.setTargetName(targetName);
        try {
            FileObject templateFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(templateName);
            wizardDescriptor.setTemplate(DataObject.find((FileObject)templateFileObject));
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        wizardDescriptor.setTitle("New");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
    }

    public String getName() {
        return I18n.getString(IReportStandaloneManager.class, (String)"CTL_NewReportAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getMenuPresenter() {
        if (this.menu == null) {
            this.menu = new JMenu(I18n.getString(IReportStandaloneManager.class, (String)"CTL_NewReportAction"));
            FileObject nodesFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(TEMPLATES_DIR);
            if (nodesFileObject == null) {
                return null;
            }
            DataFolder nodesDataFolder = DataFolder.findFolder((FileObject)nodesFileObject);
            if (nodesDataFolder == null) {
                return null;
            }
            Enumeration enObj = nodesDataFolder.children();
            while (enObj.hasMoreElements()) {
                DataObject dataObject = (DataObject)enObj.nextElement();
                FileObject fileObject = dataObject.getPrimaryFile();
                final String name = fileObject.getNameExt();
                final String filePath = TEMPLATES_DIR + fileObject.getNameExt();
                JMenuItem subMenu = new JMenuItem(I18n.getString((String)filePath));
                subMenu.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
                subMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        NewReportAction.this.performAction(name, filePath);
                    }
                });
                this.menu.add(subMenu);
            }
        }
        return this.menu;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
    }
}

