/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.ControlPtg;
import org.apache.poi.util.LittleEndian;

public final class TblPtg
extends ControlPtg {
    private static final int SIZE = 5;
    public static final short sid = 2;
    private final int field_1_first_row;
    private final int field_2_first_col;

    public TblPtg(RecordInputStream in) {
        this.field_1_first_row = in.readUShort();
        this.field_2_first_col = in.readUShort();
    }

    public void writeBytes(byte[] array, int offset) {
        LittleEndian.putByte(array, offset + 0, 2);
        LittleEndian.putUShort(array, offset + 1, this.field_1_first_row);
        LittleEndian.putUShort(array, offset + 3, this.field_2_first_col);
    }

    public int getSize() {
        return 5;
    }

    public int getRow() {
        return this.field_1_first_row;
    }

    public int getColumn() {
        return this.field_2_first_col;
    }

    public String toFormulaString() {
        throw new RecordFormatException("Table and Arrays are not yet supported");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[Data Table - Parent cell is an interior cell in a data table]\n");
        buffer.append("top left row = ").append(this.getRow()).append("\n");
        buffer.append("top left col = ").append(this.getColumn()).append("\n");
        return buffer.toString();
    }
}

