/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.formula.AreaNPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RefNPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.util.HexDump;

public final class SharedFormulaRecord
extends SharedValueRecordBase {
    public static final short sid = 1212;
    private int field_5_reserved;
    private Ptg[] field_7_parsed_expr;

    public SharedFormulaRecord() {
        this.field_7_parsed_expr = Ptg.EMPTY_PTG_ARRAY;
    }

    public SharedFormulaRecord(RecordInputStream in) {
        super(in);
        this.field_5_reserved = in.readShort();
        short field_6_expression_len = in.readShort();
        this.field_7_parsed_expr = Ptg.readTokens(field_6_expression_len, in);
    }

    protected void serializeExtraData(int offset, byte[] data) {
        throw new UnsupportedOperationException("Cannot serialize a SharedFormulaRecord");
    }

    protected int getExtraDataSize() {
        throw new UnsupportedOperationException("Cannot get the size for a SharedFormulaRecord");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SHARED FORMULA (").append(HexDump.intToHex(1212)).append("]\n");
        buffer.append("    .range      = ").append(this.getRange().toString()).append("\n");
        buffer.append("    .reserved    = ").append(HexDump.shortToHex(this.field_5_reserved)).append("\n");
        for (int k = 0; k < this.field_7_parsed_expr.length; ++k) {
            buffer.append("Formula[").append(k).append("]");
            Ptg ptg = this.field_7_parsed_expr[k];
            buffer.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        buffer.append("[/SHARED FORMULA]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 1212;
    }

    protected static Ptg[] convertSharedFormulas(Ptg[] ptgs, int formulaRow, int formulaColumn) {
        Ptg[] newPtgStack = new Ptg[ptgs.length];
        for (int k = 0; k < ptgs.length; ++k) {
            Ptg ptg = ptgs[k];
            byte originalOperandClass = -1;
            if (!ptg.isBaseToken()) {
                originalOperandClass = ptg.getPtgClass();
            }
            if (ptg instanceof RefNPtg) {
                RefNPtg refNPtg = (RefNPtg)ptg;
                ptg = new RefPtg(SharedFormulaRecord.fixupRelativeRow(formulaRow, refNPtg.getRow(), refNPtg.isRowRelative()), SharedFormulaRecord.fixupRelativeColumn(formulaColumn, refNPtg.getColumn(), refNPtg.isColRelative()), refNPtg.isRowRelative(), refNPtg.isColRelative());
            } else if (ptg instanceof AreaNPtg) {
                AreaNPtg areaNPtg = (AreaNPtg)ptg;
                ptg = new AreaPtg(SharedFormulaRecord.fixupRelativeRow(formulaRow, areaNPtg.getFirstRow(), areaNPtg.isFirstRowRelative()), SharedFormulaRecord.fixupRelativeRow(formulaRow, areaNPtg.getLastRow(), areaNPtg.isLastRowRelative()), SharedFormulaRecord.fixupRelativeColumn(formulaColumn, areaNPtg.getFirstColumn(), areaNPtg.isFirstColRelative()), SharedFormulaRecord.fixupRelativeColumn(formulaColumn, areaNPtg.getLastColumn(), areaNPtg.isLastColRelative()), areaNPtg.isFirstRowRelative(), areaNPtg.isLastRowRelative(), areaNPtg.isFirstColRelative(), areaNPtg.isLastColRelative());
            }
            if (!ptg.isBaseToken()) {
                ptg.setClass(originalOperandClass);
            }
            newPtgStack[k] = ptg;
        }
        return newPtgStack;
    }

    public void convertSharedFormulaRecord(FormulaRecord formula) {
        short formulaColumn;
        int formulaRow = formula.getRow();
        if (!this.isInRange(formulaRow, formulaColumn = formula.getColumn())) {
            throw new RuntimeException("Shared Formula Conversion: Coding Error");
        }
        Ptg[] ptgs = SharedFormulaRecord.convertSharedFormulas(this.field_7_parsed_expr, formulaRow, formulaColumn);
        formula.setParsedExpression(ptgs);
        formula.setSharedFormula(false);
    }

    private static int fixupRelativeColumn(int currentcolumn, int column, boolean relative) {
        if (relative) {
            return column + currentcolumn & 0xFF;
        }
        return column;
    }

    private static int fixupRelativeRow(int currentrow, int row, boolean relative) {
        if (relative) {
            return row + currentrow & 0xFFFF;
        }
        return row;
    }

    public Object clone() {
        throw new UnsupportedOperationException("Cannot clone a SharedFormulaRecord");
    }
}

