/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.actions.ActionManager;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.JMenuPlus;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static final long serialVersionUID = 4906417339959070129L;
    private static G gl;

    private static synchronized G gl() {
        if (gl == null) {
            gl = new G();
        }
        return gl;
    }

    public String getName() {
        return ToolsAction.getActionName();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ToolsAction.class);
    }

    public JMenuItem getMenuPresenter() {
        return new Inline((Action)((Object)this));
    }

    public JMenuItem getPopupPresenter() {
        return new Popup((Action)((Object)this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    private static String getActionName() {
        return NbBundle.getMessage(ToolsAction.class, (String)"CTL_Tools");
    }

    /*
     * WARNING - void declaration
     */
    private static List<JMenuItem> generate(Action action, boolean bl) {
        ActionManager actionManager = ActionManager.getDefault();
        SystemAction[] systemActionArray = actionManager.getContextActions();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(systemActionArray.length);
        boolean bl2 = false;
        boolean bl3 = false;
        Lookup lookup = action instanceof Lookup.Provider ? ((Lookup.Provider)action).getLookup() : null;
        for (SystemAction systemAction : systemActionArray) {
            JMenuItem jMenuItem;
            void object;
            if (lookup != null && systemAction instanceof ContextAwareAction) {
                Action action2 = ((ContextAwareAction)systemAction).createContextAwareInstance(lookup);
            }
            if (object == null) {
                if (!bl3) continue;
                bl2 = true;
                continue;
            }
            boolean bl4 = object instanceof Presenter.Popup;
            boolean bl5 = object instanceof Presenter.Menu;
            if (!(bl && bl5 || !bl && bl4) && (bl5 || bl4) || !object.isEnabled()) continue;
            if (bl && bl5) {
                jMenuItem = ((Presenter.Menu)object).getMenuPresenter();
            } else if (!bl && bl4) {
                jMenuItem = ((Presenter.Popup)object).getPopupPresenter();
            } else {
                if (bl5 || bl4) continue;
                jMenuItem = new JMenuItem();
                Actions.connect((JMenuItem)jMenuItem, (Action)object, (!bl ? 1 : 0) != 0);
            }
            if (bl2) {
                arrayList.add(null);
                bl2 = false;
            }
            arrayList.add(jMenuItem);
            bl3 = true;
        }
        return arrayList;
    }

    @Deprecated
    public static void setModel(Model model) {
        throw new SecurityException();
    }

    private static final class DelegateAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup,
    Lookup.Provider {
        private ToolsAction delegate;
        private Lookup lookup;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(ToolsAction toolsAction, Lookup lookup) {
            this.delegate = toolsAction;
            this.lookup = lookup;
        }

        public String toString() {
            return super.toString() + "[delegate=" + (Object)((Object)this.delegate) + "]";
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void putValue(String string, Object object) {
        }

        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public JMenuItem getMenuPresenter() {
            return new Inline(this);
        }

        public JMenuItem getPopupPresenter() {
            return new Popup(this);
        }
    }

    private static class G
    implements PropertyChangeListener {
        public static final String PROP_STATE = "actionsState";
        private int timestamp = 1;
        private SystemAction[] actions = null;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);

        public G() {
            ActionManager actionManager = ActionManager.getDefault();
            actionManager.addPropertyChangeListener(this);
            this.actionsListChanged();
        }

        public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.addPropertyChangeListener(propertyChangeListener);
        }

        public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.removePropertyChangeListener(propertyChangeListener);
        }

        protected final void firePropertyChange(String string, Object object, Object object2) {
            this.supp.firePropertyChange(string, object, object2);
        }

        private void actionsListChanged() {
            ++this.timestamp;
            SystemAction[] systemActionArray = this.actions;
            if (systemActionArray != null) {
                for (int i = 0; i < systemActionArray.length; ++i) {
                    SystemAction systemAction = systemActionArray[i];
                    if (systemAction == null) continue;
                    systemAction.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            ActionManager actionManager = ActionManager.getDefault();
            systemActionArray = actionManager.getContextActions();
            for (int i = 0; i < systemActionArray.length; ++i) {
                SystemAction systemAction = systemActionArray[i];
                if (systemAction == null) continue;
                systemAction.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.actions = systemActionArray;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        private void actionStateChanged() {
            ++this.timestamp;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("contextActions")) {
                this.actionsListChanged();
            } else if (string.equals("enabled")) {
                this.actionStateChanged();
            }
        }

        private boolean isPopupEnabled(Action action) {
            boolean bl = false;
            SystemAction[] systemActionArray = this.actions;
            Lookup lookup = action instanceof Lookup.Provider ? ((Lookup.Provider)action).getLookup() : null;
            for (int i = 0; i < systemActionArray.length; ++i) {
                Object object = lookup != null && systemActionArray[i] instanceof ContextAwareAction ? ((ContextAwareAction)systemActionArray[i]).createContextAwareInstance(lookup) : systemActionArray[i];
                if (!(object instanceof Presenter.Popup) || !object.isEnabled()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private int getTimestamp() {
            return this.timestamp;
        }
    }

    private static final class Popup
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = 2269006599727576059L;
        private JMenu menu = new MyMenu();
        private Action toolsAction;

        public Popup(Action action) {
            this.toolsAction = action;
            HelpCtx.setHelpIDString((JComponent)this.menu, (String)ToolsAction.class.getName());
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            JComponent[] jComponentArray2;
            if (ToolsAction.gl().isPopupEnabled(this.toolsAction)) {
                JMenuItem[] jMenuItemArray = new JMenuItem[1];
                jComponentArray2 = jMenuItemArray;
                jMenuItemArray[0] = this.menu;
            } else {
                jComponentArray2 = new JMenuItem[]{};
            }
            return jComponentArray2;
        }

        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(new JComponent[0]);
        }

        private class MyMenu
        extends JMenuPlus
        implements PopupMenuListener {
            private JPopupMenu lastPopup;

            MyMenu() {
                super(ToolsAction.getActionName());
                this.lastPopup = null;
            }

            public JPopupMenu getPopupMenu() {
                JPopupMenu jPopupMenu = super.getPopupMenu();
                this.fillSubmenu(jPopupMenu);
                return jPopupMenu;
            }

            private void fillSubmenu(JPopupMenu jPopupMenu) {
                if (this.lastPopup == null) {
                    jPopupMenu.addPopupMenuListener(this);
                    this.lastPopup = jPopupMenu;
                    this.removeAll();
                    for (Component component : ToolsAction.generate(Popup.this.toolsAction, false)) {
                        if (component == null) {
                            this.addSeparator();
                            continue;
                        }
                        this.add(component);
                    }
                    if (this.getMenuComponentCount() == 0) {
                        Component component;
                        component = new JMenuItem(NbBundle.getMessage(ToolsAction.class, (String)"CTL_EmptySubMenu"));
                        ((JMenuItem)component).setEnabled(false);
                        this.add((JMenuItem)component);
                    }
                }
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.lastPopup.removePopupMenuListener(this);
                this.lastPopup = null;
            }
        }
    }

    private static final class Inline
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = 2269006599727576059L;
        private int timestamp = 0;
        private Action toolsAction;

        Inline(Action action) {
            this.toolsAction = action;
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            if (this.timestamp == ToolsAction.gl().getTimestamp()) {
                return jComponentArray;
            }
            List list = ToolsAction.generate(this.toolsAction, true);
            this.timestamp = ToolsAction.gl().getTimestamp();
            return list.toArray(new JMenuItem[list.size()]);
        }

        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(new JComponent[0]);
        }
    }

    @Deprecated
    public static interface Model {
        public SystemAction[] getActions();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

