/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.QueryEditorUILogger;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditor;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorMetaData;
import org.netbeans.modules.db.sql.visualeditor.parser.ParseException;
import org.netbeans.modules.db.sql.visualeditor.parser.TokenMgrError;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.CondNode;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.JoinNode;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.ParameterizedQueryDialog;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderGraphFrame;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderMetaData;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderPane;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnProvider;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder
extends TopComponent
implements ClipboardOwner,
KeyListener,
ColumnProvider {
    QueryBuilderPane _queryBuilderPane;
    QueryModel _queryModel;
    boolean _updateModel = true;
    boolean _graphicsEnabled = true;
    boolean _updateText = true;
    SQLIdentifiers.Quoter quoter;
    private String lastQuery;
    private boolean firstTimeGenerateText = true;
    private String _parseErrorMessage = null;
    private boolean DEBUG = false;
    private DatabaseConnection dbconn;
    private String statement;
    private QueryBuilderMetaData qbMetaData;
    private VisualSQLEditor vse;
    private SQLException lastException = null;
    private final transient DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    protected final transient CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    protected final transient CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);

    public static Component open(DatabaseConnection databaseConnection, String string, VisualSQLEditorMetaData visualSQLEditorMetaData, VisualSQLEditor visualSQLEditor) {
        QueryBuilder queryBuilder;
        Log.getLogger().entering("QueryBuilder", "open");
        QueryEditorUILogger.logEditorOpened();
        QueryBuilder.showBusyCursor(true);
        try {
            queryBuilder = new QueryBuilder(databaseConnection, string, visualSQLEditorMetaData, visualSQLEditor);
        }
        catch (SQLException sQLException) {
            queryBuilder = null;
        }
        final QueryBuilder queryBuilder2 = queryBuilder;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (queryBuilder2 != null) {
                    queryBuilder2.open();
                    queryBuilder2.requestActive();
                }
                QueryBuilder.showBusyCursor(false);
            }
        });
        queryBuilder2.getTextAreaFocusInvokeLater();
        return queryBuilder2;
    }

    private QueryBuilder(DatabaseConnection databaseConnection, String string, VisualSQLEditorMetaData visualSQLEditorMetaData, VisualSQLEditor visualSQLEditor) throws SQLException {
        Log.getLogger().entering("QueryBuilder", "constructor");
        this.dbconn = databaseConnection;
        this.statement = string;
        this.vse = visualSQLEditor;
        this.qbMetaData = visualSQLEditorMetaData == null ? new QueryBuilderMetaData(databaseConnection, this) : new QueryBuilderMetaData(visualSQLEditorMetaData, this);
        this.quoter = SQLIdentifiers.createQuoter((DatabaseMetaData)this.getConnection().getMetaData());
        String string2 = databaseConnection.getName();
        this.setName(string2);
        this.setDisplayName(string2);
        this.setLayout(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/db/sql/visualeditor/resources/query-editor-tab.png"));
        if (imageIcon != null) {
            this.setIcon(imageIcon.getImage());
        }
        this._queryBuilderPane = new QueryBuilderPane(this);
        this.add(this._queryBuilderPane);
        this.addKeyListener(this);
    }

    public boolean isSchemaName(String string) {
        return this.qbMetaData.isSchemaName(string);
    }

    public boolean isTableName(String string) {
        return this.qbMetaData.isTableName(string);
    }

    public boolean isColumnName(String string) {
        return this.qbMetaData.isColumnName(string);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    boolean isSelectionEmpty() {
        Node[] nodeArray = this.getActivatedNodes();
        return nodeArray == null || nodeArray.length == 0;
    }

    private boolean isActivated() {
        return this == TopComponent.getRegistry().getActivated();
    }

    public int getPersistenceType() {
        return 2;
    }

    public String preferredID() {
        return "QueryEditor";
    }

    public void activateActions() {
        if (this.isSelectionEmpty()) {
            this.disableDelete();
        } else {
            this.enableDelete();
        }
        this.disableCutCopy();
    }

    public void deactivateActions() {
        if (this.deleteActionPerformer != null) {
            // empty if block
        }
    }

    void enableDelete() {
        if (!this.isActivated()) {
            return;
        }
        this.deleteActionPerformer.setEnabled(true);
    }

    void disableDelete() {
        if (!this.isActivated()) {
            return;
        }
        this.deleteActionPerformer.setEnabled(false);
        DeleteAction deleteAction = (DeleteAction)SystemAction.get(DeleteAction.class);
        deleteAction.setEnabled(false);
    }

    void disableCutCopy() {
        if (this.DEBUG) {
            System.out.println(" disableCutCopy called. \n");
        }
        this.cutActionPerformer.setEnabled(false);
        this.copyActionPerformer.setEnabled(false);
    }

    private void deleteSelection() {
        KeyboardFocusManager keyboardFocusManager;
        Component component;
        if (this.DEBUG) {
            System.out.println(" deleteSelection called. \n");
        }
        if ((component = (keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusOwner()) != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof QueryBuilderGraphFrame)) continue;
                Node[] nodeArray = this.getActivatedNodes();
                if (nodeArray == null || nodeArray.length == 0) {
                    return;
                }
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (nodeArray[i] instanceof CondNode) {
                        this._queryBuilderPane.getQueryBuilderGraphFrame().removeNode((CondNode)nodeArray[i]);
                        continue;
                    }
                    if (nodeArray[i] instanceof JoinNode) {
                        this._queryBuilderPane.getQueryBuilderGraphFrame().removeNode((JoinNode)nodeArray[i]);
                        continue;
                    }
                    if (!(nodeArray[i] instanceof TableNode)) continue;
                    this._queryBuilderPane.getQueryBuilderGraphFrame().removeNode((TableNode)nodeArray[i]);
                }
            }
        }
    }

    private void installActions(ActionMap actionMap, InputMap inputMap) {
        actionMap.put("delete", this.deleteActionPerformer);
        actionMap.put("copy-to-clipboard", this.copyActionPerformer);
        actionMap.put("cut-to-clipboard", this.cutActionPerformer);
        inputMap.put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    void getGraphFrameCanvasFocus() {
        this._queryBuilderPane.getQueryBuilderGraphFrame().getCanvasFocus();
    }

    void getTextAreaFocusInvokeLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                QueryBuilder.this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus(true);
                QueryBuilder.this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocusInWindow();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.handleKeyPress(keyEvent);
    }

    public void handleKeyPress(KeyEvent keyEvent) {
        if (keyEvent.isAltDown()) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 49: {
                    if (this.DEBUG) {
                        System.out.println(" Alt + 1 pressed. ");
                    }
                    this.getGraphFrameCanvasFocus();
                    break;
                }
                case 50: {
                    if (this.DEBUG) {
                        System.out.println(" Alt + 2 pressed. ");
                    }
                    if (this._queryBuilderPane.getQueryBuilderInputTable().getRowCount() <= 0) break;
                    this._queryBuilderPane.getQueryBuilderInputTable().setRowSelectionInterval(0, 0);
                    this._queryBuilderPane.getQueryBuilderInputTable().requestFocus(true);
                    break;
                }
                case 51: {
                    if (this.DEBUG) {
                        System.out.println(" Alt + 3 pressed. ");
                    }
                    this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus(true);
                    break;
                }
                case 52: {
                    if (this.DEBUG) {
                        System.out.println(" Alt + 4 pressed. ");
                    }
                    this._queryBuilderPane.getQueryBuilderResultTable().requestFocus(true);
                }
            }
        }
    }

    String checkTableName(String string) throws SQLException {
        return this.qbMetaData.checkTableName(string);
    }

    String checkFullTableName(String string) throws SQLException {
        return this.qbMetaData.checkFullTableName(string);
    }

    String checkColumnName(String string, String string2) throws SQLException {
        return this.qbMetaData.checkColumnName(string, string2);
    }

    boolean checkColumnNameForTable(Column column, String string) {
        return this.qbMetaData.checkColumnNameForTable(column, string);
    }

    boolean checkTableColumnName(Column column) throws SQLException {
        return this.qbMetaData.checkTableColumnName(column);
    }

    boolean populate(String string, boolean bl) {
        Log.getLogger().entering("QueryBuilder", "populate", string);
        if (!bl && string.trim().equals(this._queryBuilderPane.getQueryBuilderSqlTextArea().getText().trim())) {
            Log.getLogger().finest("  skipping populate(), no change");
            return true;
        }
        if (string.trim().equals(this.lastQuery)) {
            Log.getLogger().finest("  skipping populate(), no change");
            return true;
        }
        this.lastQuery = new String(string.trim());
        try {
            this.parseQuery(string);
            if (!this.checkQuery()) {
                return false;
            }
            this._queryBuilderPane.getQueryBuilderGraphFrame().setQBGFEnabled(true);
            this._queryBuilderPane.setQueryBuilderInputTableEnabled(true);
            this._queryBuilderPane.getQueryBuilderGraphFrame().setTableColumnValidity(false);
            this._queryBuilderPane.getQueryBuilderGraphFrame().setGroupBy(this._queryModel.hasGroupBy());
            this._graphicsEnabled = true;
        }
        catch (ParseException parseException) {
            Log.getLogger().severe("Parse error: " + parseException.getLocalizedMessage());
            this.promptForContinuation(parseException.getMessage(), string);
            return false;
        }
        catch (TokenMgrError tokenMgrError) {
            Log.getLogger().severe("Parse error: " + tokenMgrError.getLocalizedMessage());
            this.promptForContinuation(tokenMgrError.getMessage(), string);
            return false;
        }
        catch (SQLException sQLException) {
            this.lastException = sQLException;
            Log.getLogger().severe("Parse error: " + sQLException.getLocalizedMessage());
            this.promptForContinuation(sQLException.getMessage(), string);
            return false;
        }
        this._parseErrorMessage = null;
        this.generate();
        this.saveSqlCommand();
        this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus();
        return true;
    }

    private boolean promptForContinuation(String string, String string2) {
        Object[] objectArray = new Object[]{NbBundle.getMessage(QueryBuilder.class, (String)"CONTINUE"), NbBundle.getMessage(QueryBuilder.class, (String)"CANCEL")};
        if (this._queryBuilderPane.getQueryBuilderSqlTextArea().queryChanged()) {
            int n = JOptionPane.showOptionDialog((Component)((Object)this), string + "\n\n" + NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR_MESSAGE") + NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR_MESSAGE_PROMPT"), NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR"), 0, 3, null, objectArray, objectArray[0]);
            if (n == 1) {
                Log.getLogger().info("Query execution canceled");
                this._queryBuilderPane.getQueryBuilderSqlTextArea().restoreLastGoodQuery();
                this._queryBuilderPane.getQueryBuilderGraphFrame().setQBGFEnabled(true);
                this._queryBuilderPane.setQueryBuilderInputTableEnabled(true);
                this._graphicsEnabled = true;
                this._parseErrorMessage = null;
            } else {
                this._parseErrorMessage = NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR_MESSAGE");
                this.disableVisualEditing(string2);
            }
        } else {
            this._parseErrorMessage = NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR_MESSAGE");
            this.disableVisualEditing(string2);
        }
        return false;
    }

    private void disableVisualEditing(String string) {
        this._graphicsEnabled = false;
        this._queryBuilderPane.clear();
        this._queryBuilderPane.getQueryBuilderGraphFrame().setQBGFEnabled(false);
        this._queryBuilderPane.setQueryBuilderInputTableEnabled(false);
        String string2 = this.getSqlCommand();
        if (string != null && string.trim().length() != 0) {
            this.setSqlText(string);
            this.setSqlCommand(string);
        } else {
            this.setSqlText(string2);
        }
    }

    private boolean checkQuery() throws SQLException {
        if (this.getSqlText() != null || this._queryBuilderPane.getQueryBuilderGraphFrame().checkTableColumnValidity()) {
            if (!this.checkFrom()) {
                return false;
            }
            this._queryModel.replaceStar(this);
            if (!this.checkSelect()) {
                return false;
            }
            if (!this.checkWhere()) {
                return false;
            }
            if (!this.checkGroupBy()) {
                return false;
            }
            if (!this.checkHaving()) {
                return false;
            }
            if (!this.checkOrderBy()) {
                return false;
            }
        } else {
            this._queryModel.replaceStar(this);
        }
        return true;
    }

    private boolean checkFrom() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkFrom called... \n ");
        }
        if (this._queryModel.getFrom() != null) {
            List list = this._queryModel.getFrom().getTableList();
            for (int i = 0; i < list.size(); ++i) {
                String string = ((JoinTable)list.get(i)).getFullTableName();
                String string2 = ((JoinTable)list.get(i)).getTableSpec();
                String string3 = this.checkFullTableName(string);
                if (this.DEBUG) {
                    System.out.println("checkFullTableName called, fromTableName: " + string + " returns: " + string3 + " \n ");
                }
                if (string3 == null) {
                    this.showTableColumnNameError(string);
                    return false;
                }
                if (!string3.equals(string)) {
                    if (this.DEBUG) {
                        System.out.println(" fromTableName = " + string + " fromTableSpec = " + string2 + " \n");
                    }
                    this._queryModel.getFrom().setTableSpec(string2, string3);
                }
                ArrayList arrayList = new ArrayList();
                ((JoinTable)list.get(i)).getReferencedColumns(arrayList);
                for (int j = 0; j < arrayList.size(); ++j) {
                    Column column = (Column)arrayList.get(j);
                    if (this.checkTableColumnName(column)) continue;
                    this.showTableColumnNameError(column.getColumnName());
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSelect() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkSelect called. _queryModel.getSelect() = " + this._queryModel.getSelect());
        }
        if (this._queryModel.getSelect() != null) {
            ArrayList arrayList = new ArrayList();
            this._queryModel.getSelect().getReferencedColumns(arrayList);
            if (!this.checkColumns(arrayList)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkWhere() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkWhere called... ");
        }
        if (this._queryModel.getWhere() != null) {
            ArrayList arrayList = new ArrayList();
            this._queryModel.getWhere().getReferencedColumns(arrayList);
            if (!this.checkColumns(arrayList)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkGroupBy() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkGroupBy called... ");
        }
        if (this._queryModel.getGroupBy() != null) {
            ArrayList arrayList = new ArrayList();
            this._queryModel.getGroupBy().getReferencedColumns(arrayList);
            if (!this.checkColumns(arrayList)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkHaving() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkHaving called... ");
        }
        if (this._queryModel.getHaving() != null) {
            ArrayList arrayList = new ArrayList();
            this._queryModel.getHaving().getReferencedColumns(arrayList);
            if (!this.checkColumns(arrayList)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkOrderBy() throws SQLException {
        OrderBy orderBy;
        if (this.DEBUG) {
            System.out.println("checkOrderBy called... ");
        }
        if ((orderBy = this._queryModel.getOrderBy()) != null) {
            ArrayList<Column> arrayList = new ArrayList<Column>();
            for (int i = 0; i < orderBy.getSortSpecificationCount(); ++i) {
                Column column = orderBy.getSortSpecification(i).getColumn();
                arrayList.add(column);
            }
            if (!this.checkColumns(arrayList)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkColumns(ArrayList arrayList) throws SQLException {
        Log.getLogger().entering("QueryBuilder", "checkColumns");
        for (int i = 0; i < arrayList.size(); ++i) {
            Column column = (Column)arrayList.get(i);
            String string = column.getTableSpec();
            String string2 = column.getFullTableName();
            if (string2 == null && this._queryModel.getFrom() != null) {
                List list = this._queryModel.getFrom().getTableList();
                boolean bl = false;
                for (int j = 0; j < list.size(); ++j) {
                    String string3 = ((JoinTable)list.get(j)).getFullTableName();
                    String string4 = ((JoinTable)list.get(j)).getTableSpec();
                    if (this.DEBUG) {
                        System.out.println(" checkColumns called  fromTableName = " + string3 + " fromTableSpec = " + string4);
                    }
                    if (!this.checkColumnNameForTable(column, string4)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.showTableColumnNameError(column.getColumnName());
                    return false;
                }
            }
            if (this.checkTableColumnName(column)) continue;
            this.showTableColumnNameError(column.getColumnName());
            return false;
        }
        return true;
    }

    private void showTableColumnNameError(String string) {
        String string2 = NbBundle.getMessage(QueryBuilder.class, (String)"TABLE_COLUMN_NAME_ERROR");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)(string + " : " + string2 + "\n\n"), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        this._parseErrorMessage = string + " : " + string2 + "\n\n";
        String string3 = this.getSqlText();
        this.disableVisualEditing(string3);
    }

    private void parseQuery(String string) throws ParseException {
        Log.getLogger().entering("QueryBuilder", "parseQuery", string);
        if (this._queryModel == null) {
            this._queryModel = new QueryModel(this.quoter);
        }
        this._queryModel.parse(string);
    }

    private void saveSqlCommand() {
        String string = this.getSqlText();
        if (!string.equals(this.getSqlCommand())) {
            Log.getLogger().finest("QB:  setting sql command to: " + string);
            this.setSqlCommand(string);
        }
    }

    void setSqlCommand(String string) {
        this.vse.setStatement(string);
    }

    String getSqlCommand() {
        return this.vse.getStatement();
    }

    String getConnectionInfo() {
        String string = "";
        try {
            string = this.getConnection().getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        return string;
    }

    Connection getConnection() {
        Connection connection = this.dbconn.getJDBCConnection();
        if (connection == null) {
            ConnectionManager.getDefault().showConnectionDialog(this.dbconn);
            connection = this.dbconn.getJDBCConnection();
            if (connection == null) {
                String string = NbBundle.getMessage(QueryBuilder.class, (String)"CANNOT_ESTABLISH_CONNECTION");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)(string + "\n\n"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        return connection;
    }

    void closeQB() {
    }

    List getColumnNames(String string) throws SQLException {
        return this.qbMetaData.getColumnNames(string);
    }

    @Override
    public void getColumnNames(String string, List list) {
        this.qbMetaData.getColumnNames(string, list);
    }

    List getImportedKeyColumns(String string) throws SQLException {
        return this.qbMetaData.getImportedKeyColumns(string);
    }

    List<String> getAllTables() throws SQLException {
        return this.qbMetaData.getAllTables();
    }

    List getPrimaryKeys(String string) throws SQLException {
        return this.qbMetaData.getPrimaryKeys(string);
    }

    List getForeignKeys(String string) throws SQLException {
        return this.qbMetaData.getForeignKeys(string);
    }

    String[] findForeignKey(String string, String string2, List list) {
        return this.qbMetaData.findForeignKey(string, string2, list);
    }

    String[] findForeignKey(String string, String string2, String string3, String string4) throws SQLException {
        return this.qbMetaData.findForeignKey(string, string2, string3, string4);
    }

    void executeQuery(String string) {
        String[] stringArray;
        int n;
        Log.getLogger().entering("QueryBuilder", "executeQuery", string);
        String string2 = this.getSqlText();
        ResultSet resultSet = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        QueryBuilder.showBusyCursor(true);
        boolean bl = true;
        ParameterMetaData parameterMetaData = null;
        int n2 = 0;
        try {
            connection = this.getConnection();
            if (connection == null) {
                bl = false;
            } else {
                preparedStatement = connection.prepareStatement(string2);
                parameterMetaData = preparedStatement.getParameterMetaData();
                n2 = parameterMetaData.getParameterCount();
                if (this.DEBUG) {
                    System.out.println(" Parameter Count  = " + n2);
                    for (n = 1; n <= n2; ++n) {
                        System.out.println(" Parameter Type  = " + parameterMetaData.getParameterType(n));
                        System.out.println(" Parameter Type Name = " + parameterMetaData.getParameterTypeName(n));
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            this.reportDatabaseError(sQLException);
            bl = false;
        }
        catch (AbstractMethodError abstractMethodError) {
            Log.getLogger().severe("Error occurred when trying to retrieve table information: " + abstractMethodError);
            stringArray = NbBundle.getMessage(QueryBuilder.class, (String)"PROCESSING_ERROR");
            JOptionPane.showMessageDialog((Component)((Object)this), abstractMethodError.toString() + "\n\n", (String)stringArray, 0);
            bl = false;
        }
        if (bl && this._queryModel != null) {
            if (this.getParseErrorMessage() == null && this._queryModel.isParameterized()) {
                ArrayList arrayList = new ArrayList();
                this._queryModel.getParameterizedPredicates(arrayList);
                stringArray = new String[arrayList.size()];
                String[] stringArray2 = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = new String((String)arrayList.get(i));
                }
                ParameterizedQueryDialog parameterizedQueryDialog = new ParameterizedQueryDialog(stringArray, true);
                if (parameterizedQueryDialog.getReturnStatus() == 1) {
                    stringArray2 = parameterizedQueryDialog.getParameterValues();
                    try {
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (this.DEBUG) {
                                System.out.println(" command  = " + string2);
                                System.out.println("PreparedStatement i = " + i + " values = " + stringArray2[i]);
                            }
                            preparedStatement.setObject(i + 1, (Object)stringArray2[i], parameterMetaData.getParameterType(i + 1));
                        }
                    }
                    catch (SQLException sQLException) {
                        this.reportDatabaseError(sQLException);
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            } else if (n2 != 0) {
                ParameterizedQueryDialog parameterizedQueryDialog;
                int n3;
                ArrayList arrayList = new ArrayList(n2);
                if (this.DEBUG) {
                    System.out.println(" param count = " + n2);
                    System.out.println(" list size  = " + arrayList.size());
                }
                stringArray = new String[n2];
                String[] stringArray3 = new String[n2];
                if (this.DEBUG) {
                    System.out.println(" parameters size  = " + stringArray.length);
                    System.out.println(" values size  = " + stringArray3.length);
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    stringArray[n3] = new String("Parameter " + new Integer(n3).toString());
                }
                if (this.DEBUG) {
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        System.out.println(" parameter  = " + stringArray[n3]);
                    }
                }
                if ((parameterizedQueryDialog = new ParameterizedQueryDialog(stringArray, true)).getReturnStatus() == 1) {
                    stringArray3 = parameterizedQueryDialog.getParameterValues();
                    try {
                        for (int i = 0; i < stringArray3.length; ++i) {
                            if (this.DEBUG) {
                                System.out.println(" command  = " + string2);
                                System.out.println("PreparedStatement i = " + i + " values = " + stringArray3[i]);
                            }
                            preparedStatement.setObject(i + 1, (Object)stringArray3[i], parameterMetaData.getParameterType(i + 1));
                        }
                    }
                    catch (SQLException sQLException) {
                        this.reportDatabaseError(sQLException);
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
        }
        if (bl) {
            try {
                n = preparedStatement.execute();
                if (n != 0) {
                    resultSet = preparedStatement.getResultSet();
                    this._queryBuilderPane.getQueryBuilderResultTable().displayResultSet(resultSet);
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                this.reportDatabaseError(sQLException);
            }
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            Log.getLogger().finest("Error Closing statement: " + sQLException.getLocalizedMessage());
        }
        QueryBuilder.showBusyCursor(false);
        Log.getLogger().finest("Returning from QueryBuilder.executeQuery");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generate() {
        Log.getLogger().entering("QueryBuilder", "generate");
        this._updateText = false;
        try {
            this._queryBuilderPane.clear();
            this.generateGraph();
        }
        finally {
            this._updateText = true;
        }
        this.generateText();
    }

    private void generateGraph() {
        if (this._graphicsEnabled) {
            this._queryBuilderPane.getQueryBuilderGraphFrame().generateGraph(this._queryModel);
        }
    }

    void generateText() {
        if (this._graphicsEnabled) {
            this.setSqlText(this._queryModel.genText());
            if (!this.firstTimeGenerateText) {
                this.saveSqlCommand();
            } else {
                this.firstTimeGenerateText = false;
            }
        }
    }

    QueryModel getQueryModel() {
        return this._queryModel;
    }

    QueryBuilderPane getQueryBuilderPane() {
        return this._queryBuilderPane;
    }

    public VisualSQLEditor getVisualSQLEditor() {
        return this.vse;
    }

    private String getSqlText() {
        return this._queryBuilderPane.getQueryBuilderSqlTextArea().getText();
    }

    private void setSqlText(String string) {
        this._queryBuilderPane.getQueryBuilderSqlTextArea().setText(string);
    }

    private boolean isParameterized() {
        return this._queryModel.isParameterized();
    }

    public QueryBuilderMetaData getMetaData() {
        return this.qbMetaData;
    }

    protected void componentShowing() {
        Log.getLogger().entering("QueryBuilder", "componentShowing");
        String string = this.getSqlCommand();
        if (this._queryModel == null) {
            this._queryModel = new QueryModel(this.quoter);
        }
        Log.getLogger().finest("  * command=" + string);
        if (string == null || string.trim().length() == 0) {
            Log.getLogger().finest("QBShowing command is null");
            this.setVisible(true);
            this.repaint();
            String string2 = NbBundle.getMessage(QueryBuilder.class, (String)"EMPTY_QUERY_ADD_TABLE");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)(string2 + "\n\n"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            this._queryBuilderPane.getQueryBuilderGraphFrame().addTable();
        } else {
            String string3 = this.getSqlText();
            if (string3 == null || !string.trim().equalsIgnoreCase(string3.trim())) {
                this.populate(string, false);
                this.setVisible(true);
                this.repaint();
            }
        }
        this.activateActions();
        this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus();
        if (this.DEBUG) {
            System.out.println(" _queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus () called. ");
        }
    }

    protected void componentHidden() {
        String string;
        Log.getLogger().entering("QueryBuilder", "componentHidden");
        String string2 = this.getSqlCommand();
        if (!(string2 == null || string2.trim().length() == 0 || (string = this.getSqlText()) != null && string2.trim().equalsIgnoreCase(string.trim()))) {
            if (this._graphicsEnabled) {
                boolean bl = this.populate(string, true);
                if (!bl) {
                    this.setSqlCommand(string);
                }
            } else {
                this.setSqlCommand(string);
            }
        }
        this.deactivateActions();
    }

    protected void componentOpened() {
        Log.getLogger().entering("QueryBuilder", "componentOpened");
        this.activateActions();
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(1);
        this.installActions(actionMap, inputMap);
    }

    protected void componentClosed() {
        Log.getLogger().entering("QueryBuilder", "componentClosed");
        this.deactivateActions();
        this.closeQB();
        this.lastQuery = null;
    }

    private void reportDatabaseError(SQLException sQLException) {
        Log.getLogger().finest("Error occurred when trying to retrieve table information: " + sQLException);
        String string = sQLException.getErrorCode() == 17023 || "S1C00".equals(sQLException.getSQLState()) ? NbBundle.getMessage(QueryBuilder.class, (String)"UNSUPPORTED_FEATURE") : sQLException.getLocalizedMessage();
        String string2 = NbBundle.getMessage(QueryBuilder.class, (String)"PROCESSING_ERROR");
        JOptionPane.showMessageDialog((Component)((Object)this), string + "\n\n", string2, 0);
    }

    String getParseErrorMessage() {
        return this._parseErrorMessage;
    }

    static void showBusyCursor(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            QueryBuilder.doShowBusyCursor(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QueryBuilder.doShowBusyCursor(bl);
                }
            });
        }
    }

    private static void doShowBusyCursor(boolean bl) {
        JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
        if (bl) {
            RepaintManager.currentManager(jFrame).paintDirtyRegions();
            jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            jFrame.getGlassPane().setVisible(true);
            jFrame.repaint();
        } else {
            jFrame.getGlassPane().setVisible(false);
            jFrame.getGlassPane().setCursor(null);
            jFrame.repaint();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_editors_about_query_editor");
    }

    class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        boolean isCopy;

        public CopyCutActionPerformer(boolean bl) {
            this.isCopy = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.performAction(null);
        }

        public void performAction(SystemAction systemAction) {
        }
    }

    class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        DeleteActionPerformer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.performAction(null);
        }

        public void performAction(SystemAction systemAction) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QueryBuilder.this.deleteSelection();
                }
            });
        }
    }
}

