/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openidex.search.SearchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchHistory {
    private SearchPattern lastSelected;
    private PropertyChangeSupport pcs;
    private static final int MAX_SEARCH_PATTERNS_ITEMS = 50;
    private List<SearchPattern> searchPatternsList = new ArrayList<SearchPattern>(50);
    private static SearchHistory INSTANCE = null;
    public static final String LAST_SELECTED = "last-selected";
    public static final String ADD_TO_HISTORY = "add-to-history";

    private SearchHistory() {
    }

    public static synchronized SearchHistory getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new SearchHistory();
        }
        return INSTANCE;
    }

    public SearchPattern getLastSelected() {
        return this.lastSelected;
    }

    public void setLastSelected(SearchPattern searchPattern) {
        SearchPattern searchPattern2 = this.lastSelected;
        this.lastSelected = searchPattern;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(LAST_SELECTED, searchPattern2, searchPattern);
        }
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized List<SearchPattern> getSearchPatterns() {
        return Collections.unmodifiableList(this.searchPatternsList);
    }

    public synchronized void add(SearchPattern searchPattern) {
        if (searchPattern == null || searchPattern.getSearchExpression() == null || searchPattern.getSearchExpression().length() == 0) {
            return;
        }
        if (this.searchPatternsList.size() > 0 && searchPattern.equals(this.searchPatternsList.get(0))) {
            return;
        }
        if (this.searchPatternsList.size() == 50) {
            this.searchPatternsList.remove(49);
        }
        this.searchPatternsList.add(0, searchPattern);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(ADD_TO_HISTORY, null, searchPattern);
        }
    }
}

