/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openide.loaders.DataObject;
import org.openidex.search.SearchInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompoundSearchIterator
implements Iterator<DataObject> {
    private final SearchInfo[] elements;
    private int elementIndex;
    private Iterator<DataObject> elementIterator;
    private DataObject nextObject;
    private boolean upToDate;

    CompoundSearchIterator(SearchInfo[] searchInfoArray) {
        if (searchInfoArray == null) {
            throw new IllegalArgumentException();
        }
        if (searchInfoArray.length == 0) {
            this.elements = null;
            this.elementIndex = 0;
            this.upToDate = true;
        } else {
            this.elements = searchInfoArray;
            this.elementIndex = 0;
            this.elementIterator = searchInfoArray[0].objectsToSearch();
            this.upToDate = false;
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.upToDate) {
            this.update();
        }
        return this.elements != null && this.elementIndex < this.elements.length;
    }

    @Override
    public DataObject next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.upToDate = false;
        return this.nextObject;
    }

    private void update() {
        assert (!this.upToDate);
        while (!this.elementIterator.hasNext()) {
            this.elements[this.elementIndex] = null;
            if (++this.elementIndex == this.elements.length) break;
            this.elementIterator = this.elements[this.elementIndex].objectsToSearch();
        }
        if (this.elementIndex < this.elements.length) {
            this.nextObject = this.elementIterator.next();
        } else {
            this.elementIterator = null;
            this.nextObject = null;
        }
        this.upToDate = true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

