/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public class ExplorerActions {
    private static CopyAction copy = null;
    private static CutAction cut = null;
    private static DeleteAction delete = null;
    private static PasteAction paste = null;
    private final CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private final CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private final DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private final OwnPaste pasteActionPerformer = new OwnPaste();
    private ActionStateUpdater actionStateUpdater;
    private ExplorerManager manager;
    private Boolean confirmDelete;
    private boolean attachPerformers;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerActions;

    public ExplorerActions() {
        this(true);
    }

    ExplorerActions(boolean bl) {
        this.attachPerformers = bl;
    }

    final Action copyAction() {
        return this.copyActionPerformer;
    }

    final Action cutAction() {
        return this.cutActionPerformer;
    }

    final Action deleteAction() {
        return this.deleteActionPerformer;
    }

    final Action pasteAction() {
        return this.pasteActionPerformer;
    }

    public synchronized void attach(ExplorerManager explorerManager) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = explorerManager;
        ExplorerPanel.associateActions(this, explorerManager);
        this.actionStateUpdater = new ActionStateUpdater();
        this.manager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.actionStateUpdater, (Object)this.manager));
        Clipboard clipboard = ExplorerActions.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.addClipboardListener((ClipboardListener)WeakListeners.create((Class)ClipboardListener.class, (EventListener)this.actionStateUpdater, (Object)exClipboard));
        }
        this.updateActions();
    }

    public synchronized void detach() {
        if (this.manager == null) {
            return;
        }
        this.actionStateUpdater = null;
        this.stopActions();
        this.manager = null;
    }

    ExplorerManager getAttachedManager() {
        return this.manager;
    }

    public final void setConfirmDelete(boolean bl) {
        this.confirmDelete = bl;
    }

    public final boolean isConfirmDelete() {
        return this.confirmDelete == null ? ExplorerPanel.isConfirmDelete() : this.confirmDelete;
    }

    private void stopActions() {
        if (this.copyActionPerformer != null) {
            if (this.attachPerformers) {
                if (copy.getActionPerformer() instanceof CopyCutActionPerformer) {
                    copy.setActionPerformer(null);
                }
                if (cut.getActionPerformer() instanceof CopyCutActionPerformer) {
                    cut.setActionPerformer(null);
                }
                paste.setPasteTypes(null);
                if (delete.getActionPerformer() instanceof DeleteActionPerformer) {
                    delete.setActionPerformer(null);
                }
            } else {
                this.copyActionPerformer.setEnabled(false);
                this.cutActionPerformer.setEnabled(false);
                this.deleteActionPerformer.setEnabled(false);
                this.pasteActionPerformer.setEnabled(false);
            }
        }
    }

    private void updateActions() {
        int n;
        if (this.manager == null) {
            return;
        }
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (copy == null) {
            copy = (CopyAction)CopyAction.findObject((Class)CopyAction.class, (boolean)true);
            cut = (CutAction)CutAction.findObject((Class)CutAction.class, (boolean)true);
            paste = (PasteAction)PasteAction.findObject((Class)PasteAction.class, (boolean)true);
            delete = (DeleteAction)DeleteAction.findObject((Class)DeleteAction.class, (boolean)true);
        }
        int n2 = n = nodeArray != null ? nodeArray.length : 0;
        if (n > 0) {
            int n3;
            boolean bl = false;
            if (n > 1) {
                HashMap hashMap = new HashMap(101);
                for (n3 = 0; n3 < n; ++n3) {
                    if (this.checkParents(nodeArray[n3], hashMap)) continue;
                    bl = true;
                    break;
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (!bl && nodeArray[n3].canCopy()) continue;
                if (this.attachPerformers) {
                    copy.setActionPerformer(null);
                    break;
                }
                this.copyActionPerformer.setEnabled(false);
                break;
            }
            if (n3 == n) {
                if (this.attachPerformers) {
                    copy.setActionPerformer((ActionPerformer)this.copyActionPerformer);
                } else {
                    this.copyActionPerformer.setEnabled(true);
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (!bl && nodeArray[n3].canCut()) continue;
                if (this.attachPerformers) {
                    cut.setActionPerformer(null);
                    break;
                }
                this.cutActionPerformer.setEnabled(false);
                break;
            }
            if (n3 == n) {
                if (this.attachPerformers) {
                    cut.setActionPerformer((ActionPerformer)this.cutActionPerformer);
                } else {
                    this.cutActionPerformer.setEnabled(true);
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (!bl && nodeArray[n3].canDestroy()) continue;
                if (this.attachPerformers) {
                    delete.setActionPerformer(null);
                    break;
                }
                this.deleteActionPerformer.setEnabled(false);
                break;
            }
            if (n3 == n) {
                if (this.attachPerformers) {
                    delete.setActionPerformer((ActionPerformer)this.deleteActionPerformer);
                } else {
                    this.deleteActionPerformer.setEnabled(true);
                }
            }
        } else if (this.attachPerformers) {
            copy.setActionPerformer(null);
            cut.setActionPerformer(null);
            delete.setActionPerformer(null);
        } else {
            this.copyActionPerformer.setEnabled(false);
            this.cutActionPerformer.setEnabled(false);
            this.deleteActionPerformer.setEnabled(false);
        }
        this.updatePasteAction(nodeArray);
    }

    private boolean checkParents(Node node, HashMap hashMap) {
        if (hashMap.get(node) != null) {
            return false;
        }
        hashMap.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (hashMap.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] nodeArray) {
        ExplorerManager explorerManager = this.manager;
        if (explorerManager == null) {
            if (this.attachPerformers) {
                paste.setPasteTypes(null);
            } else {
                this.pasteActionPerformer.setPasteTypes(null);
            }
            return;
        }
        if (nodeArray != null && nodeArray.length > 1) {
            if (this.attachPerformers) {
                paste.setPasteTypes(null);
            } else {
                this.pasteActionPerformer.setPasteTypes(null);
            }
            return;
        }
        Node node = explorerManager.getExploredContext();
        Node[] nodeArray2 = explorerManager.getSelectedNodes();
        if (nodeArray2 != null && nodeArray2.length == 1) {
            node = nodeArray2[0];
        }
        if (node != null) {
            Transferable transferable = ExplorerActions.getClipboard().getContents(this);
            this.updatePasteTypes(transferable, node);
        }
    }

    private void updatePasteTypes(Transferable transferable, Node node) {
        if (transferable != null) {
            PasteType[] pasteTypeArray;
            PasteType[] pasteTypeArray2 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferable);
            if (pasteTypeArray.length != 0) {
                if (this.attachPerformers) {
                    paste.setPasteTypes(pasteTypeArray);
                } else {
                    this.pasteActionPerformer.setPasteTypes(pasteTypeArray);
                }
                return;
            }
            boolean bl = false;
            try {
                bl = transferable.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    int n = multiTransferObject.getCount();
                    boolean bl2 = true;
                    Transferable[] transferableArray = new Transferable[n];
                    PasteType[] pasteTypeArray3 = new PasteType[n];
                    for (int i = 0; i < n; ++i) {
                        transferableArray[i] = multiTransferObject.getTransferableAt(i);
                        PasteType[] pasteTypeArray4 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferableArray[i]);
                        if (pasteTypeArray.length == 0) {
                            bl2 = false;
                            break;
                        }
                        pasteTypeArray3[i] = pasteTypeArray[0];
                    }
                    if (bl2) {
                        PasteType[] pasteTypeArray5 = new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray3)};
                        if (this.attachPerformers) {
                            paste.setPasteTypes(pasteTypeArray5);
                        } else {
                            this.pasteActionPerformer.setPasteTypes(pasteTypeArray5);
                        }
                        return;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.attachPerformers) {
            if (paste != null) {
                paste.setPasteTypes(null);
            }
        } else {
            this.pasteActionPerformer.setPasteTypes(null);
        }
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActionsState() {
        ActionStateUpdater actionStateUpdater;
        ExplorerActions explorerActions = this;
        synchronized (explorerActions) {
            actionStateUpdater = this.actionStateUpdater;
        }
        if (actionStateUpdater != null) {
            actionStateUpdater.update();
        }
    }

    private static class FixIssue29405Timer
    extends Timer {
        private boolean running;

        public FixIssue29405Timer(int n, ActionListener actionListener) {
            super(n, actionListener);
        }

        public void restart() {
            super.restart();
            this.running = true;
        }

        public void stop() {
            this.running = false;
            super.stop();
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    private class ActionStateUpdater
    implements PropertyChangeListener,
    ClipboardListener,
    ActionListener {
        private final Timer timer = new FixIssue29405Timer(150, this);
        private boolean planned;

        ActionStateUpdater() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.timer.restart();
            this.planned = true;
        }

        public void clipboardChanged(ClipboardEvent clipboardEvent) {
            final ExplorerManager explorerManager = ExplorerActions.this.manager;
            if (!clipboardEvent.isConsumed() && explorerManager != null) {
                Mutex.EVENT.writeAccess(new Runnable(){

                    public void run() {
                        ExplorerActions.this.updatePasteAction(explorerManager.getSelectedNodes());
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ExplorerActions.this.updateActions();
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                this.timer.stop();
                this.planned = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            boolean bl;
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                bl = this.planned;
                this.planned = false;
            }
            if (bl) {
                this.timer.stop();
                ExplorerActions.this.updateActions();
            }
        }
    }

    private class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        DeleteActionPerformer() {
        }

        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        public void performAction(SystemAction systemAction) {
            Node[] nodeArray = ExplorerActions.this.manager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            if (!ExplorerActions.this.isConfirmDelete() || this.doConfirm(nodeArray)) {
                try {
                    if (ExplorerActions.this.manager != null) {
                        ExplorerActions.this.manager.setSelectedNodes(new Node[0]);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(nodeArray);
                class Run
                implements Runnable {
                    Run() {
                    }

                    public void run() {
                        if (ExplorerActions.this.attachPerformers) {
                            delete.setActionPerformer(null);
                        } else {
                            DeleteActionPerformer.this.setEnabled(false);
                        }
                    }
                }
                Mutex.EVENT.readAccess((Runnable)new Run());
            }
        }

        private boolean doConfirm(Node[] nodeArray) {
            String string;
            String string2;
            boolean bl = true;
            for (int i = 0; i < nodeArray.length; ++i) {
                if (Boolean.TRUE.equals(nodeArray[i].getValue("customDelete"))) continue;
                bl = false;
                break;
            }
            if (bl) {
                return true;
            }
            if (nodeArray.length == 1) {
                string2 = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObject", (Object)nodeArray[0].getDisplayName());
                string = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjectTitle");
            } else {
                string2 = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjects", (Object)new Integer(nodeArray.length));
                string = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjectsTitle");
            }
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, string, 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation));
        }

        private void doDestroy(final Node[] nodeArray) {
            try {
                Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        for (int i = 0; i < nodeArray.length; ++i) {
                            try {
                                nodeArray[i].destroy();
                                continue;
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                        }
                    }
                });
            }
            catch (IOException iOException) {
                throw (IllegalStateException)new IllegalStateException(iOException.toString()).initCause(iOException);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.performAction(null);
        }
    }

    private class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        private boolean copyCut;

        public CopyCutActionPerformer(boolean bl) {
            this.copyCut = bl;
        }

        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        public void performAction(SystemAction systemAction) {
            Transferable[] transferableArray;
            Transferable transferable = null;
            Node[] nodeArray = ExplorerActions.this.manager.getSelectedNodes();
            if (nodeArray.length != 1) {
                transferableArray = new Transferable[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    transferableArray[i] = this.getTransferableOwner(nodeArray[i]);
                    if (transferableArray[i] != null) continue;
                    return;
                }
                transferable = new ExTransferable.Multi(transferableArray);
            } else {
                transferable = this.getTransferableOwner(nodeArray[0]);
            }
            if (transferable != null) {
                transferableArray = ExplorerActions.getClipboard();
                transferableArray.setContents(transferable, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copyCut ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException iOException) {
                Logger.getLogger((class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions).getName()).log(Level.WARNING, null, iOException);
                return null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.performAction(null);
        }
    }

    private class OwnPaste
    extends AbstractAction {
        private PasteType[] pasteTypes = new PasteType[0];

        OwnPaste() {
        }

        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPasteTypes(PasteType[] pasteTypeArray) {
            OwnPaste ownPaste = this;
            synchronized (ownPaste) {
                this.pasteTypes = pasteTypeArray;
            }
            this.setEnabled(pasteTypeArray != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.pasteTypes == null) {
                throw new IllegalStateException("Should not be invoked at all. Paste types: null");
            }
            throw new IllegalStateException("Should not be invoked at all. Paste types: " + Arrays.asList(this.pasteTypes));
        }

        public Object getValue(String string) {
            ExplorerActions.this.updateActionsState();
            if ("delegates".equals(string)) {
                return this.pasteTypes;
            }
            return super.getValue(string);
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.t = transferableArray;
            this.p = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            int n = this.p.length;
            Transferable[] transferableArray = new Transferable[n];
            for (int i = 0; i < n; ++i) {
                Transferable transferable = this.p[i].paste();
                transferableArray[i] = transferable != null ? transferable : this.t[i];
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }
}

