/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.logpane.IRConsoleTopComponent;
import com.jaspersoft.ireport.designer.logpane.LogTextArea;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.JRViewerTopComponent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Mutex;

public class ReportRunner
implements Runnable {
    protected static final String VERSION_SUPPORT_REPORT_LOCALE = "2.0.1";
    private RepositoryReportUnit reportUnit;
    private Map map;
    private JServer server;
    private LogTextArea lta;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)("Executing " + this.getReportUnit().getDescriptor().getLabel()));
        try {
            handle.start();
            this.lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + JasperServerManager.getFormattedString("compiler.fillReportOnServer", "Filling report on server: {0}", new Object[]{"" + this.getServer().getUrl()}) + "</b> </font><hr>", true);
            Map params = this.getReportParameters();
            final JasperPrint print = this.getServer().getWSClient().runReport(this.getReportUnit().getDescriptor(), params);
            if (print != null) {
                handle.setDisplayName("Showing " + this.getReportUnit().getDescriptor().getLabel());
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        JRViewerTopComponent win = JRViewerTopComponent.findInstance();
                        win.setJasperPrint(print);
                        win.open();
                        win.requestActive();
                    }
                });
            }
        }
        catch (Exception t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            sw.flush();
            this.lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\">" + t.getMessage() + "</font><hr>", true);
            this.lta.logOnConsole(sw.toString(), false);
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    IRConsoleTopComponent win = IRConsoleTopComponent.findInstance();
                    win.open();
                    win.requestActive();
                }
            });
        }
        finally {
            handle.finish();
        }
    }

    protected Map getReportParameters() throws Exception {
        String locale;
        HashMap<String, String> params = new HashMap<String, String>(this.getMap());
        String serverVersion = this.getServer().getWSClient().getVersion();
        if (VERSION_SUPPORT_REPORT_LOCALE.compareTo(serverVersion) <= 0 && !params.containsKey("REPORT_LOCALE") && (locale = this.getReportLocale()) != null && locale.length() > 0) {
            params.put("REPORT_LOCALE", locale);
        }
        return params;
    }

    protected String getReportLocale() {
        return IReportManager.getInstance().getProperty("reportLocale");
    }

    public RepositoryReportUnit getReportUnit() {
        return this.reportUnit;
    }

    public void setReportUnit(RepositoryReportUnit reportUnit) {
        this.reportUnit = reportUnit;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public LogTextArea getLta() {
        return this.lta;
    }

    public void setLta(LogTextArea lta) {
        this.lta = lta;
    }
}

