/*
 * Decompiled with CFR 0.152.
 */
package rex.olap.util;

public class StringUtil {
    public static String bracketsAround(String orig) {
        if (orig.startsWith("[") && orig.endsWith("]")) {
            return orig;
        }
        return "[" + orig + "]";
    }

    public static String[] splitUniqueName(String uniqueName) {
        String str = uniqueName.trim();
        int l2 = str.length() - 1;
        if (str.charAt(0) != '[' || str.charAt(l2) != ']') {
            return new String[]{uniqueName};
        }
        str = str.substring(1, l2);
        String[] nameParts = str.split("\\]\\.\\[");
        return nameParts;
    }

    public static String createUName(String[] strs, int n) {
        if (n <= 0) {
            n = strs.length;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append('[');
            sb.append(strs[i]);
            sb.append(']');
        }
        return sb.toString();
    }

    public static String dimFromUName(String uName) {
        String[] strs = StringUtil.splitUniqueName(uName);
        return "[" + strs[0] + "]";
    }

    public static String parentFromUName(String uName) {
        String[] strs = StringUtil.splitUniqueName(uName);
        int n = strs.length;
        if (n < 3) {
            return null;
        }
        return StringUtil.createUName(strs, n - 1);
    }
}

