/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXDatePickerFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final Logger LOG = Logger.getLogger(JXDatePickerFormatter.class.getName());
    private DateFormat[] _formats = null;

    public JXDatePickerFormatter() {
        this(null);
    }

    public JXDatePickerFormatter(DateFormat[] formats) {
        if (formats == null) {
            formats = this.createDefaultFormats();
        }
        Contract.asNotNull(formats, "The array of DateFormats must not contain null formats");
        this._formats = formats;
    }

    public DateFormat[] getFormats() {
        DateFormat[] results = new DateFormat[this._formats.length];
        System.arraycopy(this._formats, 0, results, 0, results.length);
        return results;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Date result = null;
        ParseException pex = null;
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        for (DateFormat _format : this._formats) {
            try {
                result = _format.parse(text);
                pex = null;
                break;
            }
            catch (ParseException ex) {
                pex = ex;
            }
        }
        if (pex != null) {
            throw pex;
        }
        return result;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value != null && this._formats.length > 0) {
            return this._formats[0].format(value);
        }
        return null;
    }

    protected DateFormat[] createDefaultFormats() {
        ArrayList<DateFormat> f = new ArrayList<DateFormat>();
        this.addFormat(f, "JXDatePicker.longFormat");
        this.addFormat(f, "JXDatePicker.mediumFormat");
        this.addFormat(f, "JXDatePicker.shortFormat");
        return f.toArray(new DateFormat[f.size()]);
    }

    private void addFormat(List<DateFormat> f, String key) {
        String longFormat = UIManager.getString(key);
        try {
            SimpleDateFormat format = new SimpleDateFormat(longFormat);
            f.add(format);
        }
        catch (RuntimeException e) {
            LOG.finer("creating date format failed for key/pattern: " + key + "/" + longFormat);
        }
    }
}

