/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.editor.ExpObject;
import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;

public final class ReportGroupVisualPanel1 extends JPanel {

    
    /** Creates new form ReportGroupVisualPanel1 */
    private ReportGroupWizardPanel1 wizardPanel = null;
    public ReportGroupVisualPanel1( ReportGroupWizardPanel1 wPanel) {
        initComponents();
        this.wizardPanel = wPanel;
        
        jComboBoxObject.setRenderer(new ExpObjectCellRenderer());
        jRTextExpressionArea.getExpressionEditorPane().getDocument().addDocumentListener( new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
            }
            public void insertUpdate(DocumentEvent e) {
                if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
            }
            public void removeUpdate(DocumentEvent e) {
                if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
            }
        });
        
        jTextField1.getDocument().addDocumentListener( new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
            }
            public void insertUpdate(DocumentEvent e) {
                if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
            }
            public void removeUpdate(DocumentEvent e) {
                if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
            }
        });
        
        List values = new ArrayList();
        
        if (getWizardPanel() != null && getWizardPanel().getJasperDesign() != null)
        {
            values.addAll( wizardPanel.getJasperDesign().getFieldsList());
            values.addAll( wizardPanel.getJasperDesign().getVariablesList());
            values.addAll( wizardPanel.getJasperDesign().getParametersList());
        }
        
        for (int i=0; i<values.size(); ++i)
        {
            jComboBoxObject.addItem(new ExpObject( values.get(i) ));
        }
        if (jComboBoxObject.getItemCount() > 0)
        {
            jComboBoxObject.setSelectedIndex(0);
        }
        
        jRTextExpressionArea.setExpressionContext(new ExpressionContext(wizardPanel.getJasperDesign().getMainDesignDataset()));
        
    }
    
    public String getName() {
        return I18n.getString("ReportGroupVisualPanel1.Name.GroupCriteria");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jLabelErrorMessage = new javax.swing.JLabel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jComboBoxObject = new javax.swing.JComboBox();
        jRadioButton2 = new javax.swing.JRadioButton();
        jRTextExpressionArea = new com.jaspersoft.ireport.designer.editor.ExpressionEditorArea();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, I18n.getString("ReportGroupVisualPanel1.Label.GroupName")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.insets = new java.awt.Insets(20, 24, 0, 24);
        add(jLabel1, gridBagConstraints);

        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 24, 0, 10);
        add(jTextField1, gridBagConstraints);

        jLabelErrorMessage.setForeground(new java.awt.Color(255, 0, 0));
        org.openide.awt.Mnemonics.setLocalizedText(jLabelErrorMessage, " ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 25, 0, 10);
        add(jLabelErrorMessage, gridBagConstraints);

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton1, I18n.getString("ReportGroupVisualPanel1.RadioButton.GroupBy")); // NOI18N
        jRadioButton1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(20, 24, 0, 10);
        add(jRadioButton1, gridBagConstraints);

        jComboBoxObject.setMinimumSize(new java.awt.Dimension(28, 20));
        jComboBoxObject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxObjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 40, 0, 10);
        add(jComboBoxObject, gridBagConstraints);

        buttonGroup1.add(jRadioButton2);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton2, I18n.getString("ReportGroupVisualPanel1.RadioButton.GroupBy2")); // NOI18N
        jRadioButton2.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton2.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton2ActionPerformed(evt);
            }
        });
        jRadioButton2.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                jRadioButton2PropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(16, 24, 0, 10);
        add(jRadioButton2, gridBagConstraints);

        jRTextExpressionArea.setMinimumSize(new java.awt.Dimension(300, 120));
        jRTextExpressionArea.setPreferredSize(new java.awt.Dimension(300, 120));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(4, 40, 20, 10);
        add(jRTextExpressionArea, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField1ActionPerformed
        
    }//GEN-LAST:event_jTextField1ActionPerformed

    private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
        if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
    }//GEN-LAST:event_jRadioButton1ActionPerformed

    private void jComboBoxObjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxObjectActionPerformed
        if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
    }//GEN-LAST:event_jComboBoxObjectActionPerformed

    private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
        if (getWizardPanel() != null) getWizardPanel().fireChangeEvent();
    }//GEN-LAST:event_jRadioButton2ActionPerformed

    private void jRadioButton2PropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_jRadioButton2PropertyChange
        
    }//GEN-LAST:event_jRadioButton2PropertyChange

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JComboBox jComboBoxObject;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelErrorMessage;
    private com.jaspersoft.ireport.designer.editor.ExpressionEditorArea jRTextExpressionArea;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JTextField jTextField1;
    // End of variables declaration//GEN-END:variables

    
    /**
     * This method checks that all the mandatory fields are
     * filled. This is not the best place for this method, it
     * should go in ReportGroupWizardPanel1, but here it's more
     * easy access each single UI component.
     * This method is called by ReportGroupWizardPanel1.validateForm()
     */
    public boolean validateForm()
    {
        if (jTextField1.getText().trim().length() == 0) return false;
        
        // Check it the group name is already in use...
        List v = getWizardPanel().getJasperDesign().getGroupsList();
        String s = jTextField1.getText().trim();
        jLabelErrorMessage.setText(" ");

        for (int i=0; i<v.size(); ++i)
        {
            if (s.equals( ((JRGroup)v.get(i)).getName()))
            {
               jLabelErrorMessage.setText(I18n.getString("ReportGroupVisualPanel1.Message.Error"));
               return false;
            }
        }
            
        if (jRadioButton1.isSelected() && jComboBoxObject.getSelectedItem() != null) return true;
        if (jRadioButton2.isSelected() && jRTextExpressionArea.getText().trim().length() > 0) return true;
        
        return false;
    }

    public ReportGroupWizardPanel1 getWizardPanel() {
        return wizardPanel;
    }

    public void setWizardPanel(ReportGroupWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    public String getGroupName() {
        return jTextField1.getText().trim();
    }

    public String getGroupExpression() {
        if (jRadioButton1.isSelected())
        {
            Object obj = jComboBoxObject.getSelectedItem();
            if (obj == null) return null;
            String text = null;
            if (obj instanceof JRVariable)
            {
                text = "$V{" + ((JRVariable)obj).getName() + "}";
            }
            else if (obj instanceof JRField)
            {
                text = "$F{" + ((JRField)obj).getName() + "}";
            }
            else if (obj instanceof JRParameter)
            {
                text = "$P{" + ((JRParameter)obj).getName() + "}";
            }
            else if (obj instanceof ExpObject)
            {
                text = ((ExpObject)obj).getExpression();
            }
            
            return text;
        }
        else
        {
            return jRTextExpressionArea.getText();
        }
    }
}

