/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fonts.FontBundle;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.util.AwtFontDeriver;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;

public class JRFontUtil {
    private static final AwtFontDeriver FONT_DERIVER = System.getProperty("java.version").startsWith("1.4") ? AwtFontDeriver.JDK14_AWT_FONT_DERIVER : AwtFontDeriver.DEFAULT_AWT_FONT_DERIVER;

    public static void copyNonNullOwnProperties(JRFont srcFont, JRFont destFont) {
        if (srcFont != null && destFont != null) {
            if (srcFont.getOwnFontName() != null) {
                destFont.setFontName(srcFont.getOwnFontName());
            }
            if (srcFont.isOwnBold() != null) {
                destFont.setBold(srcFont.isOwnBold());
            }
            if (srcFont.isOwnItalic() != null) {
                destFont.setItalic(srcFont.isOwnItalic());
            }
            if (srcFont.isOwnUnderline() != null) {
                destFont.setUnderline(srcFont.isOwnUnderline());
            }
            if (srcFont.isOwnStrikeThrough() != null) {
                destFont.setStrikeThrough(srcFont.isOwnStrikeThrough());
            }
            if (srcFont.getOwnFontSize() != null) {
                destFont.setFontSize(srcFont.getOwnFontSize());
            }
            if (srcFont.getOwnPdfFontName() != null) {
                destFont.setPdfFontName(srcFont.getOwnPdfFontName());
            }
            if (srcFont.getOwnPdfEncoding() != null) {
                destFont.setPdfEncoding(srcFont.getOwnPdfEncoding());
            }
            if (srcFont.isOwnPdfEmbedded() != null) {
                destFont.setPdfEmbedded(srcFont.isOwnPdfEmbedded());
            }
        }
    }

    public static Map getAttributes(Map attributes, JRFont font, Locale locale) {
        Font awtFont = JRFontUtil.getAwtFontFromBundles(font.getFontName(), (font.isBold() ? 1 : 0) | (font.isItalic() ? 2 : 0), font.getFontSize(), locale);
        if (awtFont != null) {
            attributes.put(TextAttribute.FONT, awtFont);
        }
        JRFontUtil.getAttributesWithoutAwtFont(attributes, font);
        return attributes;
    }

    private static Map getAttributesWithoutAwtFont(Map attributes, JRFont font) {
        attributes.put(TextAttribute.FAMILY, font.getFontName());
        attributes.put(TextAttribute.SIZE, new Float(font.getFontSize()));
        if (font.isBold()) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (font.isItalic()) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (font.isUnderline()) {
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (font.isStrikeThrough()) {
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        attributes.put(JRTextAttribute.PDF_FONT_NAME, font.getPdfFontName());
        attributes.put(JRTextAttribute.PDF_ENCODING, font.getPdfEncoding());
        if (font.isPdfEmbedded()) {
            attributes.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.TRUE);
        }
        return attributes;
    }

    public static FontInfo getFontInfo(String name, Locale locale) {
        List bundles = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontBundle.class);
        Iterator itb = bundles.iterator();
        while (itb.hasNext()) {
            FontBundle bundle = (FontBundle)itb.next();
            List families = bundle.getFontFamilies();
            Iterator itf = families.iterator();
            while (itf.hasNext()) {
                FontFamily family = (FontFamily)itf.next();
                if (locale != null && !family.supportsLocale(locale)) continue;
                if (name.equals(family.getName())) {
                    return new FontInfo(family, null, 0);
                }
                FontFace face = family.getNormalFace();
                if (face != null && name.equals(face.getName())) {
                    return new FontInfo(family, face, 0);
                }
                face = family.getBoldFace();
                if (face != null && name.equals(face.getName())) {
                    return new FontInfo(family, face, 1);
                }
                face = family.getItalicFace();
                if (face != null && name.equals(face.getName())) {
                    return new FontInfo(family, face, 2);
                }
                face = family.getBoldItalicFace();
                if (face == null || !name.equals(face.getName())) continue;
                return new FontInfo(family, face, 3);
            }
        }
        return null;
    }

    public static Collection getFontFamilyNames() {
        TreeSet<String> familyNames = new TreeSet<String>();
        List bundles = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontBundle.class);
        Iterator itb = bundles.iterator();
        while (itb.hasNext()) {
            FontBundle bundle = (FontBundle)itb.next();
            List families = bundle.getFontFamilies();
            Iterator itf = families.iterator();
            while (itf.hasNext()) {
                FontFamily family = (FontFamily)itf.next();
                familyNames.add(family.getName());
            }
        }
        return familyNames;
    }

    public static Font getAwtFontFromBundles(String name, int style, int size, Locale locale) {
        Font awtFont = null;
        FontInfo fontInfo = JRFontUtil.getFontInfo(name, locale);
        if (fontInfo != null) {
            int faceStyle = 0;
            FontFamily family = fontInfo.getFontFamily();
            FontFace face = fontInfo.getFontFace();
            if (face == null) {
                if ((style & 1) > 0 && (style & 2) > 0) {
                    face = family.getBoldItalicFace();
                    faceStyle = 3;
                }
                if (face == null && (style & 1) > 0) {
                    face = family.getBoldFace();
                    faceStyle = 1;
                }
                if (face == null && (style & 2) > 0) {
                    face = family.getItalicFace();
                    faceStyle = 2;
                }
                if (face == null) {
                    face = family.getNormalFace();
                    faceStyle = 0;
                }
                if (face == null) {
                    throw new JRRuntimeException("Font family '" + family.getName() + "' does not have the normal font face.");
                }
            } else {
                faceStyle = fontInfo.getStyle();
            }
            if ((awtFont = face.getFont()) == null) {
                throw new JRRuntimeException("The '" + face.getName() + "' font face in family '" + family.getName() + "' returns a null font.");
            }
            awtFont = awtFont.deriveFont((float)size);
            awtFont = FONT_DERIVER.deriveFont(awtFont, name, style, faceStyle);
        }
        return awtFont;
    }

    public static Font getAwtFont(JRFont font, Locale locale) {
        if (font == null) {
            return null;
        }
        Font awtFont = JRFontUtil.getAwtFontFromBundles(font.getFontName(), (font.isBold() ? 1 : 0) | (font.isItalic() ? 2 : 0), font.getFontSize(), locale);
        if (awtFont == null) {
            awtFont = new Font(JRFontUtil.getAttributesWithoutAwtFont(new HashMap(), font));
        }
        return awtFont;
    }
}

