/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors.box;

import com.jaspersoft.ireport.designer.sheet.editors.box.BorderSelectionListener;
import com.jaspersoft.ireport.designer.sheet.editors.box.CompoundStroke;
import com.jaspersoft.ireport.designer.sheet.editors.box.ShapeStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxBorderSelectionPanel
extends JPanel {
    private static final int BORDER_GAP = 15;
    private static final int REF_SIZE = 8;
    private static final int REF_DINSTANCE = 4;
    private List<Side> selectedBorders = new ArrayList<Side>();
    List<BorderSelectionListener> listeners = new ArrayList<BorderSelectionListener>();
    private JRLineBox lineBox = null;

    public void clearSelection() {
        this.selectedBorders.clear();
        this.repaint();
        this.fireBorderSelectionChange();
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setLineBox(JRLineBox lineBox) {
        this.lineBox = lineBox;
    }

    public List<Side> getSelectedBorders() {
        return this.selectedBorders;
    }

    public void setSelectedBorders(List<Side> selectedBorders) {
        this.selectedBorders = selectedBorders;
    }

    public void addBorderSelectionListener(BorderSelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeBorderSelectionListener(BorderSelectionListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public BoxBorderSelectionPanel() {
        this.initComponents();
    }

    @Override
    public void paint(Graphics g) {
        Stroke stroke;
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        Stroke oldStroke = g2d.getStroke();
        Stroke defaultStroke = new BasicStroke(1.0f);
        g2d.setStroke(defaultStroke);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.drawLine(3, 15, 11, 15);
        g2d.drawLine(this.getWidth() - 15 + 4, 15, this.getWidth() - 15 + 12, 15);
        g2d.drawLine(3, this.getHeight() - 15, 11, this.getHeight() - 15);
        g2d.drawLine(this.getWidth() - 15 + 4, this.getHeight() - 15, this.getWidth() - 15 + 12, this.getHeight() - 15);
        g2d.drawLine(15, 3, 15, 11);
        g2d.drawLine(this.getWidth() - 15, 11, this.getWidth() - 15, 3);
        g2d.drawLine(15, this.getHeight() - 15 + 4, 15, this.getHeight() - 15 + 12);
        g2d.drawLine(this.getWidth() - 15, this.getHeight() - 15 + 4, this.getWidth() - 15, this.getHeight() - 15 + 12);
        g2d.setColor(Color.BLACK);
        boolean defaultPaint = false;
        Color defaultColor = Color.BLACK;
        if (this.getLineBox() != null && this.getLineBox().getPen() != null) {
            Stroke stroke2 = BoxBorderSelectionPanel.createStroke((JRPen)this.getLineBox().getPen());
            if (stroke2 != null) {
                defaultStroke = stroke2;
            }
            boolean bl = defaultPaint = this.getLineBox().getPen().getLineWidth().floatValue() != 0.0f;
            if (this.getLineBox().getPen().getLineColor() != null) {
                defaultColor = this.getLineBox().getPen().getLineColor();
            }
        }
        g2d.setStroke(defaultStroke);
        g2d.setColor(defaultColor);
        boolean paint = defaultPaint;
        if (this.getLineBox() != null && this.getLineBox().getTopPen() != null) {
            if (this.getLineBox().getTopPen().getLineColor() != null) {
                g2d.setColor(this.getLineBox().getTopPen().getLineColor());
            }
            if ((stroke = BoxBorderSelectionPanel.createStroke((JRPen)this.getLineBox().getTopPen())) != null) {
                g2d.setStroke(stroke);
            }
            boolean bl = paint = this.getLineBox().getTopPen().getLineWidth().floatValue() != 0.0f;
        }
        if (paint) {
            g2d.drawLine(15, 15, this.getWidth() - 15, 15);
        }
        paint = defaultPaint;
        g2d.setStroke(defaultStroke);
        g2d.setColor(defaultColor);
        if (this.getLineBox() != null && this.getLineBox().getRightPen() != null) {
            if (this.getLineBox().getRightPen().getLineColor() != null) {
                g2d.setColor(this.getLineBox().getRightPen().getLineColor());
            }
            if ((stroke = BoxBorderSelectionPanel.createStroke((JRPen)this.getLineBox().getRightPen())) != null) {
                g2d.setStroke(stroke);
            }
            boolean bl = paint = this.getLineBox().getRightPen().getLineWidth().floatValue() != 0.0f;
        }
        if (paint) {
            g2d.drawLine(this.getWidth() - 15, 15, this.getWidth() - 15, this.getHeight() - 15);
        }
        paint = defaultPaint;
        g2d.setStroke(defaultStroke);
        g2d.setColor(defaultColor);
        if (this.getLineBox() != null && this.getLineBox().getBottomPen() != null) {
            if (this.getLineBox().getBottomPen().getLineColor() != null) {
                g2d.setColor(this.getLineBox().getBottomPen().getLineColor());
            }
            if ((stroke = BoxBorderSelectionPanel.createStroke((JRPen)this.getLineBox().getBottomPen())) != null) {
                g2d.setStroke(stroke);
            }
            boolean bl = paint = this.getLineBox().getBottomPen().getLineWidth().floatValue() != 0.0f;
        }
        if (paint) {
            g2d.drawLine(15, this.getHeight() - 15, this.getWidth() - 15, this.getHeight() - 15);
        }
        paint = defaultPaint;
        g2d.setStroke(defaultStroke);
        g2d.setColor(defaultColor);
        if (this.getLineBox() != null && this.getLineBox().getLeftPen() != null) {
            if (this.getLineBox().getLeftPen().getLineColor() != null) {
                g2d.setColor(this.getLineBox().getLeftPen().getLineColor());
            }
            if ((stroke = BoxBorderSelectionPanel.createStroke((JRPen)this.getLineBox().getLeftPen())) != null) {
                g2d.setStroke(stroke);
            }
            boolean bl = paint = this.getLineBox().getLeftPen().getLineWidth().floatValue() != 0.0f;
        }
        if (paint) {
            g2d.drawLine(15, 15, 15, this.getHeight() - 15);
        }
        paint = defaultPaint;
        Area a = new Area();
        BasicStroke stroke3 = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f);
        g2d.setStroke(stroke3);
        g.setColor(Color.DARK_GRAY);
        g.setXORMode(Color.WHITE);
        for (Side s : this.getSelectedBorders()) {
            switch (s) {
                case TOP: {
                    Rectangle2D.Float rect1 = new Rectangle2D.Float(10.0f, 10.0f, this.getWidth() - 30 + 10, 10.0f);
                    a.add(new Area(rect1));
                    g2d.draw(rect1);
                    break;
                }
                case RIGHT: {
                    Rectangle2D.Float rect2 = new Rectangle2D.Float(this.getWidth() - 15 - 5, 10.0f, 10.0f, this.getHeight() - 30 + 10);
                    a.add(new Area(rect2));
                    g2d.draw(rect2);
                    break;
                }
                case BOTTOM: {
                    Rectangle2D.Float rect3 = new Rectangle2D.Float(10.0f, this.getHeight() - 15 - 5, this.getWidth() - 30 + 10, 10.0f);
                    a.add(new Area(rect3));
                    g2d.draw(rect3);
                    break;
                }
                case LEFT: {
                    Rectangle2D.Float rect4 = new Rectangle2D.Float(10.0f, 10.0f, 10.0f, this.getHeight() - 30 + 10);
                    a.add(new Area(rect4));
                    g2d.draw(rect4);
                }
            }
            Area a2 = new Area(new Rectangle2D.Float(5.0f, 5.0f, this.getWidth() - 10, this.getHeight() - 10));
            a2.intersect(a);
        }
        g2d.setStroke(oldStroke);
    }

    private void fireBorderSelectionChange() {
        for (BorderSelectionListener listener : this.listeners) {
            try {
                listener.selectionChanged(this.getSelectedBorders());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                BoxBorderSelectionPanel.this.formMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                BoxBorderSelectionPanel.this.formMousePressed(evt);
            }
        });
        this.setLayout(null);
    }

    private void formMouseClicked(MouseEvent evt) {
    }

    private void formMousePressed(MouseEvent evt) {
        Rectangle2D.Float rect1 = new Rectangle2D.Float(10.0f, 10.0f, this.getWidth() - 30 + 10, 10.0f);
        Rectangle2D.Float rect2 = new Rectangle2D.Float(this.getWidth() - 15 - 5, 10.0f, 10.0f, this.getHeight() - 30 + 10);
        Rectangle2D.Float rect3 = new Rectangle2D.Float(10.0f, this.getHeight() - 15 - 5, this.getWidth() - 30 + 10, 10.0f);
        Rectangle2D.Float rect4 = new Rectangle2D.Float(10.0f, 10.0f, 10.0f, this.getHeight() - 30 + 10);
        boolean fireEvent = false;
        if (rect1.contains(evt.getPoint())) {
            if (!this.selectedBorders.contains((Object)Side.TOP)) {
                this.getSelectedBorders().add(Side.TOP);
            } else {
                this.getSelectedBorders().remove((Object)Side.TOP);
            }
            fireEvent = true;
        } else if (rect2.contains(evt.getPoint())) {
            if (!this.selectedBorders.contains((Object)Side.RIGHT)) {
                this.getSelectedBorders().add(Side.RIGHT);
            } else {
                this.getSelectedBorders().remove((Object)Side.RIGHT);
            }
            fireEvent = true;
        } else if (rect3.contains(evt.getPoint())) {
            if (!this.selectedBorders.contains((Object)Side.BOTTOM)) {
                this.getSelectedBorders().add(Side.BOTTOM);
            } else {
                this.getSelectedBorders().remove((Object)Side.BOTTOM);
            }
            fireEvent = true;
        } else if (rect4.contains(evt.getPoint())) {
            if (!this.selectedBorders.contains((Object)Side.LEFT)) {
                this.getSelectedBorders().add(Side.LEFT);
            } else {
                this.getSelectedBorders().remove((Object)Side.LEFT);
            }
            fireEvent = true;
        }
        this.repaint();
        if (fireEvent) {
            this.fireBorderSelectionChange();
        }
    }

    public static Stroke createStroke(JRPen pen) {
        if (pen == null) {
            return null;
        }
        if (pen.getLineWidth() == null || pen.getLineWidth().floatValue() == 0.0f) {
            return null;
        }
        float penWidth = pen.getLineWidth().floatValue();
        Stroke theStroke = new BasicStroke(penWidth);
        if (pen.getLineStyle() != null) {
            switch (pen.getLineStyle()) {
                case 1: {
                    theStroke = new BasicStroke(penWidth, 0, 2, 0.0f, new float[]{Math.max(1.0f, 5.0f * penWidth), Math.max(1.0f, 3.0f * penWidth)}, 0.0f);
                    break;
                }
                case 2: {
                    theStroke = new BasicStroke(penWidth, 0, 2, 0.0f, new float[]{Math.max(1.0f, 1.0f * penWidth), Math.max(1.0f, 1.0f * penWidth)}, 0.0f);
                    break;
                }
                case 3: {
                    ShapeStroke s1 = new ShapeStroke(new Rectangle2D.Float(0.0f, 0.0f, penWidth, penWidth), 1.0f * penWidth);
                    ShapeStroke s2 = new ShapeStroke(new Rectangle2D.Float(0.0f, penWidth / 2.0f, penWidth, penWidth / 3.0f), 1.0f * penWidth);
                    theStroke = new CompoundStroke(s1, s2, 1);
                    break;
                }
            }
        }
        return theStroke;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        TOP,
        LEFT,
        BOTTOM,
        RIGHT;

    }
}

