/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.editors.JRPropertiesMapPropertyCustomEditor;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class JRPropertiesMapPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private boolean customEd = true;
    private PropertyEnv env;

    public boolean isEditable() {
        return false;
    }

    public String getAsText() {
        Object val = this.getValue();
        if (val == null) {
            return I18n.getString("JRPMPE.Property.Nopropertiesset");
        }
        if (val instanceof List) {
            int len = ((List)val).size();
            switch (len) {
                case 0: {
                    return I18n.getString("JRPMPE.Property.Nopropertiesset");
                }
                case 1: {
                    return I18n.getString("JRPMPE.Property.Onepropertiesset");
                }
            }
            return len + I18n.getString("JRPMPE.Property.propertiesset");
        }
        if (val instanceof JRPropertiesMap) {
            int len = ((JRPropertiesMap)val).getPropertyNames().length;
            switch (len) {
                case 0: {
                    return I18n.getString("JRPMPE.Property.Nopropertiesset");
                }
                case 1: {
                    return I18n.getString("JRPMPE.Property.Onepropertiesset");
                }
            }
            return len + I18n.getString("JRPMPE.Property.propertiesset");
        }
        return "";
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Object val = this.getValue();
        return new JRPropertiesMapPropertyCustomEditor(val, this, this.env);
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        }
        this.env = env;
    }
}

