/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet;

import com.jaspersoft.ireport.designer.sheet.editors.JRPenPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.base.JRBasePen;

public class JRPenProperty
extends AbstractProperty {
    JRPen pen = null;
    JRPenPropertyEditor editor = null;
    JRPenContainer container = null;

    public JRPenProperty(JRPen pen, JRPenContainer container) {
        super(JRPen.class, pen);
        this.setName("pen");
        this.setDisplayName(I18n.getString("PenProperty.Property.Pen"));
        this.setShortDescription(I18n.getString("JRPenProperty.Property.detail"));
        this.setValue("canEditAsText", Boolean.FALSE);
        this.pen = pen;
        this.container = container;
    }

    public void setPen(JRPen mpen) {
        if (mpen != null) {
            this.pen.setLineColor(mpen.getOwnLineColor());
            this.pen.setLineWidth(mpen.getOwnLineWidth());
            this.pen.setLineStyle(mpen.getOwnLineStyle());
        } else {
            this.pen.setLineColor(null);
            this.pen.setLineWidth(null);
            this.pen.setLineStyle(null);
        }
    }

    public boolean isDefaultValue() {
        if (this.pen == null) {
            return true;
        }
        if (this.pen.getOwnLineColor() != null) {
            return false;
        }
        if (this.pen.getOwnLineWidth() != null) {
            return false;
        }
        return this.pen.getOwnLineStyle() == null;
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new JRPenPropertyEditor();
        }
        return this.editor;
    }

    public Object getPropertyValue() {
        return this.pen.clone(this.container);
    }

    public Object getOwnPropertyValue() {
        return this.pen.clone(this.container);
    }

    public Object getDefaultValue() {
        return new JRBasePen(null);
    }

    public void validate(Object value) {
    }

    public void setPropertyValue(Object value) {
        if (value instanceof JRPen) {
            this.setPen((JRPen)value);
        } else {
            this.setPen(null);
        }
    }
}

