/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.palette.actions.CreateReportElementAction;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class CreateTextFieldAction
extends CreateReportElementAction {
    private static List acceptedTextfieldClasses = null;

    public JRDesignElement createReportElement(JasperDesign jd) {
        JRDesignTextField element = new JRDesignTextField((JRDefaultStyleProvider)jd);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClassName("java.lang.String");
        exp.setText("$F{field}");
        element.setExpression((JRExpression)exp);
        element.setWidth(100);
        element.setHeight(20);
        return element;
    }

    public static void setMatchingClassExpression(JRDesignExpression expression, String newClassName, boolean adjustExpression) {
        if (!acceptedTextfieldClasses.contains(newClassName)) {
            try {
                IReportManager.getInstance();
                Class<?> newClass = IReportManager.getReportClassLoader().loadClass(newClassName);
                CreateTextFieldAction.setMatchingClassExpression(expression, newClass, adjustExpression);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            expression.setValueClassName(newClassName);
        }
    }

    private static void setMatchingClassExpression(JRDesignExpression expression, Class newClass, boolean adjustExpression) {
        Class superClass = newClass.getSuperclass();
        if (superClass == null) {
            expression.setValueClassName("java.lang.String");
            if (adjustExpression) {
                expression.setText("\"\"+" + expression.getText());
            }
        } else {
            CreateTextFieldAction.setMatchingClassExpression(expression, superClass.getName(), adjustExpression);
        }
    }

    static {
        acceptedTextfieldClasses = new ArrayList();
        acceptedTextfieldClasses.add("java.lang.Boolean");
        acceptedTextfieldClasses.add("java.lang.Byte");
        acceptedTextfieldClasses.add("java.util.Date");
        acceptedTextfieldClasses.add("java.sql.Timestamp");
        acceptedTextfieldClasses.add("java.sql.Time");
        acceptedTextfieldClasses.add("java.lang.Double");
        acceptedTextfieldClasses.add("java.lang.Float");
        acceptedTextfieldClasses.add("java.lang.Integer");
        acceptedTextfieldClasses.add("java.lang.Long");
        acceptedTextfieldClasses.add("java.lang.Short");
        acceptedTextfieldClasses.add("java.math.BigDecimal");
        acceptedTextfieldClasses.add("java.lang.Number");
        acceptedTextfieldClasses.add("java.lang.String");
    }
}

